/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

class MidiKeyboardPanel
extends JPanel {
    MidiEventDialog event_dialog;
    Action query_send_event_action = new AbstractAction(){
        {
            this.putValue("Name", "Send MIDI event");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MidiKeyboardPanel.this.event_dialog.setTitle("Send MIDI event");
            MidiKeyboardPanel.this.event_dialog.ok_button.setAction(MidiKeyboardPanel.this.send_event_action);
            MidiKeyboardPanel.this.event_dialog.midi_message_form.channel_text.setSelectedChannel(MidiKeyboardPanel.this.keyboard_center_panel.keyboard.midi_ch_combobox_model.getSelectedChannel());
            MidiKeyboardPanel.this.event_dialog.openMessageForm();
        }
    };
    Action send_event_action = new AbstractAction(){
        {
            this.putValue("Name", "Send");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MidiKeyboardPanel.this.keyboard_center_panel.keyboard.midi_device.sendMidiMessage(MidiKeyboardPanel.this.event_dialog.midi_message_form.getMessage());
        }
    };
    Insets zero_insets = new Insets(0, 0, 0, 0);
    KeySignatureSelecter key_selecter = new KeySignatureSelecter(false);
    JButton send_event_button = new JButton(this.query_send_event_action);
    JPanel keyboard_chord_panel;
    JPanel keyboard_south_panel;
    PianoKeyboardPanel keyboard_center_panel = new PianoKeyboardPanel();
    MidiChannelComboSelecter midi_ch_combobox;
    MidiChannelButtonSelecter midi_ch_buttons;
    VelocitySelecter velocity_selecter;

    public MidiKeyboardPanel(ChordMatrix chordMatrix) {
        this.midi_ch_combobox = new MidiChannelComboSelecter("MIDI Channel", this.keyboard_center_panel.keyboard.midi_ch_combobox_model);
        this.midi_ch_buttons = new MidiChannelButtonSelecter(this.keyboard_center_panel.keyboard);
        this.velocity_selecter = new VelocitySelecter(this.keyboard_center_panel.keyboard.velocity_model);
        this.keyboard_center_panel.keyboard.chord_matrix = chordMatrix;
        this.keyboard_center_panel.keyboard.chord_display = new ChordDisplay("MIDI Keyboard", chordMatrix, this.keyboard_center_panel.keyboard);
        this.keyboard_chord_panel = new JPanel();
        this.keyboard_chord_panel.setLayout(new BoxLayout(this.keyboard_chord_panel, 0));
        this.keyboard_chord_panel.add(Box.createHorizontalStrut(5));
        this.keyboard_chord_panel.add(this.velocity_selecter);
        this.keyboard_chord_panel.add(this.key_selecter);
        this.keyboard_chord_panel.add(this.keyboard_center_panel.keyboard.chord_display);
        this.keyboard_chord_panel.add(Box.createHorizontalStrut(5));
        this.send_event_button.setMargin(this.zero_insets);
        this.keyboard_south_panel = new JPanel();
        this.keyboard_south_panel.setLayout(new BoxLayout(this.keyboard_south_panel, 0));
        this.keyboard_south_panel.add(this.midi_ch_combobox);
        this.keyboard_south_panel.add(this.midi_ch_buttons);
        this.keyboard_south_panel.add(this.send_event_button);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.keyboard_chord_panel);
        this.add(this.keyboard_center_panel);
        this.add(Box.createVerticalStrut(5));
        this.add(this.keyboard_south_panel);
    }

    public void setDarkMode(boolean bl) {
        Color color = bl ? Color.black : null;
        this.setBackground(color);
        this.keyboard_center_panel.setDarkMode(bl);
        this.keyboard_chord_panel.setBackground(color);
        this.keyboard_south_panel.setBackground(color);
        this.midi_ch_buttons.setBackground(color);
        this.midi_ch_combobox.setBackground(color);
        this.midi_ch_combobox.combo_box.setBackground(color);
        this.key_selecter.setBackground(color);
        this.key_selecter.keysig_combobox.setBackground(color);
        this.velocity_selecter.setBackground(color);
        this.keyboard_center_panel.keyboard.chord_display.setDarkMode(bl);
        this.send_event_button.setBackground(color);
    }
}

