/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MidiMessageForm
extends JPanel
implements ActionListener {
    DefaultComboBoxModel status_combo_box_model = new DefaultComboBoxModel();
    DefaultComboBoxModel note_combo_box_model = new DefaultComboBoxModel();
    DefaultComboBoxModel percussion_combo_box_model = new DefaultComboBoxModel();
    DefaultComboBoxModel control_change_combo_box_model = new DefaultComboBoxModel();
    DefaultComboBoxModel instrument_combo_box_model = new DefaultComboBoxModel();
    DefaultComboBoxModel meta_type_combo_box_model = new DefaultComboBoxModel();
    DefaultComboBoxModel hex_data1_combo_box_model = new DefaultComboBoxModel();
    DefaultComboBoxModel hex_data2_combo_box_model = new DefaultComboBoxModel();
    HexSelecter status_text = new HexSelecter("Status/Command");
    HexSelecter data1_text = new HexSelecter("[Data1] ");
    HexSelecter data2_text = new HexSelecter("[Data2] ");
    MidiChannelComboSelecter channel_text = new MidiChannelComboSelecter("MIDI Channel");
    JComboBox status_combo_box = this.status_text.getComboBox();
    JComboBox data1_combo_box = this.data1_text.getComboBox();
    JComboBox data2_combo_box = this.data2_text.getComboBox();
    JComboBox channel_combo_box = this.channel_text.getComboBox();
    HexTextForm data_text = new HexTextForm("Data:", 3, 50);
    PianoKeyboardPanel keyboard_panel = new PianoKeyboardPanel();
    DurationForm duration_form = new DurationForm();
    TempoSelecter tempo_selecter = new TempoSelecter();
    TimeSignatureSelecter timesig_selecter = new TimeSignatureSelecter();
    KeySignatureSelecter keysig_selecter = new KeySignatureSelecter();
    private MidiChannel[] midi_channels = null;
    private boolean is_duration_visible = true;

    public MidiMessageForm() {
        String string;
        int n;
        for (n = 128; n <= 224; n += 16) {
            string = MIDISpec.getStatusName(n);
            if (string == null) continue;
            this.status_combo_box_model.addElement(String.format("0x%02X : %s", n, string));
        }
        for (n = 240; n <= 255; ++n) {
            string = MIDISpec.getStatusName(n);
            if (string == null) continue;
            this.status_combo_box_model.addElement(String.format("0x%02X : %s", n, string));
        }
        for (n = 0; n <= 127; ++n) {
            this.note_combo_box_model.addElement(String.format("0x%02X : %d : %s", n, n, Music.noteNoToSymbol(n)));
        }
        for (n = 0; n <= 127; ++n) {
            this.percussion_combo_box_model.addElement(String.format("0x%02X : %d : %s", n, n, MIDISpec.getPercussionName(n)));
        }
        for (n = 0; n <= 127; ++n) {
            string = MIDISpec.getControllerName(n);
            if (string == null) continue;
            this.control_change_combo_box_model.addElement(String.format("0x%02X : %d : %s", n, n, string));
        }
        for (n = 0; n <= 127; ++n) {
            this.instrument_combo_box_model.addElement(String.format("0x%02X : %s", n, MIDISpec.instrument_names[n]));
        }
        for (n = 0; n <= 127; ++n) {
            this.hex_data1_combo_box_model.addElement(String.format("0x%02X : %d", n, n));
        }
        for (n = 0; n <= 127; ++n) {
            this.hex_data2_combo_box_model.addElement(String.format("0x%02X : %d", n, n));
        }
        String string2 = null;
        for (int i = 0; i < 128; ++i) {
            string = MIDISpec.getMetaName(i);
            if (string == null) continue;
            string = String.format("0x%02X : %s", i, string);
            this.meta_type_combo_box_model.addElement(string);
            if (i != 81) continue;
            string2 = string;
        }
        this.meta_type_combo_box_model.setSelectedItem(string2);
        this.keyboard_panel.keyboard.setPreferredSize(new Dimension(300, 40));
        this.status_combo_box.setModel(this.status_combo_box_model);
        this.data2_combo_box.setModel(this.hex_data2_combo_box_model);
        this.keyboard_panel.keyboard.addPianoKeyboardListener(new PianoKeyboardAdapter(){

            @Override
            public void pianoKeyPressed(int n, InputEvent inputEvent) {
                MidiMessageForm.this.data1_text.setValue(n);
                if (MidiMessageForm.this.midi_channels != null) {
                    MidiMessageForm.this.midi_channels[MidiMessageForm.this.channel_text.getSelectedChannel()].noteOn(n, MidiMessageForm.this.data2_text.getValue());
                }
            }

            @Override
            public void pianoKeyReleased(int n, InputEvent inputEvent) {
                if (MidiMessageForm.this.midi_channels != null) {
                    MidiMessageForm.this.midi_channels[MidiMessageForm.this.channel_text.getSelectedChannel()].noteOff(n, MidiMessageForm.this.data2_text.getValue());
                }
            }
        });
        this.tempo_selecter.tempo_spinner_model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MidiMessageForm.this.data_text.setValue(MidiMessageForm.this.tempo_selecter.getTempoByteArray());
            }
        });
        this.timesig_selecter.upper_timesig_spinner_model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MidiMessageForm.this.data_text.setValue(MidiMessageForm.this.timesig_selecter.getByteArray());
            }
        });
        this.timesig_selecter.lower_timesig_combobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MidiMessageForm.this.data_text.setValue(MidiMessageForm.this.timesig_selecter.getByteArray());
            }
        });
        this.keysig_selecter.keysig_combobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MidiMessageForm.this.data_text.setValue(MidiMessageForm.this.keysig_selecter.getKey().getBytes());
            }
        });
        this.keysig_selecter.minor_checkbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MidiMessageForm.this.data_text.setValue(MidiMessageForm.this.keysig_selecter.getKey().getBytes());
            }
        });
        this.status_combo_box.addActionListener(this);
        this.channel_combo_box.addActionListener(this);
        this.data1_combo_box.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.status_text);
        jPanel.add(this.channel_text);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.data1_text);
        jPanel2.add(this.keyboard_panel);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.data2_text);
        this.setLayout(new BoxLayout(this, 1));
        this.add(jPanel);
        this.add(this.duration_form);
        this.add(jPanel2);
        this.add(jPanel3);
        this.add(this.tempo_selecter);
        this.add(this.timesig_selecter);
        this.add(this.keysig_selecter);
        this.add(this.data_text);
        this.status_combo_box.setSelectedIndex(1);
        this.data2_combo_box.setSelectedIndex(64);
        this.note_combo_box_model.setSelectedItem(this.note_combo_box_model.getElementAt(60));
        this.percussion_combo_box_model.setSelectedItem(this.percussion_combo_box_model.getElementAt(35));
        this.updateVisible();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.data1_combo_box) {
            int n = this.status_text.getValue();
            int n2 = this.data1_text.getValue();
            if (this.isNote(n)) {
                if (n2 >= 0) {
                    this.keyboard_panel.keyboard.setSelectedNote(n2);
                }
            } else if (n == 255) {
                switch (n2) {
                    case 81: {
                        this.data_text.setValue(this.tempo_selecter.getTempoByteArray());
                        break;
                    }
                    case 88: {
                        this.data_text.setValue(this.timesig_selecter.getByteArray());
                        break;
                    }
                    case 89: {
                        this.data_text.setValue(this.keysig_selecter.getKey().getBytes());
                        break;
                    }
                }
            }
        }
        this.updateVisible();
    }

    public void setOutputMidiChannels(MidiChannel[] midiChannelArray) {
        this.midi_channels = midiChannelArray;
    }

    public void setDurationVisible(boolean bl) {
        this.is_duration_visible = bl;
        this.updateVisible();
    }

    public boolean isDurationVisible() {
        return this.is_duration_visible;
    }

    public void updateVisible() {
        int n = this.status_text.getValue();
        boolean bl = MIDISpec.isChannelMessage(n);
        this.channel_text.setVisible(bl);
        this.status_text.setTitle("[Status] " + (bl ? "Command" : ""));
        this.duration_form.setVisible(this.is_duration_visible && this.isNote(n));
        this.keyboard_panel.setVisible(n <= 175);
        if (n <= 239 || n >= 241 && n <= 243 || n == 255) {
            this.data1_text.setVisible(true);
        } else {
            this.data1_text.setVisible(false);
        }
        if (n >= 192 && n <= 223 || n == 240 || n == 241 || n == 243 || n >= 246) {
            this.data2_text.setVisible(false);
        } else {
            this.data2_text.setVisible(true);
        }
        this.data2_text.setTitle("[Data2] " + (n <= 159 ? "Velocity" : (n <= 175 ? "Pressure" : (n <= 191 ? "Value" : ((n & 0xF0) == 224 ? "High 7bit value" : "")))));
        this.data_text.setVisible(n == 240 || n == 247 || n == 255);
        if (n != 255) {
            this.tempo_selecter.setVisible(false);
            this.timesig_selecter.setVisible(false);
            this.keysig_selecter.setVisible(false);
        }
        switch (n & 0xF0) {
            case 128: 
            case 144: 
            case 160: {
                int n2 = this.channel_text.getSelectedChannel();
                this.data1_text.setTitle("[Data1] " + (n2 == 9 ? "Percussion" : "Note No."));
                this.data1_combo_box.setModel(n2 == 9 ? this.percussion_combo_box_model : this.note_combo_box_model);
                break;
            }
            case 176: {
                this.data1_text.setTitle("[Data1] Control/Mode No.");
                this.data1_combo_box.setModel(this.control_change_combo_box_model);
                break;
            }
            case 192: {
                this.data1_text.setTitle("[Data1] Program No.");
                this.data1_combo_box.setModel(this.instrument_combo_box_model);
                break;
            }
            case 208: {
                this.data1_text.setTitle("[Data1] Pressure");
                this.data1_combo_box.setModel(this.hex_data1_combo_box_model);
                break;
            }
            case 224: {
                this.data1_text.setTitle("[Data1] Low 7bit value");
                this.data1_combo_box.setModel(this.hex_data1_combo_box_model);
                break;
            }
            default: {
                if (n == 255) {
                    this.data1_text.setTitle("[Data1] MetaEvent Type");
                    this.data1_combo_box.setModel(this.meta_type_combo_box_model);
                    int n3 = this.data1_text.getValue();
                    this.tempo_selecter.setVisible(n3 == 81);
                    this.timesig_selecter.setVisible(n3 == 88);
                    this.keysig_selecter.setVisible(n3 == 89);
                    if (MIDISpec.isEOT(n3)) {
                        this.data_text.clear();
                        this.data_text.setVisible(false);
                        break;
                    }
                    this.data_text.setTitle(MIDISpec.hasMetaText(n3) ? "Text:" : "Data:");
                    break;
                }
                this.data1_text.setTitle("[Data1] ");
                this.data1_combo_box.setModel(this.hex_data1_combo_box_model);
            }
        }
    }

    public MidiMessage getMessage() {
        int n;
        int n2 = this.status_text.getValue();
        if (n2 < 0) {
            return null;
        }
        if (n2 == 255) {
            byte[] byArray;
            int n3 = this.data1_text.getValue();
            if (n3 < 0) {
                return null;
            }
            if (MIDISpec.hasMetaText(n3)) {
                byArray = this.data_text.getBytesFromString();
            } else if (n3 == 47) {
                byArray = new byte[]{};
            } else {
                byArray = this.data_text.getBytes();
                if (byArray == null) {
                    return null;
                }
            }
            MetaMessage metaMessage = new MetaMessage();
            try {
                metaMessage.setMessage(n3, byArray, byArray.length);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
                return null;
            }
            return metaMessage;
        }
        if (n2 == 240 || n2 == 247) {
            SysexMessage sysexMessage = new SysexMessage();
            byte[] byArray = this.data_text.getBytes();
            if (byArray == null) {
                return null;
            }
            try {
                sysexMessage.setMessage(n2 & 0xFF, byArray, byArray.length);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
                return null;
            }
            return sysexMessage;
        }
        ShortMessage shortMessage = new ShortMessage();
        int n4 = this.data1_text.getValue();
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n = this.data2_text.getValue()) < 0) {
            n = 0;
        }
        try {
            if (MIDISpec.isChannelMessage(n2)) {
                shortMessage.setMessage(n2 & 0xF0, this.channel_text.getSelectedChannel(), n4, n);
            } else {
                shortMessage.setMessage(n2, n4, n);
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
        return shortMessage;
    }

    public void setMessage(MidiMessage midiMessage) {
        if (midiMessage instanceof ShortMessage) {
            ShortMessage shortMessage = (ShortMessage)midiMessage;
            int n = 0;
            int n2 = shortMessage.getStatus();
            if (MIDISpec.isChannelMessage(n2)) {
                n2 = shortMessage.getCommand();
                n = shortMessage.getChannel();
            }
            this.status_text.setValue(n2);
            this.channel_text.setSelectedChannel(n);
            this.data1_text.setValue(shortMessage.getData1());
            this.data2_text.setValue(shortMessage.getData2());
        } else if (midiMessage instanceof SysexMessage) {
            SysexMessage sysexMessage = (SysexMessage)midiMessage;
            this.status_text.setValue(sysexMessage.getStatus());
            this.data_text.setValue(sysexMessage.getData());
        } else if (midiMessage instanceof MetaMessage) {
            MetaMessage metaMessage = (MetaMessage)midiMessage;
            int n = metaMessage.getType();
            byte[] byArray = metaMessage.getData();
            this.status_text.setValue(255);
            this.data1_text.setValue(n);
            switch (n) {
                case 81: {
                    this.tempo_selecter.setTempo(byArray);
                    break;
                }
                case 88: {
                    this.timesig_selecter.setValue(byArray[0], byArray[1]);
                    break;
                }
                case 89: {
                    this.keysig_selecter.setKey(new Music.Key(byArray));
                    break;
                }
            }
            if (MIDISpec.hasMetaText(n)) {
                this.data_text.setString(new String(byArray));
            } else {
                this.data_text.setValue(byArray);
            }
            this.updateVisible();
        }
    }

    public boolean setNote(int n, int n2, int n3) {
        this.channel_text.setSelectedChannel(n);
        this.data1_text.setValue(n2);
        this.data2_text.setValue(n3);
        return true;
    }

    public boolean isNote() {
        return this.isNote(this.status_text.getValue());
    }

    public boolean isNote(int n) {
        int n2 = n & 0xF0;
        return n2 == 144 || n2 == 128;
    }

    public boolean isNote(boolean bl) {
        return this.isNote(bl, this.status_text.getValue());
    }

    public boolean isNote(boolean bl, int n) {
        int n2 = n & 0xF0;
        return bl && n2 == 144 && this.data2_text.getValue() > 0 || !bl && (n2 == 144 && this.data2_text.getValue() <= 0 || n2 == 128);
    }

    public ShortMessage getPartnerMessage() {
        ShortMessage shortMessage = (ShortMessage)this.getMessage();
        if (shortMessage == null) {
            return null;
        }
        if (this.isNote(true)) {
            ShortMessage shortMessage2 = new ShortMessage();
            try {
                shortMessage2.setMessage(128, shortMessage.getChannel(), shortMessage.getData1(), shortMessage.getData2());
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
                return null;
            }
            return shortMessage2;
        }
        if (this.isNote(false)) {
            ShortMessage shortMessage3 = new ShortMessage();
            try {
                shortMessage3.setMessage(144, shortMessage.getChannel(), shortMessage.getData1() == 0 ? 100 : shortMessage.getData1(), shortMessage.getData2());
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
                return null;
            }
            return shortMessage3;
        }
        return null;
    }
}

