/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

class MidiTrackModel
extends AbstractTableModel {
    public static final int COLUMN_EVENT_NUMBER = 0;
    public static final int COLUMN_TICK_POSITION = 1;
    public static final int COLUMN_MEASURE_POSITION = 2;
    public static final int COLUMN_BEAT_POSITION = 3;
    public static final int COLUMN_EXTRA_TICK_POSITION = 4;
    public static final int COLUMN_MESSAGE = 5;
    public static final String[] column_titles = new String[]{"No.", "TickPos.", "Measure", "Beat", "ExTick", "MIDI Message"};
    public static final int[] column_width_ratios = new int[]{30, 40, 20, 20, 20, 280};
    private Track track;
    private MidiSequenceModel parent_model;
    private String rec_ch = "OFF";

    public MidiTrackModel() {
    }

    public MidiTrackModel(MidiSequenceModel midiSequenceModel) {
        this.parent_model = midiSequenceModel;
    }

    public MidiTrackModel(Track track, MidiSequenceModel midiSequenceModel) {
        this.track = track;
        this.parent_model = midiSequenceModel;
    }

    @Override
    public int getRowCount() {
        return this.track == null ? 0 : this.track.size();
    }

    @Override
    public int getColumnCount() {
        return column_titles.length;
    }

    @Override
    public String getColumnName(int n) {
        return column_titles[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Long.class;
            }
            case 2: 
            case 3: 
            case 4: {
                return Integer.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return n;
            }
            case 1: {
                return this.track.get(n).getTick();
            }
            case 2: {
                return this.parent_model.getSequenceIndex().tickToMeasure(this.track.get(n).getTick()) + 1;
            }
            case 3: {
                this.parent_model.getSequenceIndex().tickToMeasure(this.track.get(n).getTick());
                return this.parent_model.getSequenceIndex().last_beat + 1;
            }
            case 4: {
                this.parent_model.getSequenceIndex().tickToMeasure(this.track.get(n).getTick());
                return this.parent_model.getSequenceIndex().last_extra_tick;
            }
            case 5: {
                return this.msgToString(this.track.get(n).getMessage());
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        long l;
        switch (n2) {
            case 1: {
                l = (Long)object;
                break;
            }
            case 2: {
                l = this.parent_model.getSequenceIndex().measureToTick((Integer)object - 1, (Integer)this.getValueAt(n, 3) - 1, (Integer)this.getValueAt(n, 4));
                break;
            }
            case 3: {
                l = this.parent_model.getSequenceIndex().measureToTick((Integer)this.getValueAt(n, 2) - 1, (Integer)object - 1, (Integer)this.getValueAt(n, 4));
                break;
            }
            case 4: {
                l = this.parent_model.getSequenceIndex().measureToTick((Integer)this.getValueAt(n, 2) - 1, (Integer)this.getValueAt(n, 3) - 1, (Integer)object);
                break;
            }
            case 5: {
                return;
            }
            default: {
                return;
            }
        }
        this.changeEventTick(n, l);
    }

    public void sizeColumnWidthToFit(TableColumnModel tableColumnModel) {
        int n;
        int n2 = tableColumnModel.getTotalColumnWidth();
        int n3 = 0;
        for (n = 0; n < column_width_ratios.length; ++n) {
            n3 += column_width_ratios[n];
        }
        for (n = 0; n < column_width_ratios.length; ++n) {
            tableColumnModel.getColumn(n).setPreferredWidth(n2 * column_width_ratios[n] / n3);
        }
    }

    private boolean isRhythmPart(int n) {
        return n == 9;
    }

    public Track getTrack() {
        return this.track;
    }

    public String toString() {
        return MIDISpec.getNameOf(this.track);
    }

    public boolean setString(String string) {
        if (string.equals(this.toString()) || !MIDISpec.setNameOf(this.track, string)) {
            return false;
        }
        this.parent_model.setModified(true);
        this.parent_model.fireSequenceChanged();
        this.fireTableDataChanged();
        return true;
    }

    public String getRecordingChannel() {
        return this.rec_ch;
    }

    public void setRecordingChannel(String string) {
        Sequencer sequencer = this.parent_model.getSequencer();
        if (string.equals("OFF")) {
            sequencer.recordDisable(this.track);
        } else if (string.equals("ALL")) {
            sequencer.recordEnable(this.track, -1);
        } else {
            try {
                int n = Integer.decode(string) - 1;
                sequencer.recordEnable(this.track, n);
            }
            catch (NumberFormatException numberFormatException) {
                sequencer.recordDisable(this.track);
                this.rec_ch = "OFF";
                return;
            }
        }
        this.rec_ch = string;
    }

    public int getChannel() {
        int n = -1;
        int n2 = this.track.size();
        for (int i = 0; i < n2; ++i) {
            ShortMessage shortMessage;
            MidiMessage midiMessage = this.track.get(i).getMessage();
            if (!(midiMessage instanceof ShortMessage) || !MIDISpec.isChannelMessage(shortMessage = (ShortMessage)midiMessage)) continue;
            int n3 = shortMessage.getChannel();
            if (n >= 0 && n != n3) {
                return -1;
            }
            n = n3;
        }
        return n;
    }

    public void setChannel(int n) {
        int n2 = this.track.size();
        for (int i = 0; i < n2; ++i) {
            ShortMessage shortMessage;
            MidiMessage midiMessage = this.track.get(i).getMessage();
            if (!(midiMessage instanceof ShortMessage) || !MIDISpec.isChannelMessage(shortMessage = (ShortMessage)midiMessage) || shortMessage.getChannel() == n) continue;
            try {
                shortMessage.setMessage(shortMessage.getCommand(), n, shortMessage.getData1(), shortMessage.getData2());
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
            }
            this.parent_model.setModified(true);
        }
        this.parent_model.fireTrackChanged(this.track);
        this.parent_model.fireSequenceChanged();
        this.fireTableDataChanged();
    }

    public void changeEventTick(int n, long l) {
        MidiEvent midiEvent = this.track.get(n);
        if (midiEvent.getTick() == l) {
            return;
        }
        MidiMessage midiMessage = midiEvent.getMessage();
        MidiEvent midiEvent2 = new MidiEvent(midiMessage, l);
        this.track.remove(midiEvent);
        this.track.add(midiEvent2);
        this.fireTableDataChanged();
        if (MIDISpec.isEOT(midiMessage)) {
            this.parent_model.fireSequenceChanged();
        }
    }

    public int tickToIndex(long l) {
        if (this.track == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.track.size() - 1;
        while (n < n2) {
            int n3 = (n + n2) / 2;
            long l2 = this.track.get(n3).getTick();
            if (l > l2) {
                n = n3 + 1;
                continue;
            }
            if (l < l2) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return (n + n2) / 2;
    }

    public int getIndexOfPartnerFor(int n) {
        if (this.track == null || n >= this.track.size()) {
            return -1;
        }
        MidiMessage midiMessage = this.track.get(n).getMessage();
        if (!(midiMessage instanceof ShortMessage)) {
            return -1;
        }
        ShortMessage shortMessage = (ShortMessage)midiMessage;
        int n2 = shortMessage.getCommand();
        int n3 = shortMessage.getChannel();
        int n4 = shortMessage.getData1();
        switch (n2) {
            case 144: {
                if (shortMessage.getData2() > 0) {
                    for (int i = n + 1; i < this.track.size(); ++i) {
                        ShortMessage shortMessage2;
                        int n5;
                        MidiMessage midiMessage2 = this.track.get(i).getMessage();
                        if (!(midiMessage2 instanceof ShortMessage) || (n5 = (shortMessage2 = (ShortMessage)midiMessage2).getCommand()) != 128 && n5 != 144 || n5 == 144 && shortMessage2.getData2() > 0 || n3 != shortMessage2.getChannel() || n4 != shortMessage2.getData1()) continue;
                        return i;
                    }
                    break;
                }
            }
            case 128: {
                for (int i = n - 1; i >= 0; --i) {
                    ShortMessage shortMessage3;
                    int n6;
                    MidiMessage midiMessage3 = this.track.get(i).getMessage();
                    if (!(midiMessage3 instanceof ShortMessage) || (n6 = (shortMessage3 = (ShortMessage)midiMessage3).getCommand()) != 144 || shortMessage3.getData2() <= 0 || n3 != shortMessage3.getChannel() || n4 != shortMessage3.getData1()) continue;
                    return i;
                }
                break;
            }
        }
        return -1;
    }

    public boolean isTimeSignature(MidiMessage midiMessage) {
        return midiMessage instanceof MetaMessage && ((MetaMessage)midiMessage).getType() == 88;
    }

    public boolean isNote(int n) {
        MidiEvent midiEvent = this.getMidiEvent(n);
        MidiMessage midiMessage = midiEvent.getMessage();
        if (!(midiMessage instanceof ShortMessage)) {
            return false;
        }
        int n2 = ((ShortMessage)midiMessage).getCommand();
        return n2 == 144 || n2 == 128;
    }

    public boolean hasTrack() {
        return this.track != null;
    }

    public MidiEvent getMidiEvent(int n) {
        return this.track.get(n);
    }

    public MidiEvent[] getMidiEvents(ListSelectionModel listSelectionModel) {
        Vector<MidiEvent> vector = new Vector<MidiEvent>();
        if (!listSelectionModel.isSelectionEmpty()) {
            int n = listSelectionModel.getMinSelectionIndex();
            int n2 = listSelectionModel.getMaxSelectionIndex();
            for (int i = n; i <= n2; ++i) {
                if (!listSelectionModel.isSelectedIndex(i)) continue;
                vector.add(this.track.get(i));
            }
        }
        return vector.toArray(new MidiEvent[1]);
    }

    public boolean addMidiEvent(MidiEvent midiEvent) {
        if (!this.track.add(midiEvent)) {
            return false;
        }
        if (this.isTimeSignature(midiEvent.getMessage())) {
            this.parent_model.fireTimeSignatureChanged();
        }
        this.parent_model.fireTrackChanged(this.track);
        int n = this.track.size() - 1;
        this.fireTableRowsInserted(n - 1, n - 1);
        return true;
    }

    public boolean addMidiEvents(MidiEvent[] midiEventArray, long l, int n) {
        int n2 = this.parent_model.getSequence().getResolution();
        boolean bl = false;
        boolean bl2 = false;
        long l2 = 0L;
        long l3 = -1L;
        for (MidiEvent midiEvent : midiEventArray) {
            MidiEvent midiEvent2;
            l2 = midiEvent.getTick();
            MidiMessage midiMessage = midiEvent.getMessage();
            if (l3 < 0L) {
                l3 = l2;
                midiEvent2 = new MidiEvent(midiMessage, l);
            } else {
                midiEvent2 = new MidiEvent(midiMessage, l + (l2 - l3) * (long)n2 / (long)n);
            }
            if (!this.track.add(midiEvent2)) continue;
            bl = true;
            if (!this.isTimeSignature(midiMessage)) continue;
            bl2 = true;
        }
        if (bl) {
            if (bl2) {
                this.parent_model.fireTimeSignatureChanged();
            }
            this.parent_model.fireTrackChanged(this.track);
            int n3 = this.track.size() - 1;
            int n4 = n3 - midiEventArray.length;
            this.fireTableRowsInserted(n4, n3);
        }
        return bl;
    }

    public void removeMidiEvents(MidiEvent[] midiEventArray) {
        boolean bl = false;
        for (MidiEvent midiEvent : midiEventArray) {
            if (this.isTimeSignature(midiEvent.getMessage())) {
                bl = true;
            }
            this.track.remove(midiEvent);
        }
        if (bl) {
            this.parent_model.fireTimeSignatureChanged();
        }
        this.parent_model.fireTrackChanged(this.track);
        int n = this.track.size() - 1;
        int n2 = n + midiEventArray.length;
        if (n < 0) {
            n = 0;
        }
        this.fireTableRowsDeleted(n2, n);
    }

    public void removeMidiEvents(ListSelectionModel listSelectionModel) {
        this.removeMidiEvents(this.getMidiEvents(listSelectionModel));
    }

    /*
     * Enabled aggressive block sorting
     */
    public String msgToString(MidiMessage midiMessage) {
        String string = "";
        if (midiMessage instanceof ShortMessage) {
            ShortMessage shortMessage = (ShortMessage)midiMessage;
            int n = midiMessage.getStatus();
            String string2 = MIDISpec.getStatusName(n);
            int n2 = shortMessage.getData1();
            int n3 = shortMessage.getData2();
            if (MIDISpec.isChannelMessage(n)) {
                int n4 = shortMessage.getChannel();
                String string3 = "Ch." + (n4 + 1) + ": ";
                String string4 = (string2 == null ? String.format("status=0x%02X", n) : string2) + ": ";
                int n5 = shortMessage.getCommand();
                switch (n5) {
                    case 128: 
                    case 144: {
                        string = string + string3 + string4 + n2;
                        string = string + ":[";
                        string = this.isRhythmPart(n4) ? string + MIDISpec.getPercussionName(n2) : string + Music.noteNoToSymbol(n2);
                        return string + "] Velocity=" + n3;
                    }
                    case 160: {
                        return string + string3 + string4 + "Note=" + n2 + " Pressure=" + n3;
                    }
                    case 192: {
                        string = string + string3 + string4 + n2 + ":[" + MIDISpec.instrument_names[n2] + "]";
                        if (n3 == 0) return string;
                        return string + " data2=" + n3;
                    }
                    case 208: {
                        string = string + string3 + string4 + n2;
                        if (n3 == 0) return string;
                        return string + " data2=" + n3;
                    }
                    case 224: {
                        int n6 = n2 & 0x7F | (n3 & 0x7F) << 7;
                        return string + string3 + string4 + (n6 - 8192) * 100 / 8191 + "% (" + n6 + ")";
                    }
                    case 176: {
                        String string5 = MIDISpec.getControllerName(n2);
                        string = string + string3 + (n2 < 120 ? "CtrlChg: " : "ModeMsg: ");
                        if (string5 == null) {
                            return string + " No.=" + n2 + " Value=" + n3;
                        }
                        string = string + string5;
                        switch (n2) {
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 69: {
                                return string + " " + (n3 == 63 ? "OFF" : (n3 == 64 ? "ON" : Integer.valueOf(n3)));
                            }
                            case 68: {
                                return string + " " + (n3 == 63 ? "Normal" : (n3 == 64 ? "Legato" : Integer.valueOf(n3)));
                            }
                            case 122: {
                                return string + " " + (n3 == 0 ? "OFF" : (n3 == 127 ? "ON" : Integer.valueOf(n3)));
                            }
                        }
                        return string + " " + n3;
                    }
                }
                return string;
            }
            string = string + (string2 == null ? "status=" + n : string2);
            return string + " (" + n2 + "," + n3 + ")";
        }
        if (midiMessage instanceof MetaMessage) {
            MetaMessage metaMessage = (MetaMessage)midiMessage;
            byte[] byArray = metaMessage.getData();
            int n = metaMessage.getType();
            string = string + "Meta: ";
            String string6 = MIDISpec.getMetaName(n);
            if (string6 == null) {
                string = string + "Unknown MessageType=" + n + " Values=(";
                byte[] byArray2 = byArray;
                int n7 = byArray2.length;
                int n8 = 0;
                while (true) {
                    if (n8 >= n7) {
                        return string + " )";
                    }
                    byte by = byArray2[n8];
                    string = string + String.format(" %02X", by);
                    ++n8;
                }
            }
            string = string + string6;
            if (MIDISpec.hasMetaText(n)) {
                return string + " [" + new String(byArray) + "]";
            }
            switch (n) {
                case 0: {
                    if (byArray.length == 2) {
                        return string + String.format(": %04X", (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
                    }
                    string = string + ": Size not 2 byte : data=(";
                    byte[] byArray3 = byArray;
                    int n9 = byArray3.length;
                    int n10 = 0;
                    while (true) {
                        if (n10 >= n9) {
                            return string + " )";
                        }
                        byte by = byArray3[n10];
                        string = string + String.format(" %02X", by);
                        ++n10;
                    }
                }
                case 32: 
                case 33: {
                    if (byArray.length == 1) {
                        return string + String.format(": %02X", byArray[0] & 0xFF);
                    }
                    string = string + ": Size not 1 byte : data=(";
                    byte[] byArray4 = byArray;
                    int n11 = byArray4.length;
                    int n12 = 0;
                    while (true) {
                        if (n12 >= n11) {
                            return string + " )";
                        }
                        byte by = byArray4[n12];
                        string = string + String.format(" %02X", by);
                        ++n12;
                    }
                }
                case 81: {
                    string = string + ": " + MIDISpec.byteArrayToQpmTempo(byArray) + "[QPM] (";
                    byte[] byArray5 = byArray;
                    int n13 = byArray5.length;
                    int n14 = 0;
                    while (true) {
                        if (n14 >= n13) {
                            return string + " )";
                        }
                        byte by = byArray5[n14];
                        string = string + String.format(" %02X", by);
                        ++n14;
                    }
                }
                case 84: {
                    if (byArray.length == 5) {
                        return string + ": " + (byArray[0] & 0xFF) + ":" + (byArray[1] & 0xFF) + ":" + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF) + "." + (byArray[4] & 0xFF);
                    }
                    string = string + ": Size not 5 byte : data=(";
                    byte[] byArray6 = byArray;
                    int n15 = byArray6.length;
                    int n16 = 0;
                    while (true) {
                        if (n16 >= n15) {
                            return string + " )";
                        }
                        byte by = byArray6[n16];
                        string = string + String.format(" %02X", by);
                        ++n16;
                    }
                }
                case 88: {
                    if (byArray.length == 4) {
                        string = string + ": " + byArray[0] + "/" + (1 << byArray[1]);
                        return string + ", " + byArray[2] + "[clk/beat], " + byArray[3] + "[32nds/24clk]";
                    }
                    string = string + ": Size not 4 byte : data=(";
                    byte[] byArray7 = byArray;
                    int n17 = byArray7.length;
                    int n18 = 0;
                    while (true) {
                        if (n18 >= n17) {
                            return string + " )";
                        }
                        byte by = byArray7[n18];
                        string = string + String.format(" %02X", by);
                        ++n18;
                    }
                }
                case 89: {
                    if (byArray.length == 2) {
                        Music.Key key = new Music.Key(byArray);
                        string = string + ": " + key.signatureDescription();
                        return string + " (" + key.toStringIn(1) + ")";
                    }
                    string = string + ": Size not 2 byte : data=(";
                    byte[] byArray8 = byArray;
                    int n19 = byArray8.length;
                    int n20 = 0;
                    while (true) {
                        if (n20 >= n19) {
                            return string + " )";
                        }
                        byte by = byArray8[n20];
                        string = string + String.format(" %02X", by);
                        ++n20;
                    }
                }
                case 127: {
                    string = string + " (";
                    byte[] byArray9 = byArray;
                    int n21 = byArray9.length;
                    int n22 = 0;
                    while (n22 < n21) {
                        byte by = byArray9[n22];
                        string = string + String.format(" %02X", by);
                        ++n22;
                    }
                    return string + " )";
                }
            }
            return string;
        }
        if (midiMessage instanceof SysexMessage) {
            int n;
            SysexMessage sysexMessage = (SysexMessage)midiMessage;
            int n23 = sysexMessage.getStatus();
            byte[] byArray = sysexMessage.getData();
            int n24 = 1;
            switch (n23) {
                case 240: {
                    string = string + "SysEx: ";
                    break;
                }
                case 247: {
                    string = string + "SysEx(Special): ";
                    break;
                }
                default: {
                    string = string + "SysEx: Invalid (status=" + n23 + ") ";
                }
            }
            if (byArray.length < 1) {
                return string + " Invalid data size: " + byArray.length;
            }
            int n25 = byArray[0] & 0xFF;
            int n26 = byArray[1] & 0xFF;
            int n27 = byArray[2] & 0xFF;
            String string7 = MIDISpec.getSysExManufacturerName(n25);
            if (string7 == null) {
                string7 = String.format("[Manufacturer code %02X]", byArray[0]);
            }
            string = string + string7 + String.format(" (DevID=0x%02X)", n26);
            block26 : switch (n25) {
                case 126: {
                    ++n24;
                    n = byArray[2] & 0xFF;
                    int n28 = byArray[3] & 0xFF;
                    switch (n) {
                        case 9: {
                            switch (n28) {
                                case 1: {
                                    return string + " GM System ON";
                                }
                                case 2: {
                                    return string + " GM System OFF";
                                }
                            }
                            break block26;
                        }
                    }
                    break;
                }
                case 65: {
                    ++n24;
                    switch (n27) {
                        case 66: {
                            string = string + " [GS]";
                            ++n24;
                            if (byArray[3] != 18) break;
                            string = string + "DT1:";
                            ++n24;
                            switch (byArray[4]) {
                                case 0: {
                                    if (byArray[5] == 0) {
                                        if (byArray[6] != 127) break;
                                        if (byArray[7] == 0) {
                                            return string + " [88] System Mode Set (Mode 1: Single Module)";
                                        }
                                        if (byArray[7] != 1) break;
                                        return string + " [88] System Mode Set (Mode 2: Double Module)";
                                    }
                                    if (byArray[5] != 1) break;
                                    int n29 = byArray[7] & 0xFF;
                                    return string + String.format(" [88] Ch.Msg Rx Port: Block=0x%02X, Port=%s", byArray[6], n29 == 0 ? "A" : (n29 == 1 ? "B" : String.format("0x%02X", n29)));
                                }
                                case 64: {
                                    int n30;
                                    if (byArray[5] == 0) {
                                        switch (byArray[6]) {
                                            case 0: {
                                                string = string + " Master Tune: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 4: {
                                                string = string + " Master Volume: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 5: {
                                                string = string + " Master Key Shift: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 6: {
                                                string = string + " Master Pan: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 127: {
                                                switch (byArray[7]) {
                                                    case 0: {
                                                        return string + " GS Reset";
                                                    }
                                                    case 127: {
                                                        return string + " Exit GS Mode";
                                                    }
                                                }
                                                break block26;
                                            }
                                        }
                                        break block26;
                                    }
                                    if (byArray[5] == 1) {
                                        switch (byArray[6]) {
                                            case 48: {
                                                string = string + " Reverb Macro: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 49: {
                                                string = string + " Reverb Character: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 50: {
                                                string = string + " Reverb Pre-LPF: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 51: {
                                                string = string + " Reverb Level: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 52: {
                                                string = string + " Reverb Time: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 53: {
                                                string = string + " Reverb Delay FB: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 54: {
                                                string = string + " Reverb Chorus Level: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 55: {
                                                string = string + " [88] Reverb Predelay Time: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 56: {
                                                string = string + " Chorus Macro: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 57: {
                                                string = string + " Chorus Pre-LPF: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 58: {
                                                string = string + " Chorus Level: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 59: {
                                                string = string + " Chorus FB: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 60: {
                                                string = string + " Chorus Delay: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 61: {
                                                string = string + " Chorus Rate: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 62: {
                                                string = string + " Chorus Depth: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 63: {
                                                string = string + " Chorus Send Level To Reverb: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 64: {
                                                string = string + " [88] Chorus Send Level To Delay: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 80: {
                                                string = string + " [88] Delay Macro: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 81: {
                                                string = string + " [88] Delay Pre-LPF: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 82: {
                                                string = string + " [88] Delay Time Center: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 83: {
                                                string = string + " [88] Delay Time Ratio Left: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 84: {
                                                string = string + " [88] Delay Time Ratio Right: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 85: {
                                                string = string + " [88] Delay Level Center: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 86: {
                                                string = string + " [88] Delay Level Left: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 87: {
                                                string = string + " [88] Delay Level Right: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 88: {
                                                string = string + " [88] Delay Level: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 89: {
                                                string = string + " [88] Delay FB: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 90: {
                                                string = string + " [88] Delay Send Level To Reverb: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                        }
                                        break block26;
                                    }
                                    if (byArray[5] == 2) {
                                        switch (byArray[6]) {
                                            case 0: {
                                                string = string + " [88] EQ Low Freq: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 1: {
                                                string = string + " [88] EQ Low Gain: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 2: {
                                                string = string + " [88] EQ High Freq: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                            case 3: {
                                                string = string + " [88] EQ High Gain: ";
                                                n24 += 3;
                                                break block26;
                                            }
                                        }
                                        break block26;
                                    }
                                    if (byArray[5] == 3) {
                                        if (byArray[6] == 0) {
                                            string = string + " [Pro] EFX Type: ";
                                            n24 += 3;
                                            break block26;
                                        }
                                        if (byArray[6] >= 3 && byArray[6] <= 22) {
                                            string = string + String.format(" [Pro] EFX Param %d", byArray[6] - 2);
                                            n24 += 3;
                                            break block26;
                                        }
                                        if (byArray[6] == 23) {
                                            string = string + " [Pro] EFX Send Level To Reverb: ";
                                            n24 += 3;
                                            break block26;
                                        }
                                        if (byArray[6] == 24) {
                                            string = string + " [Pro] EFX Send Level To Chorus: ";
                                            n24 += 3;
                                            break block26;
                                        }
                                        if (byArray[6] == 25) {
                                            string = string + " [Pro] EFX Send Level To Delay: ";
                                            n24 += 3;
                                            break block26;
                                        }
                                        if (byArray[6] == 27) {
                                            string = string + " [Pro] EFX Ctrl Src1: ";
                                            n24 += 3;
                                            break block26;
                                        }
                                        if (byArray[6] == 28) {
                                            string = string + " [Pro] EFX Ctrl Depth1: ";
                                            n24 += 3;
                                            break block26;
                                        }
                                        if (byArray[6] == 29) {
                                            string = string + " [Pro] EFX Ctrl Src2: ";
                                            n24 += 3;
                                            break block26;
                                        }
                                        if (byArray[6] == 30) {
                                            string = string + " [Pro] EFX Ctrl Depth2: ";
                                            n24 += 3;
                                            break block26;
                                        }
                                        if (byArray[6] != 31) break;
                                        string = string + " [Pro] EFX Send EQ Switch: ";
                                        n24 += 3;
                                        break block26;
                                    }
                                    if ((byArray[5] & 0xF0) == 16) {
                                        String string8;
                                        n30 = byArray[5] & 0xF;
                                        if (n30 <= 9) {
                                            --n30;
                                        } else if (n30 == 0) {
                                            n30 = 9;
                                        }
                                        if (byArray[6] == 2) {
                                            return string + String.format(" Rx Ch: Part=%d(0x%02X) Ch=0x%02X", n30 + 1, byArray[5], byArray[7]);
                                        }
                                        if (byArray[6] != 21) break block26;
                                        switch (byArray[7]) {
                                            case 0: {
                                                string8 = " NormalPart";
                                                return string + String.format(" Rhythm Part: Ch=%d(0x%02X) Map=%s", n30 + 1, byArray[5], string8);
                                            }
                                            case 1: {
                                                string8 = " DrumMap1";
                                                return string + String.format(" Rhythm Part: Ch=%d(0x%02X) Map=%s", n30 + 1, byArray[5], string8);
                                            }
                                            case 2: {
                                                string8 = " DrumMap2";
                                                return string + String.format(" Rhythm Part: Ch=%d(0x%02X) Map=%s", n30 + 1, byArray[5], string8);
                                            }
                                            default: {
                                                string8 = String.format("0x%02X", byArray[7]);
                                            }
                                        }
                                        return string + String.format(" Rhythm Part: Ch=%d(0x%02X) Map=%s", n30 + 1, byArray[5], string8);
                                    }
                                    if ((byArray[5] & 0xF0) != 64) break;
                                    n30 = byArray[5] & 0xF;
                                    if (n30 <= 9) {
                                        --n30;
                                    } else if (n30 == 0) {
                                        n30 = 9;
                                    }
                                    int n31 = byArray[7] & 0xFF;
                                    if (byArray[6] == 32) {
                                        string = string + String.format(" [88] EQ: Ch=%d(0x%02X) %s", n30 + 1, byArray[5], n31 == 0 ? "OFF" : (n31 == 1 ? "ON" : String.format("0x%02X", n31)));
                                        break block26;
                                    }
                                    if (byArray[6] != 34) break;
                                    string = string + String.format(" [Pro] Part EFX Assign: Ch=%d(0x%02X) %s", n30 + 1, byArray[5], n31 == 0 ? "ByPass" : (n31 == 1 ? "EFX" : String.format("0x%02X", n31)));
                                }
                            }
                            break block26;
                        }
                        case 69: {
                            string = string + " [GS-LCD]";
                            ++n24;
                            if (byArray[3] != 18) break;
                            string = string + " [DT1]";
                            ++n24;
                            if (byArray[4] != 16 || byArray[5] != 0 || byArray[6] != 0) break;
                            string = string + " Disp [" + new String(byArray, n24 += 3, byArray.length - n24 - 2) + "]";
                            break block26;
                        }
                        case 20: {
                            string = string + " [D-50]";
                            ++n24;
                            break block26;
                        }
                        case 22: {
                            string = string + " [MT-32]";
                            ++n24;
                        }
                    }
                    break;
                }
                case 67: {
                    ++n24;
                    if (n27 != 76) break;
                    string = string + " [XG]";
                    if (byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 126 && byArray[6] == 0) {
                        return string + " XG System ON";
                    }
                    ++n24;
                    break;
                }
            }
            string = string + " data=(";
            for (n = n24; n < byArray.length - 1; ++n) {
                string = string + String.format(" %02X", byArray[n]);
            }
            if (n >= byArray.length) return string + " )";
            if ((byArray[n] & 0xFF) == 247) return string + " )";
            string = string + " [ Invalid EOX " + String.format("%02X", byArray[n]) + " ]";
            return string + " )";
        }
        byte[] byArray = midiMessage.getMessage();
        string = string + "(";
        byte[] byArray10 = byArray;
        int n = byArray10.length;
        int n32 = 0;
        while (n32 < n) {
            byte by = byArray10[n32];
            string = string + String.format(" %02X", by);
            ++n32;
        }
        return string + " )";
    }
}

