/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Arrays;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataListener;

public class Music {
    public static int reverseCo5(int n) {
        return (n & 1) == 0 ? n : n + 6;
    }

    public static int mod12(int n) {
        int n2 = n % 12;
        return n2 < 0 ? n2 + 12 : n2;
    }

    public static String noteNoToSymbol(int n) {
        return Music.noteNoToSymbol(n, 256);
    }

    public static String noteNoToSymbol(int n, int n2) {
        int n3 = Music.mod12(Music.reverseCo5(n));
        if (n3 == 11) {
            return new NoteSymbol(-1).toString();
        }
        if (n3 >= 6) {
            if (n2 >= 7) {
                return new NoteSymbol(n3).toString() + " / " + new NoteSymbol(n3 - 12).toString();
            }
            return new NoteSymbol(n3 - (n3 >= 8 ? 12 : 0)).toString();
        }
        return new NoteSymbol(n3).toString();
    }

    public static double noteNoToFrequency(int n) {
        return 55.0 * Math.pow(2.0, (double)(n - 33) / 12.0);
    }

    public static boolean isOnScale(int n) {
        return Music.mod12(Music.reverseCo5(n) + 1) < 7;
    }

    public static boolean isOnScale(int n, int n2) {
        return Music.mod12(Music.reverseCo5(n) - n2 + 1) < 7;
    }

    public static int transposeCo5(int n, int n2) {
        if (n2 == 0) {
            return n;
        }
        int n3 = Music.mod12(n + Music.reverseCo5(n2));
        if (n3 > 6) {
            n3 -= 12;
        }
        return n3;
    }

    public static int oppositeCo5(int n) {
        return n > 0 ? n - 6 : n + 6;
    }

    public static class VocaloidLyricGenerator {
        private static String[] lyric_elements = new String[]{"\u3042", "\u3044", "\u3046", "\u3048", "\u304a", "\u304b", "\u304d", "\u304f", "\u3051", "\u3053", "\u3055", "\u3057", "\u3059", "\u305b", "\u305d", "\u305f", "\u3061", "\u3064", "\u3066", "\u3068", "\u306a", "\u306b", "\u306c", "\u306d", "\u306e", "\u306f", "\u3072", "\u3075", "\u3078", "\u307b", "\u307e", "\u307f", "\u3080", "\u3081", "\u3082", "\u3084", "\u3086", "\u3088", "\u3089", "\u308a", "\u308b", "\u308c", "\u308d", "\u308f", "\u3092", "\u3093", "\u304c", "\u304e", "\u3050", "\u3052", "\u3054", "\u3056", "\u3058", "\u305a", "\u305c", "\u305e", "\u3060", "\u3062", "\u3065", "\u3067", "\u3069", "\u3070", "\u3073", "\u3076", "\u3079", "\u307c", "\u3071", "\u3074", "\u3077", "\u307a", "\u307d"};

        public static String getRandomLyric() {
            return lyric_elements[(int)(Math.random() * (double)lyric_elements.length)];
        }
    }

    public static class MelodyTrackSpec
    extends AbstractNoteTrackSpec {
        Range range;
        int beat_pattern = 65535;
        int continuous_beat_pattern = 61166;
        boolean is_bass = false;
        boolean random_melody = false;
        boolean random_lyric = false;

        public MelodyTrackSpec(int n, String string) {
            super(n, string);
            this.range = new Range(60, 72);
        }

        public MelodyTrackSpec(int n, String string, Range range) {
            super(n, string);
            this.range = range;
        }

        public void addChords(ChordProgression chordProgression) {
            int n = 1;
            int[] nArray = new int[this.range.max_note - this.range.min_note];
            Key key = chordProgression.key;
            if (key == null) {
                key = new Key("C");
            }
            for (ChordProgression.Line line : chordProgression.lines) {
                for (ChordProgression.Measure measure : line) {
                    long l;
                    if (measure.ticks_per_beat == null) continue;
                    ChordProgression.TickRange tickRange = measure.getRange();
                    boolean bl = false;
                    long l2 = l = tickRange.start_tick_pos;
                    int n2 = 0;
                    int n3 = 32768;
                    while (l2 < tickRange.end_tick_pos) {
                        Chord chord = measure.chordStrokeAt((long)l2).chord;
                        int[] nArray2 = chord.toNoteArray(this.range);
                        if (!(!(Math.random() < 0.9) ? (this.beat_pattern & n3) != 0 : (this.beat_pattern & n3) == 0)) {
                            if (!bl) {
                                l = l2;
                                bl = true;
                            }
                            if (!(!(Math.random() < 0.9) ? (this.continuous_beat_pattern & n3) == 0 : (this.continuous_beat_pattern & n3) != 0)) {
                                if (this.random_melody) {
                                    int n4;
                                    int n5;
                                    int n6 = 0;
                                    for (n5 = 0; n5 < nArray.length; ++n5) {
                                        int n7;
                                        n4 = this.range.min_note + n5;
                                        int n8 = Music.mod12(n4 - chord.rootNote());
                                        if (chord.indexOf(n4) >= 0) {
                                            n7 = 255;
                                        } else {
                                            switch (n8) {
                                                case 2: 
                                                case 9: {
                                                    n7 = 63;
                                                    break;
                                                }
                                                case 5: 
                                                case 11: {
                                                    n7 = 47;
                                                    break;
                                                }
                                                default: {
                                                    n7 = 0;
                                                }
                                            }
                                            if (!key.isOnScale(n4)) {
                                                n7 = 0;
                                            }
                                        }
                                        int n9 = n4 - n;
                                        if (n9 < 0) {
                                            n9 = -n9;
                                        }
                                        if (n9 == 0) {
                                            n7 /= 8;
                                        } else if (n9 > 7) {
                                            n7 = 0;
                                        } else if (n9 > 4) {
                                            n7 /= 8;
                                        }
                                        nArray[n5] = n7;
                                        n6 += nArray[n5];
                                    }
                                    n4 = this.range.invertedNoteOf(key.rootNote());
                                    double d = Math.random();
                                    n6 = (int)((double)n6 * d);
                                    for (n5 = 0; n5 < nArray.length; ++n5) {
                                        if ((n6 -= nArray[n5]) >= 0) continue;
                                        n4 = this.range.min_note + n5;
                                        break;
                                    }
                                    this.addNote(l, l2 + this.min_note_ticks, n4, this.velocity);
                                    if (this.random_lyric) {
                                        this.addStringTo(5, VocaloidLyricGenerator.getRandomLyric(), l);
                                    }
                                    n = n4;
                                } else if (this.is_bass) {
                                    int n10 = this.range.invertedNoteOf(chord.bassNote());
                                    this.addNote(l, l2 + this.min_note_ticks, n10, this.velocity);
                                } else {
                                    for (int n9 : nArray2) {
                                        this.addNote(l, l2 + this.min_note_ticks, n9, this.velocity);
                                    }
                                }
                                bl = false;
                            }
                        }
                        l2 += this.min_note_ticks;
                        ++n2;
                        n3 >>>= 1;
                    }
                }
            }
        }
    }

    public static class DrumTrackSpec
    extends AbstractNoteTrackSpec {
        static int[] default_percussions = new int[]{36, 44, 39, 48, 50, 38, 62, 63};
        PercussionComboBoxModel[] models = new PercussionComboBoxModel[default_percussions.length];
        int[] beat_patterns = new int[]{34952, 8738, 8, 2048, 0, 0, 0, 0};

        public DrumTrackSpec(int n, String string) {
            super(n, string);
            for (int i = 0; i < default_percussions.length; ++i) {
                this.models[i] = new PercussionComboBoxModel(default_percussions[i]);
            }
        }

        public void addDrums(ChordProgression chordProgression) {
            for (ChordProgression.Line line : chordProgression.lines) {
                for (ChordProgression.Measure measure : line) {
                    if (measure.ticks_per_beat == null) continue;
                    ChordProgression.TickRange tickRange = measure.getRange();
                    long l = tickRange.start_tick_pos;
                    int n = 0;
                    int n2 = 32768;
                    while (l < tickRange.end_tick_pos) {
                        for (int i = 0; i < this.beat_patterns.length; ++i) {
                            if ((this.beat_patterns[i] & n2) == 0) continue;
                            this.addNote(l, l + 10L, this.models[i].getSelectedNoteNo(), this.velocity);
                        }
                        l += this.min_note_ticks;
                        ++n;
                        n2 >>>= 1;
                    }
                }
            }
        }

        public class PercussionComboBoxModel
        implements ComboBoxModel {
            private int note_no;

            public PercussionComboBoxModel(int n) {
                this.note_no = n;
            }

            @Override
            public Object getSelectedItem() {
                return this.note_no + ": " + MIDISpec.percussion_names[this.note_no - 35];
            }

            @Override
            public void setSelectedItem(Object object) {
                String string = (String)object;
                int n = 35;
                for (String string2 : MIDISpec.percussion_names) {
                    if (string.equals(n + ": " + string2)) {
                        this.note_no = n;
                        return;
                    }
                    ++n;
                }
            }

            @Override
            public Object getElementAt(int n) {
                return n + 35 + ": " + MIDISpec.percussion_names[n];
            }

            @Override
            public int getSize() {
                return MIDISpec.percussion_names.length;
            }

            @Override
            public void addListDataListener(ListDataListener listDataListener) {
            }

            @Override
            public void removeListDataListener(ListDataListener listDataListener) {
            }

            public int getSelectedNoteNo() {
                return this.note_no;
            }

            public void setSelectedNoteNo(int n) {
                this.note_no = n;
            }
        }
    }

    public static abstract class AbstractNoteTrackSpec
    extends AbstractTrackSpec {
        int midi_channel = -1;
        int program_no = -1;
        int velocity = 64;

        public AbstractNoteTrackSpec() {
        }

        public AbstractNoteTrackSpec(int n) {
            this.midi_channel = n;
        }

        public AbstractNoteTrackSpec(int n, String string) {
            this.midi_channel = n;
            this.name = string;
        }

        public AbstractNoteTrackSpec(int n, String string, int n2) {
            this(n, string);
            this.program_no = n2;
        }

        public AbstractNoteTrackSpec(int n, String string, int n2, int n3) {
            this(n, string, n2);
            this.velocity = n3;
        }

        @Override
        public Track createTrack(Sequence sequence, FirstTrackSpec firstTrackSpec) {
            Track track = super.createTrack(sequence, firstTrackSpec);
            if (this.program_no >= 0) {
                this.addProgram(this.program_no, 0L);
            }
            return track;
        }

        public boolean addProgram(int n, long l) {
            ShortMessage shortMessage;
            try {
                shortMessage = new ShortMessage();
                shortMessage.setMessage(192, this.midi_channel, n, 0);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
                return false;
            }
            return this.track.add(new MidiEvent(shortMessage, l));
        }

        public boolean addNote(long l, long l2, int n) {
            return this.addNote(l, l2, n, this.velocity);
        }

        public boolean addNote(long l, long l2, int n, int n2) {
            ShortMessage shortMessage;
            try {
                shortMessage = new ShortMessage();
                shortMessage.setMessage(144, this.midi_channel, n, n2);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
                return false;
            }
            if (!this.track.add(new MidiEvent(shortMessage, l))) {
                return false;
            }
            try {
                shortMessage = new ShortMessage();
                shortMessage.setMessage(128, this.midi_channel, n, n2);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
                return false;
            }
            return this.track.add(new MidiEvent(shortMessage, l2));
        }
    }

    public static class FirstTrackSpec
    extends AbstractTrackSpec {
        static byte[] default_tempo_data = new byte[]{7, -95, 32};
        static byte[] default_timesig_data = new byte[]{4, 2, 24, 8};
        byte[] tempo_data = default_tempo_data;
        byte[] timesig_data = default_timesig_data;
        Key key = null;
        long ticks_per_measure;

        public FirstTrackSpec() {
        }

        public FirstTrackSpec(String string) {
            this.name = string;
        }

        public FirstTrackSpec(String string, byte[] byArray, byte[] byArray2) {
            this.name = string;
            if (byArray != null) {
                this.tempo_data = byArray;
            }
            if (byArray2 != null) {
                this.timesig_data = byArray2;
            }
        }

        public FirstTrackSpec(String string, byte[] byArray, byte[] byArray2, Key key) {
            this(string, byArray, byArray2);
            this.key = key;
        }

        public Track createTrack(Sequence sequence) {
            return this.createTrack(sequence, 0, 0);
        }

        public Track createTrack(Sequence sequence, int n, int n2) {
            this.pre_measures = n - 1;
            Track track = super.createTrack(sequence, this);
            this.tempo_data = this.tempo_data == null ? default_tempo_data : this.tempo_data;
            this.addTempo(this.tempo_data, 0L);
            this.timesig_data = this.timesig_data == null ? default_timesig_data : this.timesig_data;
            this.addTimeSignature(this.timesig_data, 0L);
            if (this.key != null) {
                this.addKeySignature(this.key, 0L);
            }
            this.ticks_per_measure = 4 * sequence.getResolution() * this.timesig_data[0] >> this.timesig_data[1];
            this.addEOT((long)n2 * this.ticks_per_measure);
            return track;
        }

        public boolean addKeySignature(Key key, long l) {
            return this.addMetaEventTo(89, key.getBytes(), l);
        }

        public boolean addTempo(byte[] byArray, long l) {
            return this.addMetaEventTo(81, byArray, l);
        }

        public boolean addTimeSignature(byte[] byArray, long l) {
            return this.addMetaEventTo(88, byArray, l);
        }
    }

    public static abstract class AbstractTrackSpec {
        public static final int BEAT_RESOLUTION = 2;
        String name = null;
        Track track = null;
        FirstTrackSpec first_track_spec = null;
        Sequence sequence = null;
        long min_note_ticks = 0L;
        int pre_measures = 2;

        public AbstractTrackSpec() {
        }

        public AbstractTrackSpec(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        public Track createTrack(Sequence sequence, FirstTrackSpec firstTrackSpec) {
            this.first_track_spec = firstTrackSpec;
            this.sequence = sequence;
            this.track = this.sequence.createTrack();
            if (this.name != null) {
                this.addStringTo(3, this.name, 0L);
            }
            this.min_note_ticks = sequence.getResolution() >> 2;
            return this.track;
        }

        public boolean addMetaEventTo(int n, byte[] byArray, long l) {
            MetaMessage metaMessage = new MetaMessage();
            try {
                metaMessage.setMessage(n, byArray, byArray.length);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
                return false;
            }
            return this.track.add(new MidiEvent(metaMessage, l));
        }

        public boolean addStringTo(int n, String string, long l) {
            if (string == null) {
                string = "";
            }
            return this.addMetaEventTo(n, string.getBytes(), l);
        }

        public boolean addStringTo(int n, ChordProgression.ChordStroke chordStroke) {
            return this.addStringTo(n, chordStroke.chord.toString(), chordStroke.tick_range.start_tick_pos);
        }

        public boolean addStringTo(int n, ChordProgression.Lyrics lyrics) {
            return this.addStringTo(n, lyrics.text, lyrics.start_tick_pos);
        }

        public boolean addEOT(long l) {
            return this.addMetaEventTo(47, new byte[0], l);
        }

        public void setChordSymbolText(ChordProgression chordProgression) {
            chordProgression.setChordSymbolTextTo(this);
        }
    }

    public static class ChordProgression {
        private Vector<Line> lines = null;
        private Key key = null;
        private Long ticks_per_measure = null;

        public Key getKey() {
            return this.key;
        }

        public void setKey(Key key) {
            this.key = key;
        }

        public String toString() {
            String string = "";
            if (this.key != null) {
                string = string + "Key: " + this.key + "\n";
            }
            for (Line line : this.lines) {
                string = string + line + "\n";
            }
            return string;
        }

        public ChordProgression() {
        }

        public ChordProgression(int n, int n2) {
            int n3 = (int)(Math.random() * 12.0) - 5;
            this.key = new Key(n3, 1);
            this.lines = new Vector();
            Line line = new Line();
            Chord chord = new Chord(n3);
            for (int i = 0; i < n; ++i) {
                boolean bl = i == 0 || i == n - 1;
                Measure measure = new Measure();
                ChordStroke chordStroke = null;
                for (int j = 0; j < n2; ++j) {
                    if (j % 4 == 2 && Math.random() < 0.8 || j % 2 == 1 && Math.random() < 0.9) {
                        ++chordStroke.beat_length;
                        continue;
                    }
                    Chord chord2 = new Chord(n3);
                    int n4 = 0;
                    int n5 = chord.rootNoteSymbol().toCo5() - n3;
                    if (!bl) {
                        double d = Math.random();
                        n4 = n5 - 1;
                        if (n4 < -1 || n5 < 5 && d < 0.5) {
                            while ((n4 = (int)(Math.random() * 13.0) % 7 - 1) == n5) {
                            }
                        }
                        chord2.setRootAndBassByCo5(n3 + n4);
                    }
                    switch (n4) {
                        case 5: {
                            if (Math.random() < 0.5) {
                                chord2.setMinorThird();
                                chord2.setFlattedFifth();
                            }
                            if (!(Math.random() < 0.8)) break;
                            chord2.setSeventh();
                            break;
                        }
                        case 4: {
                            if (n5 == 5) {
                                if (Math.random() < 0.2) {
                                    chord2.setMinorThird();
                                }
                            } else if (Math.random() < 0.8) {
                                chord2.setMinorThird();
                            }
                            if (!(Math.random() < 0.7)) break;
                            chord2.setSeventh();
                            break;
                        }
                        case 3: {
                            if (Math.random() < 0.8) {
                                chord2.setMinorThird();
                            }
                            if (!(Math.random() < 0.7)) break;
                            chord2.setSeventh();
                            break;
                        }
                        case 2: {
                            if (Math.random() < 0.8) {
                                chord2.setMinorThird();
                            }
                            if (!(Math.random() < 0.7)) break;
                            chord2.setSeventh();
                            break;
                        }
                        case 1: {
                            if (Math.random() < 0.1) {
                                chord2.setMinorThird();
                            }
                            if (Math.random() < 0.3) {
                                chord2.setSeventh();
                            }
                            if (!(Math.random() < 0.2)) break;
                            chord2.setNinth();
                            break;
                        }
                        case 0: {
                            if (Math.random() < 0.2) {
                                chord2.setMajorSeventh();
                            }
                            if (!(Math.random() < 0.2)) break;
                            chord2.setNinth();
                            break;
                        }
                        case -1: {
                            if (Math.random() < 0.1) {
                                chord2.setMinorThird();
                                if (Math.random() < 0.3) {
                                    chord2.setSeventh();
                                }
                            } else if (Math.random() < 0.2) {
                                chord2.setMajorSeventh();
                            }
                            if (!(Math.random() < 0.2)) break;
                            chord2.setNinth();
                        }
                    }
                    chordStroke = new ChordStroke(chord2);
                    measure.add(chordStroke);
                    chord = chord2;
                }
                line.add(measure);
                if ((i + 1) % 8 != 0) continue;
                this.lines.add(line);
                line = new Line();
            }
            if (line.size() > 0) {
                this.lines.add(line);
            }
        }

        public ChordProgression(String string) {
            if (string == null) {
                return;
            }
            Chord chord = null;
            String string2 = "^Key(\\s*):(\\s*)";
            Pattern pattern = Pattern.compile(string2 + ".*$", 2);
            Pattern pattern2 = Pattern.compile(string2, 2);
            String[] stringArray = string.split("[\r\n]+");
            this.lines = new Vector();
            for (String string3 : stringArray) {
                String[] stringArray2;
                String[] stringArray3 = string3.split("\\|");
                if (stringArray3.length > 0 && pattern.matcher((CharSequence)(stringArray2 = stringArray3[0].trim())).matches()) {
                    this.key = new Key(pattern2.matcher((CharSequence)stringArray2).replaceFirst(""));
                    continue;
                }
                Line line = new Line();
                stringArray2 = stringArray3;
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String string4 = stringArray2[i];
                    String[] stringArray4 = string4.split("[ \t]+");
                    Measure measure = new Measure();
                    for (String string5 : stringArray4) {
                        if (string5.isEmpty()) continue;
                        if (string5.equals("%")) {
                            if (measure.addBeat() != 0) continue;
                            measure.add(new ChordStroke(chord));
                            continue;
                        }
                        try {
                            chord = new Chord(string5);
                            measure.add(new ChordStroke(chord));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            measure.add(new Lyrics(string5));
                        }
                    }
                    line.add(measure);
                }
                this.lines.add(line);
            }
        }

        public void toggleKeyMajorMinor() {
            this.key = this.key.relativeKey();
        }

        public void transpose(int n) {
            for (Line line : this.lines) {
                for (Measure measure : line) {
                    for (int i = 0; i < measure.size(); ++i) {
                        Object e = measure.get(i);
                        if (!(e instanceof ChordStroke)) continue;
                        ChordStroke chordStroke = (ChordStroke)e;
                        Chord chord = chordStroke.chord.clone();
                        if (this.key == null) {
                            this.key = new Key(chord);
                        }
                        chord.transpose(n, this.key);
                        measure.set(i, new ChordStroke(chord, chordStroke.beat_length));
                    }
                }
            }
            this.key.transpose(n);
        }

        public void toggleEnharmonically() {
            if (this.key == null) {
                return;
            }
            int n = this.key.toCo5();
            int n2 = 0;
            if (n > 4) {
                n2 = -12;
            } else if (n < -4) {
                n2 = 12;
            } else {
                return;
            }
            this.key.toggleEnharmonically();
            for (Line line : this.lines) {
                for (Measure measure : line) {
                    for (int i = 0; i < measure.size(); ++i) {
                        Object e = measure.get(i);
                        if (!(e instanceof ChordStroke)) continue;
                        ChordStroke chordStroke = (ChordStroke)e;
                        Chord chord = chordStroke.chord.clone();
                        chord.setRootByCo5(chord.rootNoteSymbol().toCo5() + n2);
                        chord.setBassByCo5(chord.bassNoteSymbol().toCo5() + n2);
                        measure.set(i, new ChordStroke(chord, chordStroke.beat_length));
                    }
                }
            }
        }

        public void setTickPositions(FirstTrackSpec firstTrackSpec) {
            this.ticks_per_measure = firstTrackSpec.ticks_per_measure;
            TickRange tickRange = new TickRange((long)firstTrackSpec.pre_measures * this.ticks_per_measure);
            for (Line line : this.lines) {
                for (Measure measure : line) {
                    int n = measure.numberOfBeats();
                    if (n == 0) continue;
                    measure.ticks_per_beat = this.ticks_per_measure / (long)n;
                    long l = measure.ticks_per_beat;
                    for (Object e : measure) {
                        if (e instanceof Lyrics) {
                            ((Lyrics)e).start_tick_pos = tickRange.start_tick_pos;
                            continue;
                        }
                        if (!(e instanceof ChordStroke)) continue;
                        ChordStroke chordStroke = (ChordStroke)e;
                        tickRange.moveForward(l * (long)chordStroke.beat_length);
                        chordStroke.tick_range = tickRange.clone();
                    }
                }
            }
        }

        public void setChordSymbolTextTo(AbstractTrackSpec abstractTrackSpec) {
            for (Line line : this.lines) {
                for (Measure measure : line) {
                    if (measure.ticks_per_beat == null) continue;
                    for (Object e : measure) {
                        if (!(e instanceof ChordStroke)) continue;
                        abstractTrackSpec.addStringTo(1, (ChordStroke)e);
                    }
                }
            }
        }

        public void setLyricsTo(AbstractTrackSpec abstractTrackSpec) {
            for (Line line : this.lines) {
                for (Measure measure : line) {
                    if (measure.ticks_per_beat == null) continue;
                    for (Object e : measure) {
                        if (!(e instanceof Lyrics)) continue;
                        abstractTrackSpec.addStringTo(5, (Lyrics)e);
                    }
                }
            }
        }

        public Sequence toMidiSequence() {
            return this.toMidiSequence(48);
        }

        public Sequence toMidiSequence(int n) {
            return this.toMidiSequence(n, 0, 0, null, null);
        }

        public Sequence toMidiSequence(int n, int n2, int n3, FirstTrackSpec firstTrackSpec, Vector<AbstractNoteTrackSpec> vector) {
            Sequence sequence;
            try {
                sequence = new Sequence(0.0f, n);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
                return null;
            }
            if (firstTrackSpec == null) {
                firstTrackSpec = new FirstTrackSpec();
            }
            firstTrackSpec.key = this.key;
            firstTrackSpec.createTrack(sequence, n2, n3);
            if (this.lines == null || vector == null) {
                return sequence;
            }
            this.setTickPositions(firstTrackSpec);
            this.setChordSymbolTextTo(firstTrackSpec);
            this.setLyricsTo(firstTrackSpec);
            for (AbstractNoteTrackSpec abstractNoteTrackSpec : vector) {
                abstractNoteTrackSpec.createTrack(sequence, firstTrackSpec);
                if (abstractNoteTrackSpec instanceof DrumTrackSpec) {
                    ((DrumTrackSpec)abstractNoteTrackSpec).addDrums(this);
                    continue;
                }
                ((MelodyTrackSpec)abstractNoteTrackSpec).addChords(this);
            }
            return sequence;
        }

        private class Line
        extends Vector<Measure> {
            private Line() {
            }

            @Override
            public String toString() {
                String string = "";
                for (Measure measure : this) {
                    string = string + measure + "|";
                }
                return string;
            }
        }

        private class Measure
        extends Vector<Object> {
            Long ticks_per_beat = null;

            private Measure() {
            }

            public int numberOfBeats() {
                int n = 0;
                for (Object e : this) {
                    if (!(e instanceof ChordStroke)) continue;
                    n += ((ChordStroke)e).beat_length;
                }
                return n;
            }

            public boolean isEquallyDivided() {
                int n = 0;
                for (Object e : this) {
                    if (!(e instanceof ChordStroke)) continue;
                    int n2 = ((ChordStroke)e).beat_length;
                    if (n > 0 && n != n2) {
                        return false;
                    }
                    n = n2;
                }
                return true;
            }

            public int addBeat() {
                return this.addBeat(1);
            }

            public int addBeat(int n) {
                ChordStroke chordStroke = null;
                for (Object e : this) {
                    if (!(e instanceof ChordStroke)) continue;
                    chordStroke = (ChordStroke)e;
                }
                if (chordStroke == null) {
                    return 0;
                }
                return chordStroke.beat_length += n;
            }

            @Override
            public String toString() {
                String string = "";
                boolean bl = this.isEquallyDivided();
                for (Object e : this) {
                    string = string + " ";
                    if (e instanceof ChordStroke) {
                        ChordStroke chordStroke = (ChordStroke)e;
                        string = string + (bl ? chordStroke.chord : chordStroke);
                        continue;
                    }
                    if (!(e instanceof Lyrics)) continue;
                    string = string + (String)e;
                }
                return string;
            }

            public TickRange getRange() {
                long l = -1L;
                long l2 = -1L;
                for (Object e : this) {
                    if (!(e instanceof ChordStroke)) continue;
                    ChordStroke chordStroke = (ChordStroke)e;
                    Chord chord = chordStroke.chord;
                    if (l < 0L) {
                        l = chordStroke.tick_range.start_tick_pos;
                    }
                    l2 = chordStroke.tick_range.end_tick_pos;
                }
                if (l < 0L || l2 < 0L) {
                    return null;
                }
                return new TickRange(l, l2);
            }

            public ChordStroke chordStrokeAt(long l) {
                for (Object e : this) {
                    if (!(e instanceof ChordStroke)) continue;
                    ChordStroke chordStroke = (ChordStroke)e;
                    if (!chordStroke.tick_range.contains(l)) continue;
                    return chordStroke;
                }
                return null;
            }
        }

        private class Lyrics {
            String text = null;
            Long start_tick_pos = null;

            public Lyrics(String string) {
                this.text = string;
            }

            public Lyrics(String string, long l) {
                this.text = string;
                this.start_tick_pos = l;
            }

            public String toString() {
                return this.text;
            }
        }

        private class ChordStroke {
            Chord chord;
            int beat_length;
            TickRange tick_range = null;

            public ChordStroke(Chord chord) {
                this(chord, 1);
            }

            public ChordStroke(Chord chord, int n) {
                this.chord = chord;
                this.beat_length = n;
            }

            public String toString() {
                String string = this.chord.toString();
                for (int i = 2; i <= this.beat_length; ++i) {
                    string = string + " %";
                }
                return string;
            }
        }

        private class TickRange
        implements Cloneable {
            long start_tick_pos = 0L;
            long end_tick_pos = 0L;

            public TickRange() {
            }

            public TickRange(long l) {
                this.end_tick_pos = this.start_tick_pos = l;
            }

            public TickRange(long l, long l2) {
                this.start_tick_pos = l;
                this.end_tick_pos = l2;
            }

            protected TickRange clone() {
                return new TickRange(this.start_tick_pos, this.end_tick_pos);
            }

            public void moveForward() {
                this.start_tick_pos = this.end_tick_pos;
            }

            public void moveForward(long l) {
                this.start_tick_pos = this.end_tick_pos;
                this.end_tick_pos += l;
            }

            public long duration() {
                return this.end_tick_pos - this.start_tick_pos;
            }

            public boolean contains(long l) {
                return l >= this.start_tick_pos && l < this.end_tick_pos;
            }
        }
    }

    public static class Chord
    implements Cloneable {
        public static final Color[] index_colors = new Color[]{Color.red, new Color(64, 64, 255), Color.orange.darker(), new Color(32, 153, 0), Color.magenta, Color.orange, Color.green};
        private NoteSymbol root_note_symbol = new NoteSymbol(0);
        private NoteSymbol bass_note_symbol = new NoteSymbol(0);
        private int bassnote = 0;
        private int rootnote = 0;
        public static final int ROOT = 0;
        public static final int SUS2 = 2;
        public static final int MINOR = 3;
        public static final int MAJOR = 4;
        public static final int SUS4 = 5;
        public static final int FLAT5 = 6;
        public static final int PARFECT5 = 7;
        public static final int SHARP5 = 8;
        public static final int SIXTH = 9;
        public static final int SEVENTH = 10;
        public static final int MAJOR_SEVENTH = 11;
        public static final int FLAT9 = 13;
        public static final int NINTH = 14;
        public static final int SHARP9 = 15;
        public static final int ELEVENTH = 17;
        public static final int SHARP11 = 18;
        public static final int FLAT13 = 20;
        public static final int THIRTEENTH = 21;
        public static final int THIRD_OFFSET = 0;
        public static final int FIFTH_OFFSET = 1;
        public static final int SEVENTH_OFFSET = 2;
        public static final int NINTH_OFFSET = 3;
        public static final int ELEVENTH_OFFSET = 4;
        public static final int THIRTEENTH_OFFSET = 5;
        public static int[] default_offsets = new int[]{4, 7, 0, 0, 0, 0};
        public int[] offsets = Arrays.copyOf(default_offsets, default_offsets.length);

        public Chord() {
            this(0);
        }

        public Chord(int n) {
            this.setRootAndBassByCo5(n);
        }

        public Chord(NoteSymbol noteSymbol) {
            this(noteSymbol.toCo5());
        }

        public Chord(String string) {
            this.setChordSymbol(string);
        }

        public Chord(Key key) {
            int n = key.toCo5();
            if (key.majorMinor() == -1) {
                this.setRootAndBassByCo5(n + 3);
                this.setMinorThird();
            } else {
                this.setRootAndBassByCo5(n);
            }
        }

        protected Chord clone() {
            Chord chord = new Chord(this.root_note_symbol);
            chord.offsets = Arrays.copyOf(this.offsets, this.offsets.length);
            chord.setBassByCo5(this.bass_note_symbol.toCo5());
            return chord;
        }

        public Chord setRootByCo5(int n) {
            this.root_note_symbol = new NoteSymbol(n);
            this.rootnote = this.root_note_symbol.toNoteNo();
            return this;
        }

        public Chord setBassByCo5(int n) {
            this.bass_note_symbol = new NoteSymbol(n);
            this.bassnote = this.bass_note_symbol.toNoteNo();
            return this;
        }

        public Chord setRootAndBassByCo5(int n) {
            this.setRootByCo5(n);
            this.setBassByCo5(n);
            return this;
        }

        public void setMajorThird() {
            this.offsets[0] = 4;
        }

        public void setMinorThird() {
            this.offsets[0] = 3;
        }

        public void setSus4() {
            this.offsets[0] = 5;
        }

        public void setSus2() {
            this.offsets[0] = 2;
        }

        public void setParfectFifth() {
            this.offsets[1] = 7;
        }

        public void setFlattedFifth() {
            this.offsets[1] = 6;
        }

        public void setSharpedFifth() {
            this.offsets[1] = 8;
        }

        public void clearSeventh() {
            this.offsets[2] = 0;
        }

        public void setMajorSeventh() {
            this.offsets[2] = 11;
        }

        public void setSeventh() {
            this.offsets[2] = 10;
        }

        public void setSixth() {
            this.offsets[2] = 9;
        }

        public void clearNinth() {
            this.offsets[3] = 0;
        }

        public void setNinth() {
            this.offsets[3] = 14;
        }

        public void setSharpedNinth() {
            this.offsets[3] = 15;
        }

        public void setFlattedNinth() {
            this.offsets[3] = 13;
        }

        public void clearEleventh() {
            this.offsets[4] = 0;
        }

        public void setEleventh() {
            this.offsets[4] = 17;
        }

        public void setSharpedEleventh() {
            this.offsets[4] = 18;
        }

        public void clearThirteenth() {
            this.offsets[5] = 0;
        }

        public void setThirteenth() {
            this.offsets[5] = 21;
        }

        public void setFlattedThirteenth() {
            this.offsets[5] = 20;
        }

        public Chord setChordSymbol(String string) {
            String[] stringArray = string.trim().split("(/|on)");
            if (stringArray.length == 0) {
                return this;
            }
            this.setRootByCo5(new NoteSymbol(stringArray[0]).toCo5());
            this.setBassByCo5(new NoteSymbol(stringArray[stringArray.length > 1 ? 1 : 0]).toCo5());
            String string2 = stringArray[0].replaceFirst("^[A-G][#bx]*", "");
            String[] stringArray2 = string2.split("[\\(\\)]");
            if (stringArray2.length == 0) {
                return this;
            }
            String string3 = "";
            if (stringArray2.length > 1) {
                string3 = stringArray2[1];
                string2 = stringArray2[0];
            }
            int n = string2.matches(".*(\\+5|aug|#5).*") ? 8 : (this.offsets[1] = string2.matches(".*(-5|dim|b5).*") ? 6 : 7);
            int n2 = string2.matches(".*(M7|maj7|M9|maj9).*") ? 11 : (string2.matches(".*(6|dim[79]).*") ? 9 : (this.offsets[2] = string2.matches(".*7.*") ? 10 : 0));
            int n3 = string2.matches(".*m.*") && !string2.matches(".*ma.*") ? 3 : (this.offsets[0] = string2.matches(".*sus4.*") ? 5 : 4);
            if (string2.matches(".*9.*")) {
                this.offsets[3] = 14;
                if (!string2.matches(".*(add9|6|M9|maj9|dim9).*")) {
                    this.offsets[2] = 10;
                }
            } else {
                String[] stringArray3;
                this.offsets[5] = 0;
                this.offsets[4] = 0;
                this.offsets[3] = 0;
                for (String string4 : stringArray3 = string3.split(",")) {
                    if (string4.matches("(\\+9|#9)")) {
                        this.offsets[3] = 15;
                    } else if (string4.matches("(-9|b9)")) {
                        this.offsets[3] = 13;
                    } else if (string4.matches("9")) {
                        this.offsets[3] = 14;
                    }
                    if (string4.matches("(\\+11|#11)")) {
                        this.offsets[4] = 18;
                    } else if (string4.matches("11")) {
                        this.offsets[4] = 17;
                    }
                    if (string4.matches("(-13|b13)")) {
                        this.offsets[5] = 20;
                    } else if (string4.matches("13")) {
                        this.offsets[5] = 21;
                    }
                    if (string4.matches("(-5|b5)")) {
                        this.offsets[1] = 6;
                        continue;
                    }
                    if (!string4.matches("(\\+5|#5)")) continue;
                    this.offsets[1] = 8;
                }
            }
            return this;
        }

        public NoteSymbol rootNoteSymbol() {
            return this.root_note_symbol;
        }

        public NoteSymbol bassNoteSymbol() {
            return this.bass_note_symbol;
        }

        public int rootNote() {
            return this.rootnote;
        }

        public int bassNote() {
            return this.bassnote;
        }

        public boolean isMajor() {
            return this.offsets[0] == 4;
        }

        public boolean isMinor() {
            return this.offsets[0] == 3;
        }

        public boolean isSus4() {
            return this.offsets[0] == 5;
        }

        public boolean isSus2() {
            return this.offsets[0] == 2;
        }

        public boolean hasParfectFifth() {
            return this.offsets[1] == 7;
        }

        public boolean hasFlattedFifth() {
            return this.offsets[1] == 6;
        }

        public boolean hasSharpedFifth() {
            return this.offsets[1] == 8;
        }

        public boolean hasNoSeventh() {
            return this.offsets[2] == 0;
        }

        public boolean hasSeventh() {
            return this.offsets[2] == 10;
        }

        public boolean hasMajorSeventh() {
            return this.offsets[2] == 11;
        }

        public boolean hasSixth() {
            return this.offsets[2] == 9;
        }

        public boolean hasNoNinth() {
            return this.offsets[3] == 0;
        }

        public boolean hasNinth() {
            return this.offsets[3] == 14;
        }

        public boolean hasFlattedNinth() {
            return this.offsets[3] == 13;
        }

        public boolean hasSharpedNinth() {
            return this.offsets[3] == 15;
        }

        public boolean hasNoEleventh() {
            return this.offsets[4] == 0;
        }

        public boolean hasEleventh() {
            return this.offsets[4] == 17;
        }

        public boolean hasSharpedEleventh() {
            return this.offsets[4] == 18;
        }

        public boolean hasNoThirteenth() {
            return this.offsets[5] == 0;
        }

        public boolean hasThirteenth() {
            return this.offsets[5] == 21;
        }

        public boolean hasFlattedThirteenth() {
            return this.offsets[5] == 20;
        }

        public boolean equals(Chord chord) {
            return chord != null && this.root_note_symbol.toCo5() == chord.rootNoteSymbol().toCo5() && this.bass_note_symbol.toCo5() == chord.bassNoteSymbol().toCo5() && Arrays.equals(this.offsets, chord.offsets);
        }

        public boolean equalsEnharmonically(Chord chord) {
            return chord != null && this.rootnote == chord.rootNote() && this.bassnote == chord.bassNote() && Arrays.equals(this.offsets, chord.offsets);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public int numberOfNotes() {
            int n = 1;
            for (int n2 : this.offsets) {
                if (n2 == 0) continue;
                ++n;
            }
            return n;
        }

        public int noteAt(int n) {
            if (n == 0) {
                return this.rootnote;
            }
            int n2 = 0;
            for (int n3 : this.offsets) {
                if (n3 == 0 || ++n2 != n) continue;
                return this.rootnote + n3;
            }
            return -1;
        }

        public int[] toNoteArray() {
            return this.toNoteArray(null, null);
        }

        public int[] toNoteArray(Range range) {
            return this.toNoteArray(range, null);
        }

        public int[] toNoteArray(Range range, Key key) {
            int[] nArray = new int[this.numberOfNotes()];
            int n = 0;
            nArray[0] = this.rootnote;
            for (int n2 : this.offsets) {
                if (n2 == 0) continue;
                nArray[++n] = this.rootnote + n2;
            }
            if (range != null) {
                range.invertNotesOf(nArray, key);
            }
            return nArray;
        }

        public int indexOf(int n) {
            int n2 = n - this.rootnote;
            if (Music.mod12(n2) == 0) {
                return 0;
            }
            int n3 = 0;
            for (int n4 : this.offsets) {
                if (n4 == 0) continue;
                ++n3;
                if (Music.mod12(n2 - n4) != 0) continue;
                return n3;
            }
            return -1;
        }

        public boolean isOnScaleInKey(Key key) {
            return this.isOnScaleInKey(key.toCo5());
        }

        public boolean isOnScaleInKey(int n) {
            if (!Music.isOnScale(this.rootnote, n)) {
                return false;
            }
            for (int n2 : this.offsets) {
                if (n2 == 0 || Music.isOnScale(this.rootnote + n2, n)) continue;
                return false;
            }
            return true;
        }

        public Chord transpose(int n) {
            return this.transpose(n, 0);
        }

        public Chord transpose(int n, Key key) {
            return this.transpose(n, key.toCo5());
        }

        public Chord transpose(int n, int n2) {
            if (n == 0) {
                return this;
            }
            int n3 = Music.mod12(Music.reverseCo5(n));
            if (n3 > 6) {
                n3 -= 12;
            }
            int n4 = n2 + n3;
            int n5 = this.root_note_symbol.toCo5() + n3;
            int n6 = this.bass_note_symbol.toCo5() + n3;
            if (n4 > 6) {
                n5 -= 12;
                n6 -= 12;
            } else if (n4 < -5) {
                n5 += 12;
                n6 += 12;
            }
            this.setRootByCo5(n5);
            return this.setBassByCo5(n6);
        }

        public String toString() {
            String string = this.rootNoteSymbol() + this.symbolSuffix();
            if (!this.root_note_symbol.equals(this.bass_note_symbol)) {
                string = string + "/" + this.bassNoteSymbol();
            }
            return string;
        }

        public String toHtmlString(String string) {
            String string2;
            String string3 = "<span style=\"font-size: 120%\">";
            String string4 = "</span>";
            String string5 = this.root_note_symbol.toString();
            String string6 = string5.length() == 1 ? string5 + string3 : string5.replace("#", string3 + "<sup>#</sup>").replace("b", string3 + "<sup>b</sup>").replace("x", string3 + "<sup>x</sup>");
            String string7 = "";
            if (!this.root_note_symbol.equals(this.bass_note_symbol)) {
                string2 = this.bass_note_symbol.toString();
                string7 = string2.length() == 1 ? string2 + string3 : string2.replace("#", string3 + "<sup>#</sup>").replace("b", string3 + "<sup>b</sup>").replace("x", string3 + "<sup>x</sup>");
                string7 = "/" + string7 + string4;
            }
            string2 = this.symbolSuffix().replace("-5", "<sup>-5</sup>").replace("+5", "<sup>+5</sup>");
            return "<html><span style=\"color: " + string + "; font-size: 170% ; white-space: nowrap ;\">" + string6 + string2 + string4 + string7 + "</span>" + "</html>";
        }

        public String toName() {
            String string = this.root_note_symbol.toStringIn(1) + this.nameSuffix();
            if (!this.root_note_symbol.equals(this.bass_note_symbol)) {
                string = string + " on " + this.bass_note_symbol.toStringIn(1);
            }
            return string;
        }

        public String symbolSuffix() {
            String string = this.offsets[0] == 3 ? "m" : "";
            switch (this.offsets[2]) {
                case 9: {
                    string = string + "6";
                    break;
                }
                case 10: {
                    string = string + "7";
                    break;
                }
                case 11: {
                    string = string + "M7";
                }
            }
            switch (this.offsets[0]) {
                case 5: {
                    string = string + "sus4";
                    break;
                }
                case 2: {
                    string = string + "sus2";
                    break;
                }
            }
            switch (this.offsets[1]) {
                case 6: {
                    string = string + "-5";
                    break;
                }
                case 8: {
                    string = string + "+5";
                    break;
                }
            }
            Vector<String> vector = new Vector<String>();
            switch (this.offsets[3]) {
                case 14: {
                    vector.add("9");
                    break;
                }
                case 13: {
                    vector.add("-9");
                    break;
                }
                case 15: {
                    vector.add("+9");
                }
            }
            switch (this.offsets[4]) {
                case 17: {
                    vector.add("11");
                    break;
                }
                case 18: {
                    vector.add("+11");
                }
            }
            switch (this.offsets[5]) {
                case 21: {
                    vector.add("13");
                    break;
                }
                case 20: {
                    vector.add("-13");
                }
            }
            if (vector.size() > 0) {
                boolean bl = true;
                string = string + "(";
                for (String string2 : vector) {
                    if (bl) {
                        bl = false;
                    } else {
                        string = string + ",";
                    }
                    string = string + string2;
                }
                string = string + ")";
            }
            if (string.equals("m-5")) {
                return "dim";
            }
            if (string.equals("+5")) {
                return "aug";
            }
            if (string.equals("m6-5")) {
                return "dim7";
            }
            if (string.equals("(9)")) {
                return "add9";
            }
            if (string.equals("7(9)")) {
                return "9";
            }
            if (string.equals("M7(9)")) {
                return "M9";
            }
            if (string.equals("7+5")) {
                return "aug7";
            }
            if (string.equals("m6-5(9)")) {
                return "dim9";
            }
            return string;
        }

        public String nameSuffix() {
            String string = "";
            if (this.offsets[0] == 3) {
                string = string + " minor";
            }
            switch (this.offsets[2]) {
                case 9: {
                    string = string + " 6th";
                    break;
                }
                case 10: {
                    string = string + " 7th";
                    break;
                }
                case 11: {
                    string = string + " major 7th";
                }
            }
            switch (this.offsets[0]) {
                case 5: {
                    string = string + " suspended 4th";
                    break;
                }
                case 2: {
                    string = string + " suspended 2nd";
                    break;
                }
            }
            switch (this.offsets[1]) {
                case 6: {
                    string = string + " flatted 5th";
                    break;
                }
                case 8: {
                    string = string + " sharped 5th";
                    break;
                }
            }
            Vector<String> vector = new Vector<String>();
            switch (this.offsets[3]) {
                case 14: {
                    vector.add("9th");
                    break;
                }
                case 13: {
                    vector.add("flatted 9th");
                    break;
                }
                case 15: {
                    vector.add("sharped 9th");
                }
            }
            switch (this.offsets[4]) {
                case 17: {
                    vector.add("11th");
                    break;
                }
                case 18: {
                    vector.add("sharped 11th");
                }
            }
            switch (this.offsets[5]) {
                case 21: {
                    vector.add("13th");
                    break;
                }
                case 20: {
                    vector.add("flatted 13th");
                }
            }
            if (vector.size() > 0) {
                boolean bl = true;
                string = string + "(additional ";
                for (String string2 : vector) {
                    if (bl) {
                        bl = false;
                    } else {
                        string = string + ",";
                    }
                    string = string + string2;
                }
                string = string + ")";
            }
            if (string.equals(" minor flatted 5th")) {
                return " diminished (triad)";
            }
            if (string.equals(" sharped 5th")) {
                return " augumented";
            }
            if (string.equals(" minor 6th flatted 5th")) {
                return " diminished 7th";
            }
            if (string.equals(" 7th(additional 9th)")) {
                return " 9th";
            }
            if (string.equals(" major 7th(additional 9th)")) {
                return " major 9th";
            }
            if (string.equals(" 7th sharped 5th")) {
                return " augumented 7th";
            }
            if (string.equals(" minor 6th flatted 5th(additional 9th)")) {
                return " diminished 9th";
            }
            if (string.isEmpty()) {
                return " major";
            }
            return string;
        }
    }

    public static class Key
    implements Cloneable {
        public static final int MAJOR_OR_MINOR = 0;
        public static final int MAJOR = 1;
        public static final int MINOR = -1;
        private static final String[][] key_strings = new String[][]{{"", "m", " / "}, {" major", " minor", " / "}, {"\u9577\u8abf", "\u77ed\u8abf", "\uff0f"}};
        private int co5;
        private int major_minor;

        public Key() {
            this.setKey(0, 0);
        }

        public Key(int n) {
            this.setKey(n, 0);
        }

        public Key(int n, int n2) {
            this.setKey(n, n2);
        }

        public Key(int n, boolean bl) {
            this.setKey(n, bl);
        }

        public Key(byte[] byArray) {
            this.setBytes(byArray);
        }

        public Key(String string) {
            boolean bl = string.matches(".*m");
            this.setKey(new NoteSymbol(string).toCo5(bl), bl);
        }

        public Key(Chord chord) {
            boolean bl = chord.isMinor();
            this.setKey(chord.rootNoteSymbol().toCo5(bl), bl);
        }

        protected Key clone() {
            return new Key(this.co5, this.major_minor);
        }

        public boolean equals(Key key) {
            return this.co5 == key.toCo5() && this.major_minor == key.majorMinor();
        }

        public int hashCode() {
            return (1 - this.major_minor) * 256 + this.co5;
        }

        private void setKey(int n, boolean bl) {
            this.setKey(n, bl ? -1 : 1);
        }

        private void setKey(int n, int n2) {
            this.co5 = n;
            this.major_minor = n2;
            this.normalize();
        }

        public void setBytes(byte[] byArray) {
            byte by = byArray.length > 0 ? byArray[0] : (byte)0;
            byte by2 = byArray.length > 1 ? byArray[1] : (byte)0;
            this.setKey((int)by, by2 == 1);
        }

        public byte[] getBytes() {
            byte[] byArray = new byte[]{(byte)(this.co5 & 0xFF), (byte)(this.major_minor == -1 ? 1 : 0)};
            return byArray;
        }

        public int toCo5() {
            return this.co5;
        }

        public int majorMinor() {
            return this.major_minor;
        }

        public int relativeDo() {
            return new NoteSymbol(this.co5).toNoteNo();
        }

        public int rootNote() {
            int n = this.relativeDo();
            return this.major_minor == -1 ? Music.mod12(n - 3) : n;
        }

        public boolean isOnScale(int n) {
            return Music.isOnScale(n, this.co5);
        }

        public Key transpose(int n) {
            this.co5 = Music.transposeCo5(this.co5, n);
            return this;
        }

        public void toggleEnharmonically() {
            if (this.co5 > 4) {
                this.co5 -= 12;
            } else if (this.co5 < -4) {
                this.co5 += 12;
            }
        }

        public void normalize() {
            if (this.co5 < -7 || this.co5 > 7) {
                this.co5 = Music.mod12(this.co5);
                if (this.co5 > 6) {
                    this.co5 -= 12;
                }
            }
        }

        public Key relativeKey() {
            return new Key(this.co5, this.major_minor * -1);
        }

        public Key parallelKey() {
            switch (this.major_minor) {
                case 1: {
                    return new Key(this.co5 - 3, -1);
                }
                case -1: {
                    return new Key(this.co5 + 3, 1);
                }
            }
            return new Key(this.co5);
        }

        public Key oppositeKey() {
            return new Key(Music.oppositeCo5(this.co5), this.major_minor);
        }

        public String toString() {
            return this.toStringIn(0);
        }

        public String toStringIn(int n) {
            NoteSymbol noteSymbol = new NoteSymbol(this.co5);
            String string = noteSymbol.toStringIn(n, false) + key_strings[n][0];
            if (this.major_minor > 0) {
                return string;
            }
            String string2 = noteSymbol.toStringIn(n, true) + key_strings[n][1];
            return this.major_minor < 0 ? string2 : string + key_strings[n][2] + string2;
        }

        public String signature() {
            switch (this.co5) {
                case 0: {
                    return "==";
                }
                case 1: {
                    return "#";
                }
                case -1: {
                    return "b";
                }
                case 2: {
                    return "##";
                }
                case -2: {
                    return "bb";
                }
            }
            if (this.co5 >= 3 && this.co5 <= 7) {
                return this.co5 + "#";
            }
            if (this.co5 <= -3 && this.co5 >= -7) {
                return -this.co5 + "b";
            }
            return "";
        }

        public String signatureDescription() {
            switch (this.co5) {
                case 0: {
                    return "no sharps or flats";
                }
                case 1: {
                    return "1 sharp";
                }
                case -1: {
                    return "1 flat";
                }
            }
            return this.co5 < 0 ? -this.co5 + " flats" : this.co5 + " sharps";
        }
    }

    public static class Range {
        public int min_note = 0;
        public int max_note = 127;
        public int min_key_offset = 0;
        public boolean is_inversion_mode = true;

        public Range(int n, int n2) {
            this.min_note = n;
            this.max_note = n2;
        }

        public Range(Integer[] integerArray) {
            if (integerArray == null) {
                return;
            }
            switch (integerArray.length) {
                case 0: {
                    return;
                }
                case 1: {
                    this.min_note = this.max_note = integerArray[0].intValue();
                    break;
                }
                default: {
                    if (integerArray[0] > integerArray[1]) {
                        this.min_note = integerArray[1];
                        this.max_note = integerArray[0];
                        break;
                    }
                    this.min_note = integerArray[0];
                    this.max_note = integerArray[1];
                }
            }
        }

        public Range(int n, int n2, int n3, boolean bl) {
            this.min_note = n;
            this.max_note = n2;
            this.min_key_offset = n3;
            this.is_inversion_mode = bl;
        }

        public int invertedNoteOf(int n) {
            return this.invertedNoteOf(n, null);
        }

        public int invertedNoteOf(int n, Key key) {
            int n2 = this.min_note;
            int n3 = this.max_note;
            int n4 = 0;
            if (key != null) {
                n4 = key.relativeDo();
                if (this.min_key_offset < 0 && n4 >= Music.mod12(this.min_key_offset)) {
                    n4 -= 12;
                } else if (this.min_key_offset > 0 && n4 < Music.mod12(this.min_key_offset)) {
                    n4 += 12;
                }
                n2 += n4;
                n3 += n4;
            }
            int n5 = n2 / 12;
            n += 12 * n5;
            while (n > n3) {
                n -= 12;
            }
            while (n > 127) {
                n -= 12;
            }
            while (n < n2) {
                n += 12;
            }
            while (n < 0) {
                n += 12;
            }
            return n;
        }

        public void invertNotesOf(int[] nArray, Key key) {
            if (this.is_inversion_mode) {
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = this.invertedNoteOf(nArray[i], key);
                }
            } else {
                int n = this.invertedNoteOf(nArray[0], new Key(this.min_key_offset));
                int n2 = n - nArray[0];
                nArray[0] = n;
                int n3 = 1;
                while (n3 < nArray.length) {
                    int n4 = n3++;
                    nArray[n4] = nArray[n4] + n2;
                }
            }
        }
    }

    public static class NoteSymbol
    implements Cloneable {
        public static final int NOTE_SYMBOL = 0;
        public static final int NOTE_NAME = 1;
        public static final int NOTE_IN_JAPANESE = 2;
        private static final String[][] note_strings = new String[][]{{"bb", "b", "", "#", "x", "FCGDAEB"}, {" double flat", " flat", "", " sharp", " double sharp", "FCGDAEB"}, {"\u91cd\u5909", "\u5909", "", "\u5b30", "\u91cd\u5b30", "\u30d8\u30cf\u30c8\u30cb\u30a4\u30db\u30ed"}};
        private static final boolean[] pre_sharp_flat = new boolean[]{false, false, true};
        private int major_co5;

        public NoteSymbol(int n) {
            this.major_co5 = n;
        }

        public NoteSymbol(String string) {
            String string2 = string.trim();
            String[] stringArray = note_strings[0];
            if (string2.isEmpty() || (this.major_co5 = stringArray[5].indexOf(string2.charAt(0))) < 0) {
                throw new IllegalArgumentException("Unknown note name " + string2);
            }
            --this.major_co5;
            for (int i = 0; i < 5; ++i) {
                if (i == 2 || !string2.startsWith(stringArray[i], 1)) continue;
                this.major_co5 += (i - 2) * 7;
                return;
            }
        }

        protected NoteSymbol clone() {
            return new NoteSymbol(this.major_co5);
        }

        public boolean equals(NoteSymbol noteSymbol) {
            return this.major_co5 == noteSymbol.toCo5();
        }

        public int hashCode() {
            return this.major_co5;
        }

        public int toCo5() {
            return this.major_co5;
        }

        public int toCo5(boolean bl) {
            return bl ? this.major_co5 - 3 : this.major_co5;
        }

        public String toString() {
            return this.toStringIn(0, false);
        }

        public String toStringIn(int n) {
            return this.toStringIn(n, false);
        }

        public String toStringIn(int n, boolean bl) {
            int n2 = this.major_co5 + 15;
            if (bl) {
                n2 += 3;
            }
            if (n2 < 0 || n2 >= 35) {
                n2 = Music.mod12(n2);
                if (bl) {
                    n2 += n2 == 0 ? 24 : 12;
                } else if (n2 < 10) {
                    n2 += 12;
                }
            }
            int n3 = n2 / 7;
            int n4 = n2 - n3 * 7;
            String[] stringArray = note_strings[n];
            String string = stringArray[5].substring(n4, n4 + 1);
            String string2 = stringArray[n3];
            return pre_sharp_flat[n] ? string2 + string : string + string2;
        }

        public int toNoteNo() {
            return Music.mod12(Music.reverseCo5(this.major_co5));
        }
    }
}

