/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.Sequencer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

class SequencerTimeRangeModel
implements BoundedRangeModel {
    static final int INTERVAL_MS = 20;
    MidiDeviceManager device_manager;
    private Sequencer sequencer;
    Timer timer;
    private boolean value_is_adjusting = false;
    private EventListenerList listenerList = new EventListenerList();
    public StartStopAction start_stop_action = new StartStopAction();
    public Action move_backward_action = new AbstractAction(){
        {
            this.putValue("ShortDescription", "Move backward 1 measure - \uff11\u5c0f\u7bc0\u623b\u308b");
            this.putValue("SwingLargeIconKey", new ButtonIcon(16));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SequencerTimeRangeModel.this.moveMeasure(-1);
        }
    };
    public Action move_forward_action = new AbstractAction(){
        {
            this.putValue("ShortDescription", "Move forward 1 measure - \uff11\u5c0f\u7bc0\u9032\u3080");
            this.putValue("SwingLargeIconKey", new ButtonIcon(15));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SequencerTimeRangeModel.this.moveMeasure(1);
        }
    };
    public Action toggle_repeat_action = new AbstractAction(){
        {
            this.putValue("ShortDescription", "Repeat - \u7e70\u308a\u8fd4\u3057\u518d\u751f");
            this.putValue("SwingLargeIconKey", new ButtonIcon(11));
            this.putValue("SwingSelectedKey", false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    };
    private MidiSequenceModel seq_model = null;

    public SequencerTimeRangeModel(MidiDeviceManager midiDeviceManager) {
        this.device_manager = midiDeviceManager;
        this.sequencer = midiDeviceManager.getSequencer();
        this.timer = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!SequencerTimeRangeModel.this.value_is_adjusting) {
                    SequencerTimeRangeModel.this.fireStateChanged();
                }
            }
        });
        this.timer.setCoalesce(true);
        this.sequencer.addMetaEventListener(new MetaEventListener(){

            @Override
            public void meta(MetaMessage metaMessage) {
                if (metaMessage.getType() != 47) {
                    return;
                }
                SequencerTimeRangeModel.this.timer.stop();
                SequencerTimeRangeModel.this.start_stop_action.setRunning(false);
                SequencerTimeRangeModel.this.sequencer.setMicrosecondPosition(0L);
                if (((Boolean)SequencerTimeRangeModel.this.toggle_repeat_action.getValue("SwingSelectedKey")).booleanValue() || SequencerTimeRangeModel.this.device_manager.editor_dialog.loadNext(1)) {
                    SequencerTimeRangeModel.this.start();
                } else {
                    SequencerTimeRangeModel.this.fireStateChanged();
                }
            }
        });
    }

    @Override
    public int getExtent() {
        return 0;
    }

    @Override
    public int getMaximum() {
        return (int)(this.getMicrosecondLength() / 1000L);
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public int getValue() {
        return (int)(this.getMicrosecondPosition() / 1000L);
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.value_is_adjusting;
    }

    @Override
    public void setExtent(int n) {
    }

    @Override
    public void setMaximum(int n) {
    }

    @Override
    public void setMinimum(int n) {
    }

    @Override
    public void setRangeProperties(int n, int n2, int n3, int n4, boolean bl) {
        this.sequencer.setMicrosecondPosition(1000L * (long)n);
        this.value_is_adjusting = bl;
        this.fireStateChanged();
    }

    @Override
    public void setValue(int n) {
        this.sequencer.setMicrosecondPosition(1000L * (long)n);
        this.fireStateChanged();
    }

    @Override
    public void setValueIsAdjusting(boolean bl) {
        this.value_is_adjusting = bl;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(new ChangeEvent(this));
        }
    }

    long getMicrosecondLength() {
        long l = this.sequencer.getMicrosecondLength();
        return l < 0L ? 0x100000000L + l : l;
    }

    long getMicrosecondPosition() {
        long l = this.sequencer.getMicrosecondPosition();
        return l < 0L ? 0x100000000L + l : l;
    }

    public MidiSequenceModel getSequenceModel() {
        return this.seq_model;
    }

    public boolean setSequenceModel(MidiSequenceModel midiSequenceModel) {
        if (midiSequenceModel != null || this.sequencer.isOpen()) {
            try {
                this.sequencer.setSequence(midiSequenceModel == null ? null : midiSequenceModel.getSequence());
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
                return false;
            }
        }
        this.seq_model = midiSequenceModel;
        this.fireStateChanged();
        return true;
    }

    public void moveMeasure(int n) {
        if (n == 0 || this.seq_model == null) {
            return;
        }
        SequenceIndex sequenceIndex = this.seq_model.getSequenceIndex();
        long l = sequenceIndex.measureToTick(n + sequenceIndex.tickToMeasure(this.sequencer.getTickPosition()));
        if (l < 0L) {
            l = 0L;
        } else {
            long l2 = this.sequencer.getTickLength();
            if (l > l2) {
                l = l2 - 1L;
            }
        }
        this.sequencer.setTickPosition(l);
        this.fireStateChanged();
    }

    public boolean isStartable() {
        return this.sequencer.isOpen() && this.sequencer.getSequence() != null;
    }

    public void start() {
        if (!this.isStartable()) {
            this.start_stop_action.setRunning(false);
            return;
        }
        this.start_stop_action.setRunning(true);
        this.timer.start();
        if (this.device_manager.isRecordable()) {
            this.device_manager.resetMicrosecondPosition();
            System.gc();
            this.sequencer.startRecording();
        } else {
            System.gc();
            this.sequencer.start();
        }
        this.fireStateChanged();
    }

    public void stop() {
        if (this.sequencer.isOpen()) {
            this.sequencer.stop();
        }
        this.timer.stop();
        this.start_stop_action.setRunning(false);
        this.fireStateChanged();
    }

    class StartStopAction
    extends AbstractAction {
        Icon play_icon = new ButtonIcon(2);
        Icon pause_icon = new ButtonIcon(5);

        StartStopAction() {
            this.putValue("ShortDescription", "Start/Stop recording or playing - \u9332\u97f3\u307e\u305f\u306f\u518d\u751f\u306e\u958b\u59cb\uff0f\u505c\u6b62");
            this.putValue("SwingLargeIconKey", this.play_icon);
            this.putValue("SwingSelectedKey", false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SequencerTimeRangeModel.this.timer.isRunning()) {
                SequencerTimeRangeModel.this.stop();
            } else {
                SequencerTimeRangeModel.this.start();
            }
        }

        public void setRunning(boolean bl) {
            this.putValue("SwingLargeIconKey", bl ? this.pause_icon : this.play_icon);
            this.putValue("SwingSelectedKey", bl);
        }
    }
}

