/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class TimeSignatureSelecter
extends JPanel {
    SpinnerNumberModel upper_timesig_spinner_model = new SpinnerNumberModel(4, 1, 32, 1);
    JSpinner upper_timesig_spinner = new JSpinner(this.upper_timesig_spinner_model);
    JComboBox lower_timesig_combobox;
    TimeSignatureLabel timesig_value_label;
    private boolean editable;

    public TimeSignatureSelecter() {
        this.upper_timesig_spinner.setToolTipText("Time signature (upper digit) - \u62cd\u5b50\u306e\u5206\u5b50");
        this.lower_timesig_combobox = new JComboBox();
        this.lower_timesig_combobox.setToolTipText("Time signature (lower digit) - \u62cd\u5b50\u306e\u5206\u6bcd");
        for (int i = 0; i < 6; ++i) {
            this.lower_timesig_combobox.addItem("/" + (1 << i));
        }
        this.timesig_value_label = new TimeSignatureLabel();
        this.timesig_value_label.setToolTipText("Time signature - \u62cd\u5b50");
        this.lower_timesig_combobox.setSelectedIndex(2);
        this.add(this.upper_timesig_spinner);
        this.add(this.lower_timesig_combobox);
        this.add(this.timesig_value_label);
        this.setEditable(true);
    }

    public void clear() {
        this.upper_timesig_spinner_model.setValue(4);
        this.lower_timesig_combobox.setSelectedIndex(2);
    }

    public int getUpperValue() {
        return this.upper_timesig_spinner_model.getNumber().intValue();
    }

    public byte getUpperByte() {
        return this.upper_timesig_spinner_model.getNumber().byteValue();
    }

    public int getLowerValueIndex() {
        return this.lower_timesig_combobox.getSelectedIndex();
    }

    public byte getLowerByte() {
        return (byte)this.getLowerValueIndex();
    }

    public byte[] getByteArray() {
        byte[] byArray = new byte[]{this.getUpperByte(), this.getLowerByte(), (byte)(96 >> this.getLowerValueIndex()), 8};
        return byArray;
    }

    public void setValue(byte by, byte by2) {
        this.upper_timesig_spinner_model.setValue(by);
        this.lower_timesig_combobox.setSelectedIndex(by2);
        this.timesig_value_label.setTimeSignature(by, by2);
    }

    public void setValue(byte[] byArray) {
        this.setValue(byArray[0], byArray[1]);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        this.upper_timesig_spinner.setVisible(bl);
        this.lower_timesig_combobox.setVisible(bl);
        this.timesig_value_label.setVisible(!bl);
        if (!bl) {
            this.timesig_value_label.setTimeSignature(this.getUpperByte(), this.getLowerByte());
        }
    }
}

