/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.util.Vector;
import javax.sound.midi.MidiChannel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class TrackSpecPanel
extends JPanel
implements PianoKeyboardListener,
ActionListener,
ChangeListener {
    JComboBox track_selecter;
    JLabel track_type_label;
    JTextField name_text_field = new JTextField(20);
    MidiChannelComboSelecter ch_selecter;
    MidiProgramSelecter pg_selecter;
    MidiProgramFamilySelecter pg_family_selecter;
    PianoKeyboardPanel keyboard_panel;
    JPanel range_panel;
    JCheckBox random_melody_checkbox;
    JCheckBox bass_checkbox;
    JCheckBox random_lyric_checkbox;
    BeatPadPanel beat_pad_panel;
    private MidiChannel[] midi_channels;

    public TrackSpecPanel() {
        this.name_text_field.addActionListener(this);
        this.pg_selecter = new MidiProgramSelecter();
        this.pg_family_selecter = new MidiProgramFamilySelecter(this.pg_selecter);
        this.pg_selecter.setFamilySelecter(this.pg_family_selecter);
        this.keyboard_panel = new PianoKeyboardPanel();
        this.keyboard_panel.keyboard.octave_size_model.setValue(6);
        this.keyboard_panel.keyboard.setPreferredSize(new Dimension(400, 40));
        this.keyboard_panel.keyboard.setMaxSelectable(2);
        this.keyboard_panel.keyboard.addPianoKeyboardListener(this);
        this.beat_pad_panel = new BeatPadPanel(this);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Track select:"));
        this.track_selecter = new JComboBox();
        jPanel.add(this.track_selecter);
        this.add(jPanel);
        this.track_type_label = new JLabel();
        this.add(this.track_type_label);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Track name (Press [Enter] key to change):"));
        jPanel2.add(this.name_text_field);
        this.add(jPanel2);
        this.ch_selecter = new MidiChannelComboSelecter("MIDI Channel:");
        this.add(this.ch_selecter);
        this.add(new VelocitySelecter(this.keyboard_panel.keyboard.velocity_model));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.pg_family_selecter);
        jPanel3.add(this.pg_selecter);
        this.add(jPanel3);
        this.range_panel = new JPanel();
        this.range_panel.add(new JLabel("Range:"));
        this.range_panel.add(this.keyboard_panel);
        this.add(this.range_panel);
        this.bass_checkbox = new JCheckBox("Bass note");
        this.bass_checkbox.addChangeListener(this);
        this.add(this.bass_checkbox);
        this.random_melody_checkbox = new JCheckBox("Random melody");
        this.random_melody_checkbox.addChangeListener(this);
        this.add(this.random_melody_checkbox);
        this.random_lyric_checkbox = new JCheckBox("Random lyrics");
        this.random_lyric_checkbox.addChangeListener(this);
        this.add(this.random_lyric_checkbox);
        this.add(this.beat_pad_panel);
        this.track_selecter.addActionListener(this);
        this.ch_selecter.combo_box.addActionListener(this);
        this.keyboard_panel.keyboard.velocity_model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Music.AbstractNoteTrackSpec abstractNoteTrackSpec = TrackSpecPanel.this.getTrackSpec();
                abstractNoteTrackSpec.velocity = TrackSpecPanel.this.keyboard_panel.keyboard.velocity_model.getValue();
            }
        });
        this.pg_selecter.addActionListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Music.AbstractNoteTrackSpec abstractNoteTrackSpec;
        Object object = changeEvent.getSource();
        if (object == this.bass_checkbox) {
            Music.AbstractNoteTrackSpec abstractNoteTrackSpec2 = this.getTrackSpec();
            if (abstractNoteTrackSpec2 instanceof Music.MelodyTrackSpec) {
                Music.MelodyTrackSpec melodyTrackSpec = (Music.MelodyTrackSpec)abstractNoteTrackSpec2;
                melodyTrackSpec.is_bass = this.bass_checkbox.isSelected();
            }
        } else if (object == this.random_melody_checkbox) {
            Music.AbstractNoteTrackSpec abstractNoteTrackSpec3 = this.getTrackSpec();
            if (abstractNoteTrackSpec3 instanceof Music.MelodyTrackSpec) {
                Music.MelodyTrackSpec melodyTrackSpec = (Music.MelodyTrackSpec)abstractNoteTrackSpec3;
                melodyTrackSpec.random_melody = this.random_melody_checkbox.isSelected();
            }
        } else if (object == this.random_lyric_checkbox && (abstractNoteTrackSpec = this.getTrackSpec()) instanceof Music.MelodyTrackSpec) {
            Music.MelodyTrackSpec melodyTrackSpec = (Music.MelodyTrackSpec)abstractNoteTrackSpec;
            melodyTrackSpec.random_lyric = this.random_lyric_checkbox.isSelected();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.name_text_field) {
            this.getTrackSpec().name = this.name_text_field.getText();
        } else if (object == this.track_selecter) {
            Music.AbstractNoteTrackSpec abstractNoteTrackSpec = (Music.AbstractNoteTrackSpec)this.track_selecter.getSelectedItem();
            String string = "Track type: " + (abstractNoteTrackSpec instanceof Music.DrumTrackSpec ? "Percussion" : (abstractNoteTrackSpec instanceof Music.MelodyTrackSpec ? "Melody" : "(Unknown)"));
            this.track_type_label.setText(string);
            this.name_text_field.setText(abstractNoteTrackSpec.name);
            this.ch_selecter.setSelectedChannel(abstractNoteTrackSpec.midi_channel);
            this.keyboard_panel.keyboard.velocity_model.setValue(abstractNoteTrackSpec.velocity);
            this.pg_selecter.setProgram(abstractNoteTrackSpec.program_no);
            this.keyboard_panel.keyboard.clear();
            if (abstractNoteTrackSpec instanceof Music.DrumTrackSpec) {
                Music.DrumTrackSpec drumTrackSpec = (Music.DrumTrackSpec)abstractNoteTrackSpec;
                this.range_panel.setVisible(false);
                this.random_melody_checkbox.setVisible(false);
                this.random_lyric_checkbox.setVisible(false);
                this.bass_checkbox.setVisible(false);
            } else if (abstractNoteTrackSpec instanceof Music.MelodyTrackSpec) {
                Music.MelodyTrackSpec melodyTrackSpec = (Music.MelodyTrackSpec)abstractNoteTrackSpec;
                this.range_panel.setVisible(true);
                this.keyboard_panel.keyboard.setSelectedNote(melodyTrackSpec.range.min_note);
                this.keyboard_panel.keyboard.setSelectedNote(melodyTrackSpec.range.max_note);
                this.keyboard_panel.keyboard.autoScroll(melodyTrackSpec.range.min_note);
                this.random_melody_checkbox.setSelected(melodyTrackSpec.random_melody);
                this.random_lyric_checkbox.setSelected(melodyTrackSpec.random_lyric);
                this.bass_checkbox.setSelected(melodyTrackSpec.is_bass);
                this.random_melody_checkbox.setVisible(true);
                this.random_lyric_checkbox.setVisible(true);
                this.bass_checkbox.setVisible(true);
            }
            this.beat_pad_panel.setTrackSpec(abstractNoteTrackSpec);
        } else if (object == this.ch_selecter.combo_box) {
            this.getTrackSpec().midi_channel = this.ch_selecter.getSelectedChannel();
        } else if (object == this.pg_selecter) {
            this.getTrackSpec().program_no = this.pg_selecter.getProgram();
        }
    }

    @Override
    public void pianoKeyPressed(int n, InputEvent inputEvent) {
        this.noteOn(n);
        Music.AbstractNoteTrackSpec abstractNoteTrackSpec = this.getTrackSpec();
        if (abstractNoteTrackSpec instanceof Music.MelodyTrackSpec) {
            Music.MelodyTrackSpec melodyTrackSpec = (Music.MelodyTrackSpec)abstractNoteTrackSpec;
            melodyTrackSpec.range = new Music.Range(this.keyboard_panel.keyboard.getSelectedNotes());
        }
    }

    @Override
    public void pianoKeyReleased(int n, InputEvent inputEvent) {
        this.noteOff(n);
    }

    @Override
    public void octaveMoved(ChangeEvent changeEvent) {
    }

    @Override
    public void octaveResized(ChangeEvent changeEvent) {
    }

    public void noteOn(int n) {
        if (this.midi_channels != null) {
            this.midi_channels[this.ch_selecter.getSelectedChannel()].noteOn(n, this.keyboard_panel.keyboard.velocity_model.getValue());
        }
    }

    public void noteOff(int n) {
        if (this.midi_channels != null) {
            this.midi_channels[this.ch_selecter.getSelectedChannel()].noteOff(n, this.keyboard_panel.keyboard.velocity_model.getValue());
        }
    }

    public void setChannels(MidiChannel[] midiChannelArray) {
        this.midi_channels = midiChannelArray;
    }

    public Music.AbstractNoteTrackSpec getTrackSpec() {
        Object object = this.track_selecter.getSelectedItem();
        Music.AbstractNoteTrackSpec abstractNoteTrackSpec = (Music.AbstractNoteTrackSpec)object;
        abstractNoteTrackSpec.name = this.name_text_field.getText();
        return abstractNoteTrackSpec;
    }

    public Vector<Music.AbstractNoteTrackSpec> getTrackSpecs() {
        Vector<Music.AbstractNoteTrackSpec> vector = new Vector<Music.AbstractNoteTrackSpec>();
        int n = 0;
        int n2 = this.track_selecter.getItemCount();
        while (n < n2) {
            vector.add((Music.AbstractNoteTrackSpec)this.track_selecter.getItemAt(n++));
        }
        return vector;
    }

    public void addTrackSpec(Music.AbstractNoteTrackSpec abstractNoteTrackSpec) {
        this.track_selecter.addItem(abstractNoteTrackSpec);
    }
}

