
//
// AnoGakkiLayeredPane - Innocenceůyv̕\NX
//

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;

class AnoGakkiLayeredPane extends JLayeredPane {
  AnoGakkiPane ano_gakki_pane = new AnoGakkiPane();
  public AnoGakkiLayeredPane() {
    add(ano_gakki_pane, JLayeredPane.PALETTE_LAYER);
    addComponentListener(
      new ComponentAdapter() {
        private void adjustSize() {
          ano_gakki_pane.setBounds(getBounds());
        }
        public void componentResized(ComponentEvent e) {
          adjustSize();
        }
        public void componentShown(ComponentEvent e) {
          adjustSize();
        }
      }
    );
    setLayout(new BorderLayout());
    setOpaque(true);
  }
  public void start(Component source, Point clicked_point) {
    ano_gakki_pane.start(source,clicked_point);
  }
  public void start(Component source, Rectangle rect) {
    Point p = rect.getLocation();
    p.translate( rect.width/2, rect.height/2 );
    start(source,p);
  }
  public void start(Component source, Component clicked_component) {
    start(source,clicked_component.getBounds());
  }
}

class AnoGakkiPane extends JComponent {

  // PXebv̎ԊԊui~bj
  static final int INTERVAL_MS = 15;

  // \I܂ł̃Xebv
  static final int INITIAL_COUNT = 20;

  // pxւ́iΒĺjő
  static final double MAX_OMEGA = 0.005;

  // }`̎
  static final int CIRCLE = 0;	 // 
  static final int LINE = 1;	 // |
  static final int SQUARE = 2;	 // 
  static final int TRIANGLE = 3; // 
  static final int N_SHAPES = 4; // vS

  // FiRGBAAÁusxv\At@lj
  static final Color color = new Color(0,255,255,192);

  // Xg[Nȋwj
  static final Stroke stroke = new BasicStroke((float)5);

  // ő\
  static final int MAX_VISIBLE_OBJECTS = 30;

  // ܕ`悷ׂ}`oĂ߂̃L[
  LinkedList<QueueEntry> queue = new LinkedList<QueueEntry>();
  class QueueEntry {
    // Ԏ
    int countdown = INITIAL_COUNT;
    int t_ms = 0; // X^[ǧoߎԁi~bj
    // }`
    int shape = CIRCLE;	// }`̎
    Point clicked_point;// NbNꂽꏊiSj
    int r = 0;		// ݂̔a
    // ]p[^
    double omega = 0; // ]xivj
    AffineTransform affine_transform = null; // ݂̉]piAtBϊj
  }

  // Aj[Vp^C}[
  javax.swing.Timer timer =
    new javax.swing.Timer(
      INTERVAL_MS,
      new ActionListener() {
        public void actionPerformed(ActionEvent event) {
          int dequeue_count = 0;
          try {
            for( QueueEntry entry : queue ) {
              // Ԑ؂`FbN
              if( entry.countdown-- <= 0 ) {
                dequeue_count++; continue;
              }
              //  t i߂
              entry.t_ms += INTERVAL_MS;
              // a r = vt
              entry.r = entry.t_ms / 2;
              // ]
              if( entry.shape == SQUARE || entry.shape == TRIANGLE ) {
                // px =t ŋ߂ƁAړ l=r 
                // t ̂Q̃I[_[ŐLт邽߁AĂ悤ɌĂ܂B
                // ̑xɌ邽߂ t 𕽕ɂĊpxvZB
                entry.affine_transform.rotate(
                  entry.omega * Math.sqrt((double)entry.t_ms),
                  entry.clicked_point.x,
                  entry.clicked_point.y
                );
              }
            }
            while( dequeue_count-- > 0 ) queue.poll();
            if( queue.size() == 0 ) timer.stop();
            repaint();
          }
          catch( ConcurrentModificationException cme ) {
            // `FbNɐVf[^L[ɓꍇɏoO𖳎
            return;
          }
        }
      }
    );

  public AnoGakkiPane() {
    super();
    setOpaque(false);
    timer.setCoalesce(true);
    timer.setRepeats(true);
  }
  public void paint(Graphics g) {
    if( queue.size() == 0 ) return;
    Graphics2D g2 = (Graphics2D)g;
    Dimension d = getSize();
    g2.setStroke(stroke);
    g2.setColor(color);
    try {
      for( QueueEntry entry : queue ) {
        int r = entry.r;
        int x = entry.clicked_point.x;
        int y = entry.clicked_point.y;
        switch( entry.shape ) {
          case CIRCLE:
            g2.drawOval( x-r, y-r, 2*r, 2*r );
            break;
          case LINE:
            g2.transform(entry.affine_transform);
            g2.drawLine( -d.width*2, y-r, d.width*2, y-r );
            g2.drawLine( -d.width*2, y+r, d.width*2, y+r );
            break;
          case SQUARE:
            g2.transform(entry.affine_transform);
            g2.drawRect( x-r, y-r, 2*r, 2*r );
            break;
          case TRIANGLE:
            g2.transform(entry.affine_transform);
            g2.drawLine( x-r, y, x+r, y-r );
            g2.drawLine( x-r, y, x+r, y+r );
            g2.drawLine( x+r, y-r, x+r, y+r );
            break;
        }
      }
    }
    catch( ConcurrentModificationException cme ) {
      // `FbNɐVf[^L[ɓꍇɏoO𖳎
      return;
    }
  }
  private long prev_started_at = System.nanoTime();
  public void start(Component source, Point clicked_point) {
    long started_at = System.nanoTime();
    if( started_at - prev_started_at < (INTERVAL_MS * 1000)*50 ) {
      // pɂꍇ͖
      return;
    }
    QueueEntry entry = new QueueEntry();
    // S߂
    entry.clicked_point = SwingUtilities.convertPoint(
      source, clicked_point, this
    );
    // `߂
    entry.shape = (int)(Math.random() * N_SHAPES);
    //
    // ]@߂
    //  ȉꍇ͉]ĂӖȂ̂ŃXLbvj
    if( entry.shape != CIRCLE ) {
      //
      // ]p̏l
      entry.affine_transform =
        AffineTransform.getRotateInstance(
          2 * Math.PI * Math.random(),
          entry.clicked_point.x,
          entry.clicked_point.y
        );
      // ]x
      entry.omega = MAX_OMEGA * (1.0 - 2.0 * Math.random());
    }
    // X^[gI
    queue.offer(entry); timer.start();
    prev_started_at = started_at;
  }
}

