/*
 * MIDI Chord Helper - Circle-of-fifth oriented chord pad
 *
 *	http://www.yk.rim.or.jp/~kamide/music/chordhelper/
 *
 *	Copyright (C) 2004-2009 悵 - Akiyoshi Kamide
 */
import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.dnd.*;
import java.awt.datatransfer.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import javax.sound.midi.*;

public class ChordHelperApplet extends JApplet
  implements MetaEventListener
{
  /////////////////////////////////////////////////////////////////////
  //
  // JavaScript Ȃǂ̌ĂяoC^[tF[X
  //
  /////////////////////////////////////////////////////////////////////
  //
  // ĈɖۑɂȂĂ MIDI t@C邩ǂׂ
  //
  public boolean isModified() {
    return editor_dialog.isModified();
  }
  // _ɍȂvCXg֒ǉ
  //
  public int addRandomSongToPlaylist(int measure_length) {
    editor_dialog.new_seq_dialog.setRandomChordProgression(measure_length);
    return editor_dialog.addSequence();
  }
  // URL Ŏꂽ MIDI t@CvCXg֒ǉ
  //
  public int addToPlaylist(String midi_file_url) {
    return editor_dialog.addSequenceFromURL(midi_file_url);
  }
  // Base64 GR[hꂽ MIDI t@CvCXg֒ǉ
  //
  public int addToPlaylistBase64(String base64_encoded_text) {
    return addToPlaylistBase64(base64_encoded_text, null);
  }
  public int addToPlaylistBase64(String base64_encoded_text, String filename) {
    return editor_dialog.addSequenceFromBase64Text(
      base64_encoded_text, filename
    );
  }
  // MIDI t@CĐ
  //
  public void play() { editor_dialog.loadAndPlay(); }
  public void play(int index) { editor_dialog.loadAndPlay(index); }
  //
  // Đ܂͘^̂Ƃ True Ԃ
  //
  public boolean isRunning() { return device_manager.getSequencer().isRunning(); }
  public boolean isPlaying() { return isRunning(); }
  //
  // [hς MIDI t@C Base64 GR[hʂԂ
  //
  public String getMidiDataBase64() {
    return editor_dialog.getMIDIdataBase64();
  }
  // [hς MIDI t@C̃t@CԂ
  //
  public String getMidiFilename() {
    MidiSequenceModel seq_model = device_manager.time_range_model.getSequenceModel();
    if( seq_model == null ) return null;
    String fn = seq_model.getFilename();
    return fn == null ? "" : fn ;
  }
  // IN^[uʒu̕ύX
  public void setOctavePosition(int position) {
    keyboard_panel.keyboard_center_panel.keyboard.octave_range_model.setValue(position);
  }
  // MIDI`l̕ύX
  public void setChannel(int ch) {
    keyboard_panel.keyboard_center_panel.keyboard.midi_ch_combobox_model.setSelectedChannel(ch);
  }
  public int getChannel() {
    return keyboard_panel.keyboard_center_panel.keyboard.midi_ch_combobox_model.getSelectedChannel();
  }
  // FύXivO`FWj
  public void programChange(int program) {
    keyboard_panel.keyboard_center_panel.keyboard.getSelectedChannel().programChange(program);
  }
  public void setProgram(int program) { programChange(program); }
  //
  // ]񃂁[h̕ύX
  public void setAutoInversion(boolean is_auto) {
    inversion_omission_button.setAutoInversion(is_auto);
  }
  // ȗw̕ύX
  public void setOmissionNoteIndex(int index) {
    inversion_omission_button.setOmissionNoteIndex(index);
  }
  // R[h_CAO̕\E\؂ւi{^̌Ăяołgj
  public void setChordDiagramVisible(boolean is_visible) {
    keyboard_split_pane.resetToPreferredSizes();
    if( ! is_visible ) 
      keyboard_split_pane.setDividerLocation((double)1.0);
  }
  // R[h_CAOM^[[hɂ
  public void setChordDiagramForGuitar() {
    chord_diagram.setGuitar(true);
  }
  // _[N[hؑ
  public void setDarkMode(boolean is_dark) {
    dark_mode_toggle_button.setSelected(is_dark);
  }
  //////////////////////////////////////////////////////////////////////
  //
  public static class VersionInfo {
    public static final String	NAME = "MIDI Chord Helper";
    public static final String	VERSION = "Ver.20091003.1";
    public static final String	COPYRIGHT = "Copyright (C) 2004-2009";
    public static final String	AUTHER = "悵 - Akiyoshi Kamide";
    public static final String	URL = "http://www.yk.rim.or.jp/~kamide/music/chordhelper/";
    public static String getInfo() {
      return NAME + " " + VERSION + " " + COPYRIGHT + " " + AUTHER + " " + URL;
    }
  }
  //////////////////////////////////////////////////////////////////////
  //
  public String getAppletInfo() { return VersionInfo.getInfo(); }
  class AboutMessagePane extends JEditorPane {
    URI uri = null;
    public AboutMessagePane() { this(true); }
    public AboutMessagePane(boolean link_enabled) {
      super( "text/html", "" );
      String link_string, tooltip = null;
      if( link_enabled && Desktop.isDesktopSupported() ) {
        tooltip = "Click this URL to open with your web browser - URLNbNWebuEUŊJ";
        link_string =
          "<a href=\"" + VersionInfo.URL + "\" title=\"" +
          tooltip + "\">" + VersionInfo.URL + "</a>" ;
      }
      else {
        link_enabled = false; link_string = VersionInfo.URL;
      }
      setText(
        "<html><center><font size=\"+1\">" + VersionInfo.NAME + "</font>  " +
        VersionInfo.VERSION + "<br/><br/>" +
        VersionInfo.COPYRIGHT + " " + VersionInfo.AUTHER + "<br/>" +
        link_string + "</center></html>"
      );
      setToolTipText(tooltip);
      setOpaque(false);
      putClientProperty(JEditorPane.HONOR_DISPLAY_PROPERTIES, Boolean.TRUE);
      setEditable(false);
      //
      // bZ[W <a href=""> ` </a> ɂ郊N
      // ۂɋ@\iuEUŕ\悤ɂj߂̐ݒ
      //
      if( ! link_enabled ) return;
      try {
        uri = new URI(VersionInfo.URL);
      }catch( URISyntaxException use ) {
        use.printStackTrace();
        return;
      }
      addHyperlinkListener(new HyperlinkListener() {
        public void hyperlinkUpdate(HyperlinkEvent e) {
          if(e.getEventType()==HyperlinkEvent.EventType.ACTIVATED) {
            try{
              Desktop.getDesktop().browse(uri);
            }catch(IOException ioe) {
              ioe.printStackTrace();
            }
          }
        }
      });
    }
    // o[W\
    public void showMessage() {
      JOptionPane.showMessageDialog(
        null, this, "Version info",
        JOptionPane.INFORMATION_MESSAGE, image_icon
      );
    }
  }
  // IĂ悢mF
  public boolean isConfirmedToExit() {
    return ! isModified() || JOptionPane.showConfirmDialog(
      this,
      "MIDI file not saved, exit anyway ?\nۑĂȂMIDIt@C܂AIĂ낵łH",
      VersionInfo.NAME,
      JOptionPane.YES_NO_OPTION,
      JOptionPane.WARNING_MESSAGE
    ) == JOptionPane.YES_OPTION ;
  }
  // AvP[ṼACRC[W
  public ImageIcon image_icon = new ImageIcon(
    this.getClass().getResource("images/midichordhelper.png")
  );
  // {^̗]l߂Ƃ setMargin() ̈ɂw肷
  Insets	zero_insets = new Insets(0,0,0,0);
  //
  JPanel
	keyboard_sequencer_panel,
	chord_guide,
	sequencer_panel,
	sequencer_upper_panel,
        sequencer_lower_panel,
        midi_io_panel;
  Color
	root_pane_default_bgcolor,
	lyric_display_default_bgcolor;
  Border
	lyric_display_default_border,
	dark_mode_toggle_border;
  AboutMessagePane	about_message_pane = new AboutMessagePane();
  //
  JSplitPane		main_split_pane, keyboard_split_pane;
  ChordTextField	lyric_display;
  MidiKeyboardPanel	keyboard_panel;
  ChordMatrix		chord_matrix;
  ChordButtonLabel	enter_button_label;
  InversionAndOmissionLabel	inversion_omission_button;
  JToggleButton			dark_mode_toggle_button;
  MidiDeviceManager	device_manager;
  MidiDeviceDialog	midi_connection_dialog;
  MidiEditor		editor_dialog;
  ChordDiagram		chord_diagram;
  //
  // Tempo, Time signature, Key signature
  //
  TempoSelecter		tempo_selecter = new TempoSelecter();
  TimeSignatureSelecter	timesig_selecter = new TimeSignatureSelecter();
  KeySignatureLabel	keysig_label = new KeySignatureLabel();
  JLabel		song_title_label = new JLabel();
  //
  // ̊y
  AnoGakkiLayeredPane ano_gakki_layered_pane;
  JToggleButton ano_gakki_toggle_button;
  //
  //////////////////////////////////////////////////////////////////////////////////
  //
  // Event from applet
  //
  //////////////////////////////////////////////////////////////////////////////////
  //
  public void init() {
    //
    //////////////////////////////////////////////////////////////////////////////////
    //
    //@AvbgJnîPj
    //
    //////////////////////////////////////////////////////////////////////////////////
    //
    root_pane_default_bgcolor = getContentPane().getBackground();
    //
    // About
    JButton about_button = new JButton("Version info");
    about_button.setToolTipText( VersionInfo.NAME + " " + VersionInfo.VERSION );
    about_button.addActionListener( new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        about_message_pane.showMessage();
      }
    });
    //
    // Chord matrix
    //
    chord_matrix = new ChordMatrix();
    chord_matrix.addChordMatrixListener(new ChordMatrixListener(){
      public void keySignatureChanged() {
        Music.Key capo_key = chord_matrix.getKeySignatureCapo();
        keyboard_panel.key_selecter.setKey(capo_key);
        keyboard_panel.keyboard_center_panel.keyboard.setKeySignature(capo_key);
      }
      public void chordChanged() { chordOn(); }
    });
    enter_button_label = new ChordButtonLabel("Enter",chord_matrix);
    enter_button_label.addMouseListener(new MouseAdapter() {
      public void mousePressed(MouseEvent e) {
        if( (e.getModifiersEx() & e.BUTTON3_DOWN_MASK) != 0 ) // RightClicked
          chord_matrix.setSelectedChord( (Music.Chord)null );
        else
          chord_matrix.setSelectedChord( lyric_display.getText() );
      }
    });
    chord_matrix.capo_selecter.checkbox.addItemListener(
      new ItemListener() {
        public void itemStateChanged(ItemEvent e) {
          chordOn();
          keyboard_panel.keyboard_center_panel.keyboard.chord_display.setNote(-1);
          chord_diagram.clear();
        }
      }
    );
    chord_matrix.capo_selecter.value_selecter.addActionListener(
      new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          chordOn();
          keyboard_panel.keyboard_center_panel.keyboard.chord_display.setNote(-1);
          chord_diagram.clear();
        }
      }
    );
    // Piano keyboard
    //
    keyboard_panel = new MidiKeyboardPanel(chord_matrix);
    keyboard_panel.keyboard_center_panel.keyboard.addPianoKeyboardListener(
      new PianoKeyboardAdapter() {
        public void pianoKeyPressed(int n, InputEvent e) {
          chord_diagram.clear();
        }
      }
    );
    keyboard_panel.key_selecter.keysig_combobox.addActionListener(
      new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          Music.Key key = keyboard_panel.key_selecter.getKey();
          key.transpose( - chord_matrix.capo_selecter.getCapo() );
          chord_matrix.setKeySignature(key);
        }
      }
    );
    keyboard_panel.keyboard_center_panel.keyboard.setPreferredSize(
      new Dimension( 571, 80 )
    );
    // MIDI connection and MIDI editor
    //
    Vector<VirtualMidiDevice> vmds = new Vector<VirtualMidiDevice>();
    vmds.add(keyboard_panel.keyboard_center_panel.keyboard.midi_device);
    device_manager = new MidiDeviceManager(vmds);
    editor_dialog = new MidiEditor(device_manager);
    editor_dialog.setIconImage(image_icon.getImage());
    JButton edit_button = new JButton(
      "Edit/Playlist/Speed", new ButtonIcon(ButtonIcon.EDIT_ICON)
    );
    edit_button.setMargin(zero_insets);
    edit_button.addActionListener(
      new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          editor_dialog.setVisible(true);
        }
      }
    );
    DropTarget drop_target = new DropTarget(
      this, DnDConstants.ACTION_COPY_OR_MOVE, editor_dialog, true
    );
    device_manager.setMidiEditor(editor_dialog);
    keyboard_panel.event_dialog = editor_dialog.event_dialog;
    //
    midi_connection_dialog = new MidiDeviceDialog(device_manager);
    midi_connection_dialog.setIconImage(image_icon.getImage());
    JButton midi_connection_button = new JButton(
      "MIDI device connection",
      new ButtonIcon( ButtonIcon.MIDI_CONNECTOR_ICON )
    );
    midi_connection_button.addActionListener(new ActionListener() {
      public void actionPerformed( ActionEvent event ) {
        midi_connection_dialog.setVisible(true);
      }
    });
    //
    // Displays
    //
    lyric_display = new ChordTextField();
    lyric_display.addActionListener( new ActionListener() {
      public void actionPerformed(ActionEvent event) {
        chord_matrix.setSelectedChord(
          event.getActionCommand().trim().split("[ \t\r\n]")[0]
        );
      }
    });
    lyric_display_default_border = lyric_display.getBorder();
    lyric_display_default_bgcolor = lyric_display.getBackground();
    //
    // Dark mode
    //
    dark_mode_toggle_button = new JToggleButton(
      new ButtonIcon(ButtonIcon.DARK_MODE_ICON)
    );
    dark_mode_toggle_button.setMargin(zero_insets);
    dark_mode_toggle_button.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        innerSetDarkMode(dark_mode_toggle_button.isSelected());
      }
    });
    dark_mode_toggle_button.setToolTipText("Light / Dark - _^");
    dark_mode_toggle_border = dark_mode_toggle_button.getBorder();
    dark_mode_toggle_button.setBorder( null );
    //
    // Inversion/Omissioni]Eȗj
    //
    inversion_omission_button = new InversionAndOmissionLabel();
    //
    // ̊y ؂ւ{^
    //
    ano_gakki_toggle_button = new JToggleButton(
      new ButtonIcon(ButtonIcon.ANO_GAKKI_ICON)
    );
    ano_gakki_toggle_button.setOpaque(false);
    ano_gakki_toggle_button.setMargin(zero_insets);
    ano_gakki_toggle_button.setBorder( null );
    ano_gakki_toggle_button.setToolTipText("̊y");
    ano_gakki_toggle_button.addItemListener(
      new ItemListener() {
        public void itemStateChanged(ItemEvent e) {
          keyboard_panel.keyboard_center_panel.keyboard.ano_gakki_layered_pane
            = ano_gakki_toggle_button.isSelected() ? ano_gakki_layered_pane : null ;
        }
      }
    );
    //
    // Chord diagram
    //
    chord_diagram = new ChordDiagram( this );
    //
    // MIDI parts
    //
    tempo_selecter.setEditable(false);
    timesig_selecter.setEditable(false);
    keysig_label.addMouseListener(new MouseAdapter() {
      public void mousePressed(MouseEvent e) {
        chord_matrix.setKeySignature( keysig_label.getKey() );
      }
    });
    device_manager.getSequencer().addMetaEventListener(this);
    device_manager.time_range_model.addChangeListener(
      new ChangeListener() {
        public void stateChanged(ChangeEvent e) {
          MidiSequenceModel seq_model = device_manager.time_range_model.getSequenceModel();
          SequenceListModel seq_list_model = editor_dialog.seq_list_model;
          int i = seq_list_model.getLoadedIndex();
          song_title_label.setText(
            "<html>"+(
              i < 0 ? "[No MIDI file loaded]" :
              "MIDI file " + i + ": " + (
                seq_model == null ||
                seq_model.toString() == null ||
                seq_model.toString().isEmpty() ?
                "[Untitled]" :
                "<font color=maroon>"+seq_model+"</font>"
              )
            )+"</html>"
          );
          chord_matrix.setPlaying(
            device_manager.time_range_model.timer.isRunning()
          );
          long current_tick_position =
            device_manager.getSequencer().getTickPosition();
          SequenceIndex seq_index = null;
          if( seq_model != null ) {
            seq_index = seq_model.getSequenceIndex();
            seq_index.tickToMeasure( current_tick_position );
            chord_matrix.setBeat(
              (byte)(seq_index.last_beat), seq_index.timesig_upper
            );
            if(
              device_manager.time_range_model.getValueIsAdjusting()
              || (
                ! device_manager.getSequencer().isRunning()
                &&
                ! device_manager.getSequencer().isRecording()
              )
            ) {
              MetaMessage msg = seq_index.lastTimeSignatureAt( current_tick_position );
              if( msg == null ) timesig_selecter.clear(); else meta(msg);
              msg = seq_index.lastTempoAt( current_tick_position );
              if( msg == null ) tempo_selecter.clear(); else meta(msg);
              msg = seq_index.lastKeySignatureAt( current_tick_position );
              if( msg == null ) keysig_label.clear(); else meta(msg);
            }
          }
        }
      }
    );
    device_manager.time_range_model.fireStateChanged();
    //
    // Construct tree of panels
    //
    chord_guide = new JPanel();
    chord_guide.setLayout(
      new BoxLayout( chord_guide, BoxLayout.X_AXIS )
    );
    chord_guide.add( Box.createHorizontalStrut(2) );
    chord_guide.add( chord_matrix.chord_guide );
    chord_guide.add( Box.createHorizontalStrut(2) );
    chord_guide.add( lyric_display );
    chord_guide.add( Box.createHorizontalStrut(2) );
    chord_guide.add( enter_button_label );
    chord_guide.add( Box.createHorizontalStrut(5) );
    chord_guide.add( chord_matrix.chord_display );
    chord_guide.add( Box.createHorizontalStrut(5) );
    chord_guide.add( dark_mode_toggle_button );
    chord_guide.add( Box.createHorizontalStrut(5) );
    chord_guide.add( ano_gakki_toggle_button );
    chord_guide.add( Box.createHorizontalStrut(5) );
    chord_guide.add( inversion_omission_button );
    chord_guide.add( Box.createHorizontalStrut(5) );
    chord_guide.add( chord_matrix.capo_selecter );
    chord_guide.add( Box.createHorizontalStrut(2) );
    //
    sequencer_upper_panel = new JPanel();
    sequencer_upper_panel.setLayout(
      new BoxLayout( sequencer_upper_panel, BoxLayout.X_AXIS )
    );
    sequencer_upper_panel.add( Box.createHorizontalStrut(12) );
    sequencer_upper_panel.add( keysig_label );
    sequencer_upper_panel.add( Box.createHorizontalStrut(12) );
    sequencer_upper_panel.add( timesig_selecter );
    sequencer_upper_panel.add( Box.createHorizontalStrut(12) );
    sequencer_upper_panel.add( tempo_selecter );
    sequencer_upper_panel.add( Box.createHorizontalStrut(12) );
    sequencer_upper_panel.add(
      new MeasureIndicator(device_manager.time_range_model)
    );
    sequencer_upper_panel.add( Box.createHorizontalStrut(12) );
    sequencer_upper_panel.add( song_title_label );
    sequencer_upper_panel.add( Box.createHorizontalStrut(12) );
    sequencer_upper_panel.add( edit_button );
    //
    JButton top_button, bottom_button, backward_button, forward_button;
    JToggleButton repeat_button;
    sequencer_lower_panel = new JPanel();
    sequencer_lower_panel.setLayout(
      new BoxLayout( sequencer_lower_panel, BoxLayout.X_AXIS )
    );
    sequencer_lower_panel.add( Box.createHorizontalStrut(10) );
    sequencer_lower_panel.add(
      new JSlider(device_manager.time_range_model)
    );
    sequencer_lower_panel.add(
      new TimeIndicator(device_manager.time_range_model)
    );
    sequencer_lower_panel.add( Box.createHorizontalStrut(5) );
    sequencer_lower_panel.add(
      top_button = new JButton(
        editor_dialog.move_to_top_action
      )
    );
    sequencer_lower_panel.add(
      backward_button = new JButton(
        device_manager.time_range_model.move_backward_action
      )
    );
    sequencer_lower_panel.add(
      new JToggleButton(
        device_manager.time_range_model.start_stop_action
      )
    );
    sequencer_lower_panel.add(
      forward_button = new JButton(
        device_manager.time_range_model.move_forward_action
      )
    );
    sequencer_lower_panel.add(
      bottom_button = new JButton(
        editor_dialog.move_to_bottom_action
      )
    );
    sequencer_lower_panel.add(
      repeat_button = new JToggleButton(
        device_manager.time_range_model.toggle_repeat_action
      )
    );
    sequencer_lower_panel.add( Box.createHorizontalStrut(10) );
    top_button.setMargin(zero_insets);
    bottom_button.setMargin(zero_insets);
    backward_button.setMargin(zero_insets);
    forward_button.setMargin(zero_insets);
    repeat_button.setMargin(zero_insets);
    //
    midi_io_panel = new JPanel();
    midi_io_panel.add( midi_connection_button );
    midi_io_panel.add( about_button );
    //
    sequencer_panel = new JPanel();
    sequencer_panel.setLayout(
      new BoxLayout( sequencer_panel, BoxLayout.Y_AXIS )
    );
    sequencer_panel.add( sequencer_upper_panel );
    sequencer_panel.add( sequencer_lower_panel );
    sequencer_panel.add( midi_io_panel );
    //
    keyboard_split_pane = new JSplitPane(
      JSplitPane.HORIZONTAL_SPLIT,
      keyboard_panel, chord_diagram
    );
    keyboard_split_pane.setOneTouchExpandable(true);
    keyboard_split_pane.setResizeWeight(1.0);
    keyboard_split_pane.setAlignmentX((float)0.5);
    //
    keyboard_sequencer_panel = new JPanel();
    keyboard_sequencer_panel.setLayout(
      new BoxLayout( keyboard_sequencer_panel, BoxLayout.Y_AXIS )
    );
    keyboard_sequencer_panel.add(chord_guide);
    keyboard_sequencer_panel.add(Box.createVerticalStrut(5));
    keyboard_sequencer_panel.add(keyboard_split_pane);
    keyboard_sequencer_panel.add(Box.createVerticalStrut(5));
    keyboard_sequencer_panel.add(sequencer_panel);
    //
    main_split_pane = new JSplitPane(
      JSplitPane.VERTICAL_SPLIT,
      chord_matrix, keyboard_sequencer_panel
    );
    main_split_pane.setResizeWeight(0.5);
    main_split_pane.setAlignmentX((float)0.5);
    main_split_pane.setDividerSize(5);
    //
    ano_gakki_layered_pane = new AnoGakkiLayeredPane();
    ano_gakki_layered_pane.add(main_split_pane);
    setContentPane(ano_gakki_layered_pane);
    setPreferredSize( new Dimension(750,470) );
  }
  /////////////////////////////////////////
  //
  //@AvbgJnîQj
  //
  public void start() {
    //
    // R[h{^Őݒ肳Ă錻݂̒
    // sAmL[{[hɓ`
    chord_matrix.fireKeySignatureChanged();
    //
    // Avbg̃p[^MIDIt@CURLw肳Ă
    // Đ
    String midi_url = getParameter("midi_file");
    System.gc();
    if( midi_url != null ) {
      addToPlaylist(midi_url);
      play();
    }
  }
  // AvbgI
  public void stop() {
    device_manager.time_range_model.stop(); // MIDIĐI
    System.gc();
  }
  /////////////////////////////////////////
  //
  // MetaEventListener
  //
  public void meta(MetaMessage msg) {
    int msgtype = msg.getType();
    switch( msgtype ) {

    case 0x01: // TextiCӂ̃eLXgFRgȂǁj
    case 0x02: // Copyrighti쌠\j
    case 0x05: // Lyricsi̎j
    case 0x06: // Marker
    case 0x03: // Sequence Name / Track NameiȖ܂̓gbNj
      lyric_display.addLyric(msg.getData());
      break;

    case 0x51: // Tempo (3 bytes) - e|
      tempo_selecter.setTempo( msg.getData() );
      break;
    case 0x58: // Time signature (4 bytes) - q
      timesig_selecter.setValue( msg.getData() );
      break;
    case 0x59: // Key signature (2 bytes) : 
      keysig_label.setKeySignature( new Music.Key( msg.getData() ) );
      chord_matrix.setKeySignature( new Music.Key( msg.getData() ) );
      break;

    }
  }
  //
  ///////////////////////////////////////////////////////////////
  //
  // Methods
  //
  ///////////////////////////////////////////////////////////////
  private void innerSetDarkMode(boolean is_dark) {
    Color col = is_dark ? Color.black : null;
    Color fgcol = is_dark ? Color.pink : null;
    getContentPane().setBackground(
      is_dark ? Color.black : root_pane_default_bgcolor
    );
    main_split_pane.setBackground( col );
    keyboard_split_pane.setBackground( col );
    enter_button_label.setDarkMode( is_dark );
    chord_guide.setBackground( col );
    lyric_display.setBorder( is_dark ? null : lyric_display_default_border );
    lyric_display.setBackground( is_dark ?
      chord_matrix.dark_mode_colorset.backgrounds[2] : lyric_display_default_bgcolor
    );
    lyric_display.setForeground( is_dark ? Color.white : null );
    inversion_omission_button.setBackground( col );
    ano_gakki_toggle_button.setBackground( col );
    keyboard_sequencer_panel.setBackground( col );
    chord_diagram.setBackground( col );
    chord_diagram.title_label.setDarkMode( is_dark );
    chord_matrix.setDarkMode( is_dark );
    keyboard_panel.setDarkMode( is_dark );
  }
  /////////////////////////////////////////////////////////////////
  //
  // iaj
  //
  // F̊֐𒼐ڌĂԂƃAyWIȂ̂ŁA
  // chord_matrix.setSelectedChord() gƂ𐄏
  //
  int[] chord_on_notes = null;
  public void chordOn() {
    Music.Chord play_chord = chord_matrix.getSelectedChord();
    if(
      chord_on_notes != null &&
      chord_matrix.getNoteIndex() < 0 &&
      (! chord_matrix.isDragged() || play_chord == null)
    ) {
      // R[hĂԂŁAVȃR[h炻ƂA
      // 炳ȂƂMꍇ́AĂ鉹~߂B
      //
      for( int n : chord_on_notes )
        keyboard_panel.keyboard_center_panel.keyboard.noteOff(n);
      chord_on_notes = null;
    }
    if( play_chord == null ) {
      // 炳Ȃ̂ŁA̎\ɒʒmďI
      if( lyric_display != null )
        lyric_display.current_chord = null;
      return;
    }
    // ̊yۂ\
    if( keyboard_panel.keyboard_center_panel.keyboard.ano_gakki_layered_pane != null ) {
      JComponent btn = chord_matrix.getSelectedButton();
      if( btn != null )
        ano_gakki_layered_pane.start(chord_matrix,btn);
    }
    // R[h{^̃R[hAJ|tL[IWiL[֕ϊ
    Music.Key original_key = chord_matrix.getKeySignatureCapo();
    Music.Chord original_chord = play_chord.clone().transpose(
      chord_matrix.capo_selecter.getCapo(),
      chord_matrix.getKeySignature()
    );
    // ϊ̃R[hL[{[hʂɐݒ
    keyboard_panel.keyboard_center_panel.keyboard.setChord(original_chord);
    //
    // ߂Bɂ炷m肷B
    Music.Range chord_range = new Music.Range(
      keyboard_panel.keyboard_center_panel.keyboard.getChromaticOffset() + 10 +
        ( keyboard_panel.keyboard_center_panel.keyboard.getOctaves() / 4 ) * 12,
      inversion_omission_button.isAutoInversionMode() ?
        keyboard_panel.keyboard_center_panel.keyboard.getChromaticOffset() + 21 :
        keyboard_panel.keyboard_center_panel.keyboard.getChromaticOffset() + 33,
      -2,
      inversion_omission_button.isAutoInversionMode()
    );
    int[] notes = original_chord.toNoteArray( chord_range, original_key );
    //
    // O炵R[h\oĂ
    int[] prev_chord_on_notes = null;
    if( chord_matrix.isDragged() || chord_matrix.getNoteIndex() >= 0 )
      prev_chord_on_notes = Arrays.copyOf(
        chord_on_notes, chord_on_notes.length
      );
    //
    // ɖ炷\߂
    chord_on_notes = new int[notes.length];
    int i = 0;
    for( int n : notes ) {
      if( inversion_omission_button.getOmissionNoteIndex() == i ) {
        i++; continue;
      }
      chord_on_notes[i++] = n;
      //
      // ̉Ă邩ׂ
      boolean is_note_on = false;
      if( prev_chord_on_notes != null ) {
        for( int prev_n : prev_chord_on_notes ) {
          if( n == prev_n ) {
            is_note_on = true;
            break;
          }
        }
      }
      // łɖĂ̂ɒP炻ƂꍇA
      // 炻ƂĂ鉹U~߂B
      if( is_note_on && chord_matrix.getNoteIndex() >= 0 &&
        notes[chord_matrix.getNoteIndex()] - n == 0
      ) {
        keyboard_panel.keyboard_center_panel.keyboard.noteOff(n);
        is_note_on = false;
      }
      // ̉ĂȂ炷B
      if( ! is_note_on )
        keyboard_panel.keyboard_center_panel.keyboard.noteOn(n);
    }
    //
    // R[h\
    keyboard_panel.keyboard_center_panel.keyboard.setChord(original_chord);
    chord_matrix.chord_display.setChord(play_chord);
    //
    // R[h_CAOpɂR[h\
    Music.Chord diagram_chord;
    if( chord_diagram.getCapo() == chord_matrix.capo_selecter.getCapo() )
      diagram_chord = play_chord.clone();
    else
      diagram_chord = original_chord.clone().transpose(
        - chord_diagram.getCapo(), original_key
      );
    chord_diagram.setChord(diagram_chord);
    if( chord_diagram.record_text_button.isSelected() )
      lyric_display.appendChord(diagram_chord);
  }
}


class UnicodeConverter {
  //
  // Char encoding methods - {\̂߂̕R[hϊ
  //
  //@MIDI t@C̉̎AWindows ł MIDI foCXɂ
  //@Shift-JIS ŏꂽ{̃oCg񂪂܂B
  //
  //@̂܂ String NXƂēǂݍłAShift-JIS ̂܂܂Ȃ̂m炸
  //@Unicode Ǝvĕ\邱ƂɂȂǍɂȂ܂B
  //
  //@ɂ́AoCg Shift-JIS ł邱ƂĂŁA
  //@Unicode ɕϊȂ String NX̕֊i[܂B
  //
  String os_encoding = (
    new OutputStreamWriter(new ByteArrayOutputStream())
  ).getEncoding();
  String convertToUnicode(byte[] non_unicode_bytes) {
    try{
      return new String( non_unicode_bytes, os_encoding );
    } catch( UnsupportedEncodingException e ) { }
    return new String( non_unicode_bytes );
  }
  String convertToUnicode(String non_unicode_string) {
    char ca[] = non_unicode_string.toCharArray();
    byte ba[] = new byte[ca.length];
    int j = 0;
    for( char c : ca ) ba[j++] = (byte)c;
    return convertToUnicode(ba);
  }
}

/***************************************************************************
 *
 *	GUI parts
 *
 ***************************************************************************/

class ChordDisplay extends JLabel
{
  Music.Chord chord = null;
  PianoKeyboard keyboard = null;
  ChordMatrix chord_matrix = null;
  String default_string = null;
  int note_no = -1;
  private boolean is_dark = false;
  private boolean is_mouse_entered = false;

  public ChordDisplay(String default_string, ChordMatrix chord_matrix, PianoKeyboard keyboard) {
    super(default_string,JLabel.CENTER);
    this.default_string = default_string;
    this.keyboard = keyboard;
    this.chord_matrix = chord_matrix;
    if( chord_matrix != null ) {
      addMouseListener(new MouseAdapter() {
        public void mousePressed(MouseEvent e) {
          if( chord != null ) { // R[h\Ăꍇ
            if( (e.getModifiersEx() & e.BUTTON3_DOWN_MASK) != 0 ) {
              // ENbNŃR[h~߂
              ChordDisplay.this.chord_matrix.setSelectedChord( (Music.Chord)null );
            }
            else {
              // R[h炷B
              //   L[{[hw肳ĂꍇAIWiL[iJ|fρj̃R[hgB
              if( ChordDisplay.this.keyboard == null )
                ChordDisplay.this.chord_matrix.setSelectedChord( chord );
              else
                ChordDisplay.this.chord_matrix.setSelectedChordCapo( chord );
            }
          }
          else if( note_no >= 0 ) { // K\Ăꍇ
            ChordDisplay.this.keyboard.noteOn(note_no);
          }
        }
        public void mouseReleased(MouseEvent e) {
          if( note_no >= 0 ) ChordDisplay.this.keyboard.noteOff(note_no);
        }
        public void mouseEntered(MouseEvent e) {
          is_mouse_entered = true;
          if( note_no >= 0 || chord != null ) repaint();
        }
        public void mouseExited(MouseEvent e) {
          is_mouse_entered = false;
          if( note_no >= 0 || chord != null ) repaint();
        }
      });
      addMouseWheelListener(ChordDisplay.this.chord_matrix);
    }
  }
  public void paint(Graphics g) {
    super.paint(g);
    Dimension d = getSize();
    if( is_mouse_entered && (note_no >= 0 || chord != null) ) {
      g.setColor(Color.gray);
      g.drawRect( 0, 0, d.width-1, d.height-1 );
    }
  }
  private void setChordText() {
    setText( chord.toHtmlString(is_dark ? "#FFCC33" : "maroon") );
  }
  void setNote(int note_no) { setNote( note_no, false ); }
  void setNote(int note_no, boolean is_rhythm_part) {
    setToolTipText(null);
    this.chord = null;
    this.note_no = note_no;
    if( note_no < 0 ) {
      //
      // Clear
      //
      setText(default_string);
      return;
    }
    if( is_rhythm_part ) {
      setText(
        "MIDI note No." + note_no + " : "
        + MIDISpec.getPercussionName(note_no)
      );
    }
    else {
      setText(
        "Note: " + Music.noteNoToSymbol(note_no)
        + "  -  MIDI note No." + note_no + " : "
        + Math.round(Music.noteNoToFrequency(note_no)) + "Hz" );
    }
  }
  void setChord(Music.Chord chord) {
    this.chord = chord;
    this.note_no = -1;
    if( chord == null ) {
      setText( default_string );
      setToolTipText( null );
    }
    else {
      setChordText();
      setToolTipText( "Chord: " + chord.toName() );
    }
  }
  void setDarkMode(boolean is_dark) {
    this.is_dark = is_dark;
    if( chord != null ) setChordText();
  }
}

// Inversion and Omission menu button
//
class InversionAndOmissionLabel extends JLabel
  implements MouseListener, PopupMenuListener
{
  JPopupMenu popup_menu;
  ButtonGroup omission_group = new ButtonGroup();
  ButtonIcon icon = new ButtonIcon(ButtonIcon.INVERSION_ICON);
  JRadioButtonMenuItem rb_items[] = new JRadioButtonMenuItem[4];
  JCheckBoxMenuItem cb_inversion;

  public InversionAndOmissionLabel() {
    setIcon(icon);
    popup_menu = new JPopupMenu();
    popup_menu.add(
      cb_inversion = new JCheckBoxMenuItem("Auto Inversion",true)
    );
    popup_menu.addSeparator();
    omission_group.add(
      rb_items[0] = new JRadioButtonMenuItem("All notes",true)
    );
    popup_menu.add(rb_items[0]);
    omission_group.add(
      rb_items[1] = new JRadioButtonMenuItem("Omit 5th")
    );
    popup_menu.add(rb_items[1]);
    omission_group.add(
      rb_items[2] = new JRadioButtonMenuItem("Omit 3rd (Power Chord)")
    );
    popup_menu.add(rb_items[2]);
    omission_group.add(
      rb_items[3] = new JRadioButtonMenuItem("Omit root")
    );
    popup_menu.add(rb_items[3]);
    addMouseListener(this);
    popup_menu.addPopupMenuListener(this);
    setToolTipText("Automatic inversion and Note omission - ]Əȗ̐ݒ");
  }
  public void mousePressed(MouseEvent e) {
    Component c = e.getComponent();
    if( c == this ) {
      popup_menu.show( c, 0, getHeight() );
    }
  }
  public void mouseReleased(MouseEvent e) { }
  public void mouseEntered(MouseEvent e) { }
  public void mouseExited(MouseEvent e) { }
  public void mouseClicked(MouseEvent e) { }
  public void popupMenuCanceled(PopupMenuEvent e) { }
  public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    repaint(); // To repaint icon image
  }
  public void popupMenuWillBecomeVisible(PopupMenuEvent e) { }
  public boolean isAutoInversionMode() {
    return cb_inversion.isSelected();
  }
  public void setAutoInversion(boolean is_auto) {
    cb_inversion.setSelected(is_auto);
  }
  public int getOmissionNoteIndex() {
    if( rb_items[3].isSelected() ) { // Root
      return 0;
    }
    else if( rb_items[2].isSelected() ) { // 3rd
      return 1;
    }
    else if( rb_items[1].isSelected() ) { // 5th
      return 2;
    }
    else { // No omission
      return -1;
    }
  }
  public void setOmissionNoteIndex(int index) {
    switch(index) {
    case 0: rb_items[3].setSelected(true); break;
    case 1: rb_items[2].setSelected(true); break;
    case 2: rb_items[1].setSelected(true); break;
    default: rb_items[0].setSelected(true); break;
    }
  }
}

class ChordTextField extends JTextField {
  Music.Chord current_chord = null;
  long lyric_arrived_time = System.nanoTime();
  UnicodeConverter unicode_converter = new UnicodeConverter();
  public ChordTextField() {
    super(80);
    //
    // JTextField ́ATCYݒȂƃTCYɏcɐLщ߂Ă܂B
    // Ps͂łȂ̂ŁAcɐLт̂̓Xy[XȂB
    // ŁÂ悤Ȍۂh~邽߂ɁAőTCY𖾎I
    // ʃTCYƓɐݒ肷B
    //
    // To reduce resized height, set maximum size to screen size.
    //
    setMaximumSize(
      java.awt.Toolkit.getDefaultToolkit().getScreenSize()
    );
  }
  public void appendChord(Music.Chord chord) {
    if( current_chord == null && chord == null )
      return;
    if( current_chord != null && chord != null && chord.equals(current_chord) )
      return;
    String delimiter = ""; // was "\n"
    setText( getText() + (chord == null ? delimiter : chord + " ") );
    current_chord = ( chord == null ? null : chord.clone() );
  }
  public void addLyric(byte[] data) {
    long start_time = System.nanoTime();
    // ̎\
    String additional_lyric = unicode_converter.convertToUnicode(data).trim();
    byte sjis_bytes[];
    // SpƔpŒ̊ɂ邽 SJIS ̒Ŕׂ
    try {
      sjis_bytes = additional_lyric.getBytes("MS932");
    } catch( UnsupportedEncodingException e ) {
      sjis_bytes = additional_lyric.getBytes();
    }
    String lyric = getText();
    if( start_time - lyric_arrived_time > 1000000000L /* 1sec */
      && (
        sjis_bytes.length > 8 || sjis_bytes.length == 0
        || lyric == null || lyric.length() == 0
      )
    ) {
      // ̎󔒂Aǉɉ̎Ȃꍇ͏㏑B
      // AO񂩂[ɎԂoĂȂꍇ͏㏑ȂB
      setText(additional_lyric);
    }
    else {
      // Z̎ꍇ́Ả̎ɒǉ
      setText( lyric + " " + additional_lyric );
    }
    setCaretPosition(getText().length());
    lyric_arrived_time = start_time;
  }
}


