/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.ClassfileFactory;
import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.ClassfileLoaderAction;
import com.jeantessier.classreader.ClassfileLoaderDispatcher;
import com.jeantessier.classreader.DirectoryClassfileLoader;
import com.jeantessier.classreader.JarClassfileLoader;
import com.jeantessier.classreader.LoadEvent;
import com.jeantessier.classreader.LoadListener;
import com.jeantessier.classreader.PermissiveDispatcher;
import com.jeantessier.classreader.ZipClassfileLoader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public abstract class ClassfileLoaderEventSource
extends ClassfileLoader {
    public static final ClassfileLoaderDispatcher DEFAULT_DISPATCHER = new PermissiveDispatcher();
    private ClassfileFactory factory;
    private ClassfileLoaderDispatcher dispatcher;
    private ClassfileLoader dirLoader = new DirectoryClassfileLoader(this);
    private ClassfileLoader jarLoader = new JarClassfileLoader(this);
    private ClassfileLoader zipLoader = new ZipClassfileLoader(this);
    private HashSet<LoadListener> loadListeners = new HashSet();
    private LinkedList<String> groupNames = new LinkedList();
    private LinkedList<Integer> groupSizes = new LinkedList();
    private ClassfileLoaderAction previousDispatch;

    public ClassfileLoaderEventSource(ClassfileFactory factory) {
        this(factory, DEFAULT_DISPATCHER);
    }

    public ClassfileLoaderEventSource(ClassfileFactory factory, ClassfileLoaderDispatcher dispatcher) {
        this.factory = factory;
        this.dispatcher = dispatcher;
    }

    protected ClassfileFactory getFactory() {
        return this.factory;
    }

    @Override
    protected void load(String filename) {
        ClassfileLoaderAction dispatch;
        this.previousDispatch = dispatch = this.dispatcher.dispatch(filename);
        switch (dispatch) {
            case IGNORE: {
                Logger.getLogger(this.getClass()).debug((Object)("IGNORE \"" + filename + "\""));
                break;
            }
            case CLASS: 
            case DIRECTORY: {
                Logger.getLogger(this.getClass()).debug((Object)("DIRECTORY or CLASS \"" + filename + "\""));
                this.dirLoader.load(filename);
                break;
            }
            case ZIP: {
                Logger.getLogger(this.getClass()).debug((Object)("ZIP \"" + filename + "\""));
                this.zipLoader.load(filename);
                break;
            }
            case JAR: {
                Logger.getLogger(this.getClass()).debug((Object)("JAR \"" + filename + "\""));
                this.jarLoader.load(filename);
                break;
            }
            default: {
                Logger.getLogger(this.getClass()).debug((Object)("default (IGNORE) \"" + filename + "\""));
            }
        }
    }

    @Override
    protected void load(String filename, InputStream in) {
        ClassfileLoaderAction dispatch = this.dispatcher.dispatch(filename);
        if (dispatch == ClassfileLoaderAction.IGNORE && this.getTopGroupSize() == 1 && filename.equals(this.getTopGroupName())) {
            dispatch = this.previousDispatch;
        }
        switch (dispatch) {
            case IGNORE: {
                Logger.getLogger(this.getClass()).debug((Object)("IGNORE \"" + filename + "\""));
                break;
            }
            case DIRECTORY: {
                Logger.getLogger(this.getClass()).debug((Object)("DIRECTORY \"" + filename + "\""));
                this.dirLoader.load(filename, in);
                break;
            }
            case ZIP: {
                Logger.getLogger(this.getClass()).debug((Object)("ZIP \"" + filename + "\""));
                this.zipLoader.load(filename, in);
                break;
            }
            case JAR: {
                Logger.getLogger(this.getClass()).debug((Object)("JAR \"" + filename + "\""));
                this.jarLoader.load(filename, in);
                break;
            }
            case CLASS: {
                Logger.getLogger(this.getClass()).debug((Object)("CLASS \"" + filename + "\""));
                try {
                    this.fireBeginClassfile(filename);
                    Classfile classfile = this.load(new DataInputStream(in));
                    this.fireEndClassfile(filename, classfile);
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass()).warn((Object)("Cannot load class from file \"" + filename + "\""), (Throwable)ex);
                }
                break;
            }
            default: {
                Logger.getLogger(this.getClass()).debug((Object)("default (IGNORE) \"" + filename + "\""));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLoadListener(LoadListener listener) {
        HashSet<LoadListener> hashSet = this.loadListeners;
        synchronized (hashSet) {
            this.loadListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLoadListener(LoadListener listener) {
        HashSet<LoadListener> hashSet = this.loadListeners;
        synchronized (hashSet) {
            this.loadListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireBeginSession() {
        HashSet listeners;
        Logger.getLogger(this.getClass()).debug((Object)"Begin session");
        LoadEvent event = new LoadEvent(this, null, null, null);
        HashSet<LoadListener> hashSet = this.loadListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.loadListeners.clone();
        }
        for (LoadListener listener : listeners) {
            listener.beginSession(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireBeginGroup(String groupName, int size) {
        HashSet listeners;
        Logger.getLogger(this.getClass()).debug((Object)("Begin group \"" + groupName + "\" of size " + size));
        LoadEvent event = new LoadEvent(this, groupName, size);
        HashSet<LoadListener> hashSet = this.loadListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.loadListeners.clone();
        }
        for (LoadListener listener : listeners) {
            listener.beginGroup(event);
        }
        this.pushGroupName(groupName);
        this.pushGroupSize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireBeginFile(String filename) {
        HashSet listeners;
        Logger.getLogger(this.getClass()).debug((Object)("Begin file \"" + filename + "\""));
        LoadEvent event = new LoadEvent(this, this.getTopGroupName(), filename, null);
        HashSet<LoadListener> hashSet = this.loadListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.loadListeners.clone();
        }
        for (LoadListener listener : listeners) {
            listener.beginFile(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireBeginClassfile(String filename) {
        HashSet listeners;
        Logger.getLogger(this.getClass()).debug((Object)("Begin classfile \"" + filename + "\""));
        LoadEvent event = new LoadEvent(this, this.getTopGroupName(), filename, null);
        HashSet<LoadListener> hashSet = this.loadListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.loadListeners.clone();
        }
        for (LoadListener listener : listeners) {
            listener.beginClassfile(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireEndClassfile(String filename, Classfile classfile) {
        HashSet listeners;
        Logger.getLogger(this.getClass()).debug((Object)("End classfile \"" + filename + "\": " + (classfile != null ? classfile.getClassName() : "nothing")));
        LoadEvent event = new LoadEvent(this, this.getTopGroupName(), filename, classfile);
        HashSet<LoadListener> hashSet = this.loadListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.loadListeners.clone();
        }
        for (LoadListener listener : listeners) {
            listener.endClassfile(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireEndFile(String filename) {
        HashSet listeners;
        Logger.getLogger(this.getClass()).debug((Object)("End file \"" + filename + "\""));
        LoadEvent event = new LoadEvent(this, this.getTopGroupName(), filename, null);
        HashSet<LoadListener> hashSet = this.loadListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.loadListeners.clone();
        }
        for (LoadListener listener : listeners) {
            listener.endFile(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireEndGroup(String groupName) {
        HashSet listeners;
        Logger.getLogger(this.getClass()).debug((Object)("End group \"" + groupName + "\""));
        LoadEvent event = new LoadEvent(this, groupName, null, null);
        HashSet<LoadListener> hashSet = this.loadListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.loadListeners.clone();
        }
        for (LoadListener listener : listeners) {
            listener.endGroup(event);
        }
        this.popGroupName();
        this.popGroupSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireEndSession() {
        HashSet listeners;
        Logger.getLogger(this.getClass()).debug((Object)"End session");
        LoadEvent event = new LoadEvent(this, null, null, null);
        HashSet<LoadListener> hashSet = this.loadListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.loadListeners.clone();
        }
        for (LoadListener listener : listeners) {
            listener.endSession(event);
        }
    }

    private String getTopGroupName() {
        String result = null;
        if (!this.groupNames.isEmpty()) {
            result = this.groupNames.getLast();
        }
        return result;
    }

    private void pushGroupName(String groupName) {
        this.groupNames.addLast(groupName);
    }

    private String popGroupName() {
        return this.groupNames.removeLast();
    }

    private int getTopGroupSize() {
        int result = 0;
        if (!this.groupSizes.isEmpty()) {
            result = this.groupSizes.getLast();
        }
        return result;
    }

    private void pushGroupSize(int size) {
        this.groupSizes.addLast(size);
    }

    private int popGroupSize() {
        return this.groupSizes.removeLast();
    }
}

