/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.LocalVariable;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.SymbolGathererStrategy;
import com.jeantessier.classreader.SymbolGathererStrategyDecorator;
import java.util.Iterator;
import java.util.List;
import org.apache.oro.text.perl.Perl5Util;

public class FilteringSymbolGathererStrategy
extends SymbolGathererStrategyDecorator {
    private Perl5Util perl = new Perl5Util();
    private List<String> includes;
    private List<String> excludes;

    public FilteringSymbolGathererStrategy(SymbolGathererStrategy delegate, List<String> includes, List<String> excludes) {
        super(delegate);
        this.includes = includes;
        this.excludes = excludes;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean isMatching(Classfile classfile) {
        boolean result = false;
        if (this.matches(classfile.getClassName())) {
            result = super.isMatching(classfile);
        }
        return result;
    }

    @Override
    public boolean isMatching(Field_info field) {
        boolean result = false;
        if (this.matches(field.getFullSignature())) {
            result = super.isMatching(field);
        }
        return result;
    }

    @Override
    public boolean isMatching(Method_info method) {
        boolean result = false;
        if (this.matches(method.getFullSignature())) {
            result = super.isMatching(method);
        }
        return result;
    }

    @Override
    public boolean isMatching(LocalVariable localVariable) {
        boolean result = false;
        if (this.matches(localVariable.getName())) {
            result = super.isMatching(localVariable);
        }
        return result;
    }

    private boolean matches(String name) {
        return this.matches(this.getIncludes(), name) && !this.matches(this.getExcludes(), name);
    }

    private boolean matches(List<String> regularExpressions, String name) {
        boolean result = false;
        Iterator<String> i = regularExpressions.iterator();
        while (!result && i.hasNext()) {
            result = this.perl.match(i.next(), name);
        }
        return result;
    }
}

