/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.DescriptorHelper;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.Attribute_info;
import com.jeantessier.classreader.impl.Classfile;
import com.jeantessier.classreader.impl.ConstantValue_attribute;
import com.jeantessier.classreader.impl.Feature_info;
import com.jeantessier.classreader.impl.String_info;
import java.io.DataInput;
import java.io.IOException;
import java.util.Iterator;

public class Field_info
extends Feature_info
implements com.jeantessier.classreader.Field_info {
    private static final int ACC_VOLATILE = 64;
    private static final int ACC_TRANSIENT = 128;
    private static final int ACC_ENUM = 16384;

    public Field_info(Classfile classfile, DataInput in) throws IOException {
        super(classfile, in);
    }

    @Override
    public String getFeatureType() {
        return "field";
    }

    @Override
    public boolean isVolatile() {
        return (this.getAccessFlag() & 0x40) != 0;
    }

    @Override
    public boolean isTransient() {
        return (this.getAccessFlag() & 0x80) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.getAccessFlag() & 0x4000) != 0;
    }

    @Override
    public String getType() {
        return DescriptorHelper.getType(this.getDescriptor());
    }

    @Override
    public String getDeclaration() {
        StringBuffer result = new StringBuffer();
        if (this.isPublic()) {
            result.append("public ");
        }
        if (this.isProtected()) {
            result.append("protected ");
        }
        if (this.isPrivate()) {
            result.append("private ");
        }
        if (this.isStatic()) {
            result.append("static ");
        }
        if (this.isFinal()) {
            result.append("final ");
        }
        if (this.isVolatile()) {
            result.append("volatile ");
        }
        if (this.isTransient()) {
            result.append("transient ");
        }
        result.append(this.getType()).append(" ");
        result.append(this.getName());
        return result.toString();
    }

    @Override
    public String getFullDeclaration() {
        String result = this.getDeclaration();
        if (this.getConstantValue() != null) {
            result = this.getConstantValue().getRawValue() instanceof String_info ? result + " = \"" + this.getConstantValue().getRawValue() + "\"" : result + " = " + this.getConstantValue().getRawValue();
        }
        return result;
    }

    @Override
    public String getSignature() {
        return this.getName();
    }

    @Override
    public ConstantValue_attribute getConstantValue() {
        ConstantValue_attribute result = null;
        Iterator<Attribute_info> i = this.getAttributes().iterator();
        while (result == null && i.hasNext()) {
            Attribute_info temp = i.next();
            if (!(temp instanceof ConstantValue_attribute)) continue;
            result = (ConstantValue_attribute)temp;
        }
        return result;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitField_info(this);
    }
}

