/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.AttributeType;
import com.jeantessier.classreader.impl.Attribute_info;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.InnerClass;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class InnerClasses_attribute
extends Attribute_info
implements com.jeantessier.classreader.InnerClasses_attribute {
    private Collection<InnerClass> classes = new LinkedList<InnerClass>();

    public InnerClasses_attribute(ConstantPool constantPool, Visitable owner, DataInput in) throws IOException {
        super(constantPool, owner);
        int byteCount = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Attribute length: " + byteCount));
        int classCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + classCount + " inner class(es) ..."));
        for (int i = 0; i < classCount; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Inner class " + i + ":"));
            this.classes.add(new InnerClass(this, in));
        }
    }

    public Collection<InnerClass> getInnerClasses() {
        return this.classes;
    }

    public String toString() {
        return "InnerClasses";
    }

    @Override
    public String getAttributeName() {
        return AttributeType.INNER_CLASSES.getAttributeName();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitInnerClasses_attribute(this);
    }
}

