/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.dependency.MatchException;
import com.jeantessier.dependencyfinder.gui.DependencyFinder;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class ClosureQueryAction
extends AbstractAction
implements Runnable {
    private DependencyFinder model = null;

    public ClosureQueryAction(DependencyFinder model) {
        this.model = model;
        this.putValue("LongDescription", "Compute transitive closure");
        this.putValue("Name", "Closure");
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/closure-query.gif")));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new Thread(this).start();
    }

    @Override
    public void run() {
        try {
            this.model.getStatusLine().showInfo("Processing closure query ...");
            Date start = new Date();
            this.model.clearClosureResult();
            this.model.doClosureQuery();
            Date stop = new Date();
            this.model.getStatusLine().showInfo("Closure query done (" + (double)(stop.getTime() - start.getTime()) / 1000.0 + " secs).");
        }
        catch (MatchException ex) {
            JOptionPane.showMessageDialog(this.model, ex.getMessage() + ": " + ex.getCause().getMessage(), "Malformed pattern", 0);
            this.model.getStatusLine().showInfo("Ready.");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.model, ex.getMessage(), "Error", 0);
            this.model.getStatusLine().showInfo("Ready.");
        }
    }
}

