/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.dependencyfinder.gui.OOMetricsTableModel;
import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.StatisticalMeasurement;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class MeasurementTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Color PRIMARY_NORMAL_BACKGROUND = new Color(247, 247, 247);
    private static final Color SECONDARY_NORMAL_BACKGROUND = new Color(223, 223, 223);
    private static final Color NORMAL_FOREGROUND = Color.black;
    private static final Color PRIMARY_HIGHLIGHTED_BACKGROUND = new Color(255, 223, 223);
    private static final Color SECONDARY_HIGHLIGHTED_BACKGROUND = new Color(255, 207, 207);
    private static final Color HIGHLIGHTED_FOREGROUND = Color.red;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (column == 0) {
            result.setHorizontalAlignment(2);
        } else {
            result.setHorizontalAlignment(0);
        }
        if (value instanceof Measurement) {
            String text;
            Measurement measurement = (Measurement)value;
            if (measurement.isInRange()) {
                this.formatAsNormalCell(isSelected, row, result);
            } else {
                this.formatAsHighlightedCell(isSelected, row, result);
            }
            int dispose = ((OOMetricsTableModel)table.getModel()).getRawColumnDispose(column);
            if (measurement instanceof StatisticalMeasurement) {
                StatisticalMeasurement stat = (StatisticalMeasurement)measurement;
                switch (dispose) {
                    case 1: {
                        text = String.valueOf(stat.getMinimum());
                        break;
                    }
                    case 2: {
                        text = String.valueOf(stat.getMedian());
                        break;
                    }
                    case 3: {
                        text = String.valueOf(stat.getAverage());
                        break;
                    }
                    case 4: {
                        text = String.valueOf(stat.getStandardDeviation());
                        break;
                    }
                    case 5: {
                        text = String.valueOf(stat.getMaximum());
                        break;
                    }
                    case 6: {
                        text = String.valueOf(stat.getSum());
                        break;
                    }
                    default: {
                        text = "n/a";
                        break;
                    }
                }
            } else {
                text = measurement.getValue().toString();
            }
            this.setCellContent(result, measurement, dispose, text);
        } else if (value instanceof Metrics) {
            Metrics metrics = (Metrics)value;
            if (metrics.isInRange()) {
                this.formatAsNormalCell(isSelected, row, result);
            } else {
                this.formatAsHighlightedCell(isSelected, row, result);
            }
            result.setText(metrics.getName());
            result.setToolTipText(metrics.getName());
        } else {
            this.formatAsNormalCell(isSelected, row, result);
        }
        return result;
    }

    private void formatAsNormalCell(boolean isSelected, int row, JLabel result) {
        result.setForeground(NORMAL_FOREGROUND);
        if (!isSelected) {
            if (row / 3 % 2 == 0) {
                result.setBackground(PRIMARY_NORMAL_BACKGROUND);
            } else {
                result.setBackground(SECONDARY_NORMAL_BACKGROUND);
            }
        }
    }

    private void formatAsHighlightedCell(boolean isSelected, int row, JLabel result) {
        result.setForeground(HIGHLIGHTED_FOREGROUND);
        if (!isSelected) {
            if (row / 3 % 2 == 0) {
                result.setBackground(PRIMARY_HIGHLIGHTED_BACKGROUND);
            } else {
                result.setBackground(SECONDARY_HIGHLIGHTED_BACKGROUND);
            }
        }
    }

    private void setCellContent(JLabel result, Measurement measurement, int dispose, String text) {
        StringBuffer tooltip = new StringBuffer();
        tooltip.append("<html><body><p>");
        tooltip.append("<b>").append(measurement.getContext().getName()).append("</b><br>");
        tooltip.append(measurement.getLongName()).append(" (").append(measurement.getShortName()).append(")");
        if (measurement instanceof StatisticalMeasurement) {
            tooltip.append(", ").append(StatisticalMeasurement.getDisposeLabel(dispose));
        }
        tooltip.append("<br>");
        tooltip.append("valid range: ").append(measurement.getDescriptor().getRangeAsString()).append("<br>");
        tooltip.append("value: ").append(text);
        if (!measurement.isInRange()) {
            tooltip.append(" <b>*** out of range ***</b>");
        }
        if (measurement instanceof StatisticalMeasurement) {
            tooltip.append("<br>").append(measurement);
        }
        tooltip.append("</p></body></html>");
        result.setText(text);
        result.setToolTipText(tooltip.toString());
    }
}

