/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.MetricsComparator;
import com.jeantessier.metrics.StatisticalMeasurement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class OOMetricsTableModel
extends AbstractTableModel {
    private static final Integer LOCAL_DISPOSE_IGNORE = 0;
    private static final Integer LOCAL_DISPOSE_MINIMUM = 1;
    private static final Integer LOCAL_DISPOSE_MEDIAN = 2;
    private static final Integer LOCAL_DISPOSE_AVERAGE = 3;
    private static final Integer LOCAL_DISPOSE_STANDARD_DEVIATION = 4;
    private static final Integer LOCAL_DISPOSE_MAXIMUM = 5;
    private static final Integer LOCAL_DISPOSE_SUM = 6;
    private List<MeasurementDescriptor> descriptors;
    private List<Metrics> metricsList;
    private String[] measurementNames;
    private MeasurementDescriptor[] measurementDescriptors;
    private int[] measurementDispose;
    private Object[][] measurementValues;
    private MetricsComparator comparator = new MetricsComparator("name");

    public OOMetricsTableModel(List<MeasurementDescriptor> descriptors) {
        this.descriptors = descriptors;
        this.buildMetricNames();
        this.buildMetricValues();
    }

    public void setMetrics(Collection<Metrics> metricsList) {
        this.metricsList = new ArrayList<Metrics>(metricsList);
        if (metricsList.isEmpty()) {
            this.buildMetricValues();
        } else {
            Collections.sort(this.metricsList, this.comparator);
            this.buildMetricValues(this.metricsList);
        }
        this.fireTableStructureChanged();
    }

    public MeasurementDescriptor getColumnDescriptor(int column) {
        return this.measurementDescriptors[column];
    }

    public void updateMetrics(Collection<Metrics> metricsList) {
        this.metricsList = new ArrayList<Metrics>(metricsList);
        if (metricsList.isEmpty()) {
            this.buildMetricValues();
        } else {
            Collections.sort(this.metricsList, this.comparator);
            this.buildMetricValues(this.metricsList);
        }
        this.fireTableDataChanged();
    }

    public void sortOn(String name, int dispose) {
        this.comparator.sortOn(name, dispose);
        Collections.sort(this.metricsList, this.comparator);
        this.buildMetricValues(this.metricsList);
        this.fireTableDataChanged();
    }

    private void buildMetricNames() {
        LinkedList<String> names = new LinkedList<String>();
        names.add("name");
        LinkedList<MeasurementDescriptor> columnDescriptors = new LinkedList<MeasurementDescriptor>();
        columnDescriptors.add(null);
        LinkedList<Integer> dispose = new LinkedList<Integer>();
        dispose.add(LOCAL_DISPOSE_IGNORE);
        for (MeasurementDescriptor descriptor : this.descriptors) {
            if (!descriptor.isVisible()) continue;
            if (descriptor.getClassFor().equals(StatisticalMeasurement.class)) {
                names.add(descriptor.getShortName());
                columnDescriptors.add(descriptor);
                dispose.add(LOCAL_DISPOSE_MINIMUM);
                names.add(descriptor.getShortName());
                columnDescriptors.add(descriptor);
                dispose.add(LOCAL_DISPOSE_MEDIAN);
                names.add(descriptor.getShortName());
                columnDescriptors.add(descriptor);
                dispose.add(LOCAL_DISPOSE_AVERAGE);
                names.add(descriptor.getShortName());
                columnDescriptors.add(descriptor);
                dispose.add(LOCAL_DISPOSE_STANDARD_DEVIATION);
                names.add(descriptor.getShortName());
                columnDescriptors.add(descriptor);
                dispose.add(LOCAL_DISPOSE_MAXIMUM);
                names.add(descriptor.getShortName());
                columnDescriptors.add(descriptor);
                dispose.add(LOCAL_DISPOSE_SUM);
                continue;
            }
            names.add(descriptor.getShortName());
            columnDescriptors.add(descriptor);
            dispose.add(LOCAL_DISPOSE_IGNORE);
        }
        this.measurementNames = names.toArray(new String[0]);
        this.measurementDescriptors = columnDescriptors.toArray(new MeasurementDescriptor[0]);
        this.measurementDispose = new int[dispose.size()];
        for (int j = 0; j < dispose.size(); ++j) {
            this.measurementDispose[j] = (Integer)dispose.get(j);
        }
    }

    private void buildMetricValues() {
        this.measurementValues = new Object[0][];
    }

    private void buildMetricValues(Collection<Metrics> metricsList) {
        this.measurementValues = new Object[metricsList.size()][];
        int i = 0;
        for (Metrics currentMetrics : metricsList) {
            ArrayList<Measurement> measurements = new ArrayList<Measurement>(this.measurementNames.length);
            for (MeasurementDescriptor descriptor : this.descriptors) {
                if (!descriptor.isVisible()) continue;
                Measurement measurement = currentMetrics.getMeasurement(descriptor.getShortName());
                if (measurement instanceof StatisticalMeasurement) {
                    measurements.add(measurement);
                    measurements.add(measurement);
                    measurements.add(measurement);
                    measurements.add(measurement);
                    measurements.add(measurement);
                    measurements.add(measurement);
                    continue;
                }
                measurements.add(measurement);
            }
            this.measurementValues[i] = new Object[measurements.size() + 1];
            int j = 0;
            this.measurementValues[i][j++] = currentMetrics.getName();
            for (Measurement measurement : measurements) {
                this.measurementValues[i][j++] = measurement;
            }
            ++i;
        }
    }

    @Override
    public int getColumnCount() {
        return this.measurementNames.length;
    }

    @Override
    public int getRowCount() {
        return this.measurementValues.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.measurementValues[rowIndex][columnIndex];
    }

    public String getRawColumnName(int column) {
        return this.measurementNames[column];
    }

    public int getRawColumnDispose(int column) {
        return this.measurementDispose[column];
    }

    @Override
    public String getColumnName(int column) {
        String result = this.getRawColumnName(column);
        switch (this.getRawColumnDispose(column)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                result = result + " (" + StatisticalMeasurement.getDisposeAbbreviation(this.getRawColumnDispose(column)) + ")";
                break;
            }
        }
        return result;
    }
}

