/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.dependencyfinder.gui.StatusLineUpdater;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class StatusLine
extends JTextField {
    public static final Font PLAIN_FONT = new Font("dialog", 0, 12);
    public static final Font BOLD_FONT = new Font("dialog", 1, 12);

    public StatusLine(int preferredWidth) {
        this.setFont(BOLD_FONT);
        this.setEditable(false);
        this.setBorder(BorderFactory.createBevelBorder(1));
        Dimension d = this.getPreferredSize();
        d.width = preferredWidth;
        this.setPreferredSize(d);
    }

    public void showInfo(String message) {
        SwingUtilities.invokeLater(new StatusLineUpdater(this, PLAIN_FONT, Color.black, message, message));
    }

    public void showError(String status) {
        SwingUtilities.invokeLater(new StatusLineUpdater(this, BOLD_FONT, Color.red, status, status));
    }

    public void clear() {
        SwingUtilities.invokeLater(new StatusLineUpdater(this, PLAIN_FONT, Color.black, "", null));
    }
}

