/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.webwork;

import com.jeantessier.classreader.LoadEvent;
import com.jeantessier.dependencyfinder.VerboseListenerBase;
import java.io.PrintWriter;

public class VerboseListener
extends VerboseListenerBase {
    private PrintWriter out;
    private int classCount = 0;

    public VerboseListener(PrintWriter out) {
        this.out = out;
    }

    public int getClassCount() {
        return this.classCount;
    }

    public void print(String s) {
        this.out.println(s);
    }

    @Override
    public void beginGroup(LoadEvent event) {
        super.beginGroup(event);
        this.out.println();
        this.out.print("\tSearching ");
        this.out.print(this.getCurrentGroup().getName());
        if (this.getCurrentGroup().getSize() >= 0) {
            this.out.print(" (");
            this.out.print(this.getCurrentGroup().getSize());
            this.out.print(" files)");
        }
        this.out.print(" ...");
        this.out.println();
    }

    @Override
    public void beginFile(LoadEvent event) {
        super.beginFile(event);
        this.out.print(this.getRatioIndicator());
    }

    @Override
    public void endClassfile(LoadEvent event) {
        super.endClassfile(event);
        ++this.classCount;
        this.out.print("\t\tGetting dependencies from ");
        this.out.print(event.getClassfile());
        this.out.print(" ...");
        this.out.println();
    }

    @Override
    public void endFile(LoadEvent event) {
        super.endFile(event);
        if (!this.getVisitedFiles().contains(event.getFilename())) {
            this.out.print("\t\t<i>Skipping ");
            this.out.print(event.getFilename());
            this.out.print(" ...</i>");
            this.out.println();
        }
    }
}

