/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.util;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.util.MonitorMode;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.util.Dimension;
import javax.media.nativewindow.util.DimensionReadOnly;
import javax.media.nativewindow.util.SurfaceSize;

public class ScreenModeUtil {
    public static final int NUM_RESOLUTION_PROPERTIES = 2;
    public static final int NUM_SURFACE_SIZE_PROPERTIES = 1;
    public static final int NUM_MONITOR_MODE_PROPERTIES = 3;
    public static final int NUM_SCREEN_MODE_PROPERTIES = 1;
    public static final int NUM_SCREEN_MODE_PROPERTIES_ALL = 8;

    public static int getIndex(List list, ScreenMode screenMode) {
        return list.indexOf(screenMode);
    }

    public static int getIndexByHashCode(List list, ScreenMode screenMode) {
        for (int i = 0; null != list && i < list.size(); ++i) {
            if (screenMode.hashCode() != ((ScreenMode)list.get(i)).hashCode()) continue;
            return i;
        }
        return -1;
    }

    public static List filterByResolution(List list, DimensionReadOnly dimensionReadOnly) {
        int n;
        if (null == list || list.size() == 0) {
            return null;
        }
        ArrayList<ScreenMode> arrayList = new ArrayList<ScreenMode>();
        int n2 = n = dimensionReadOnly.getHeight() * dimensionReadOnly.getWidth();
        int n3 = 0;
        for (int i = 0; null != list && i < list.size(); ++i) {
            ScreenMode screenMode = (ScreenMode)list.get(i);
            DimensionReadOnly dimensionReadOnly2 = screenMode.getMonitorMode().getSurfaceSize().getResolution();
            int n4 = Math.abs(n - dimensionReadOnly2.getHeight() * dimensionReadOnly2.getWidth());
            if (n4 < n2) {
                n2 = n4;
                n3 = i;
            }
            if (!dimensionReadOnly2.equals(dimensionReadOnly)) continue;
            arrayList.add(screenMode);
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        dimensionReadOnly = ((ScreenMode)list.get(n3)).getMonitorMode().getSurfaceSize().getResolution();
        return ScreenModeUtil.filterByResolution(list, dimensionReadOnly);
    }

    public static List filterBySurfaceSize(List list, SurfaceSize surfaceSize) {
        if (null == list || list.size() == 0) {
            return null;
        }
        ArrayList<ScreenMode> arrayList = new ArrayList<ScreenMode>();
        for (int i = 0; null != list && i < list.size(); ++i) {
            ScreenMode screenMode = (ScreenMode)list.get(i);
            if (!screenMode.getMonitorMode().getSurfaceSize().equals((Object)surfaceSize)) continue;
            arrayList.add(screenMode);
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    public static List filterByRotation(List list, int n) {
        if (null == list || list.size() == 0) {
            return null;
        }
        ArrayList<ScreenMode> arrayList = new ArrayList<ScreenMode>();
        for (int i = 0; null != list && i < list.size(); ++i) {
            ScreenMode screenMode = (ScreenMode)list.get(i);
            if (screenMode.getRotation() != n) continue;
            arrayList.add(screenMode);
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    public static List filterByBpp(List list, int n) {
        if (null == list || list.size() == 0) {
            return null;
        }
        ArrayList<ScreenMode> arrayList = new ArrayList<ScreenMode>();
        for (int i = 0; null != list && i < list.size(); ++i) {
            ScreenMode screenMode = (ScreenMode)list.get(i);
            if (screenMode.getMonitorMode().getSurfaceSize().getBitsPerPixel() != n) continue;
            arrayList.add(screenMode);
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    public static List filterByRate(List list, int n) {
        if (null == list || list.size() == 0) {
            return null;
        }
        int n2 = n;
        int n3 = -1;
        ArrayList<ScreenMode> arrayList = new ArrayList<ScreenMode>();
        for (int i = 0; null != list && i < list.size(); ++i) {
            ScreenMode screenMode = (ScreenMode)list.get(i);
            int n4 = Math.abs(n - screenMode.getMonitorMode().getRefreshRate());
            if (n4 < n2) {
                n2 = n4;
                n3 = i;
            }
            if (0 != n4) continue;
            arrayList.add(screenMode);
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        n = ((ScreenMode)list.get(n3)).getMonitorMode().getRefreshRate();
        return ScreenModeUtil.filterByRate(list, n);
    }

    public static List getHighestAvailableBpp(List list) {
        if (null == list || list.size() == 0) {
            return null;
        }
        int n = -1;
        for (int i = 0; null != list && i < list.size(); ++i) {
            ScreenMode screenMode = (ScreenMode)list.get(i);
            int n2 = screenMode.getMonitorMode().getSurfaceSize().getBitsPerPixel();
            if (n2 <= n) continue;
            n = n2;
        }
        return ScreenModeUtil.filterByBpp(list, n);
    }

    public static List getHighestAvailableRate(List list) {
        if (null == list || list.size() == 0) {
            return null;
        }
        int n = -1;
        for (int i = 0; null != list && i < list.size(); ++i) {
            ScreenMode screenMode = (ScreenMode)list.get(i);
            int n2 = screenMode.getMonitorMode().getRefreshRate();
            if (n2 <= n) continue;
            n = n2;
        }
        return ScreenModeUtil.filterByRate(list, n);
    }

    public static DimensionReadOnly streamInResolution(int[] nArray, int n) {
        Dimension dimension = new Dimension(nArray[n++], nArray[n++]);
        return dimension;
    }

    public static SurfaceSize streamInSurfaceSize(DimensionReadOnly dimensionReadOnly, int[] nArray, int n) {
        SurfaceSize surfaceSize = new SurfaceSize(dimensionReadOnly, nArray[n++]);
        return surfaceSize;
    }

    public static MonitorMode streamInMonitorMode(SurfaceSize surfaceSize, DimensionReadOnly dimensionReadOnly, int[] nArray, int n) {
        int n2 = nArray[n++];
        return new MonitorMode(surfaceSize, dimensionReadOnly, n2);
    }

    public static ScreenMode streamInScreenMode(MonitorMode monitorMode, int[] nArray, int n) {
        int n2 = nArray[n++];
        return new ScreenMode(monitorMode, n2);
    }

    public static ScreenMode streamIn(int[] nArray, int n) {
        return ScreenModeUtil.streamInImpl(null, null, null, null, null, nArray, n);
    }

    public static int streamIn(ArrayHashSet arrayHashSet, ArrayHashSet arrayHashSet2, ArrayHashSet arrayHashSet3, ArrayHashSet arrayHashSet4, ArrayHashSet arrayHashSet5, int[] nArray, int n) {
        ScreenMode screenMode = ScreenModeUtil.streamInImpl(arrayHashSet, arrayHashSet2, arrayHashSet3, arrayHashSet4, arrayHashSet5, nArray, n);
        return arrayHashSet5.indexOf((Object)screenMode);
    }

    private static ScreenMode streamInImpl(ArrayHashSet arrayHashSet, ArrayHashSet arrayHashSet2, ArrayHashSet arrayHashSet3, ArrayHashSet arrayHashSet4, ArrayHashSet arrayHashSet5, int[] nArray, int n) {
        int n2 = nArray[n];
        if (8 != n2) {
            throw new RuntimeException("NUM_SCREEN_MODE_PROPERTIES should be 8, is " + n2 + ", len " + (nArray.length - n));
        }
        if (8 > nArray.length - n) {
            throw new RuntimeException("properties array too short, should be >= 8, is " + (nArray.length - n));
        }
        DimensionReadOnly dimensionReadOnly = ScreenModeUtil.streamInResolution(nArray, ++n);
        n += 2;
        if (null != arrayHashSet) {
            dimensionReadOnly = (DimensionReadOnly)arrayHashSet.getOrAdd((Object)dimensionReadOnly);
        }
        SurfaceSize surfaceSize = ScreenModeUtil.streamInSurfaceSize(dimensionReadOnly, nArray, n);
        ++n;
        if (null != arrayHashSet2) {
            surfaceSize = (SurfaceSize)arrayHashSet2.getOrAdd((Object)surfaceSize);
        }
        DimensionReadOnly dimensionReadOnly2 = ScreenModeUtil.streamInResolution(nArray, n);
        n += 2;
        if (null != arrayHashSet3) {
            dimensionReadOnly2 = (DimensionReadOnly)arrayHashSet3.getOrAdd((Object)dimensionReadOnly2);
        }
        MonitorMode monitorMode = ScreenModeUtil.streamInMonitorMode(surfaceSize, dimensionReadOnly2, nArray, n);
        ++n;
        if (null != arrayHashSet4) {
            monitorMode = (MonitorMode)arrayHashSet4.getOrAdd((Object)monitorMode);
        }
        ScreenMode screenMode = ScreenModeUtil.streamInScreenMode(monitorMode, nArray, n);
        if (null != arrayHashSet5) {
            screenMode = (ScreenMode)arrayHashSet5.getOrAdd((Object)screenMode);
        }
        return screenMode;
    }

    public static int[] streamOut(ScreenMode screenMode) {
        int[] nArray = new int[8];
        int n = 0;
        nArray[n++] = 8;
        nArray[n++] = screenMode.getMonitorMode().getSurfaceSize().getResolution().getWidth();
        nArray[n++] = screenMode.getMonitorMode().getSurfaceSize().getResolution().getHeight();
        nArray[n++] = screenMode.getMonitorMode().getSurfaceSize().getBitsPerPixel();
        nArray[n++] = screenMode.getMonitorMode().getScreenSizeMM().getWidth();
        nArray[n++] = screenMode.getMonitorMode().getScreenSizeMM().getHeight();
        nArray[n++] = screenMode.getMonitorMode().getRefreshRate();
        nArray[n++] = screenMode.getRotation();
        if (8 != n) {
            throw new InternalError("wrong number of attributes: got " + n + " != should " + 8);
        }
        return nArray;
    }
}

