/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.AbstractLongBuffer;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.Platform;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

final class PointerBufferSE
extends PointerBuffer {
    private Buffer pb;

    PointerBufferSE(ByteBuffer bb) {
        super(bb);
        this.pb = Platform.is32Bit() ? bb.asIntBuffer() : bb.asLongBuffer();
    }

    @Override
    public final long get(int idx) {
        if (0 > idx || idx >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        if (Platform.is32Bit()) {
            return (long)((IntBuffer)this.pb).get(idx) & 0xFFFFFFFFL;
        }
        return ((LongBuffer)this.pb).get(idx);
    }

    @Override
    public final AbstractLongBuffer put(int idx, long v) {
        if (0 > idx || idx >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.backup[idx] = v;
        if (Platform.is32Bit()) {
            ((IntBuffer)this.pb).put(idx, (int)v);
        } else {
            ((LongBuffer)this.pb).put(idx, v);
        }
        return this;
    }
}

