/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.sound.openal.slick;

import de.lessvoid.nifty.sound.openal.slick.AudioImpl;
import de.lessvoid.nifty.sound.openal.slick.OpenALStreamPlayer;
import de.lessvoid.nifty.sound.openal.slick.SoundStore;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

public class StreamSound
extends AudioImpl {
    private Logger log;
    private OpenALStreamPlayer player;
    static /* synthetic */ Class class$0;

    public StreamSound(OpenALStreamPlayer player) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.lessvoid.nifty.sound.openal.slick.StreamSound");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = Logger.getLogger(clazz.getName());
        this.player = player;
    }

    public boolean isPlaying() {
        return SoundStore.get().isPlaying(this.player);
    }

    public int playAsMusic(float pitch, float gain, boolean loop) {
        try {
            this.cleanUpSource();
            this.player.setup(pitch);
            this.player.play(loop);
            SoundStore.get().setStream(this.player);
        }
        catch (IOException e) {
            this.log.warning("Failed to read OGG source: " + this.player.getSource());
        }
        return SoundStore.get().getSource(0);
    }

    private void cleanUpSource() {
        SoundStore store = SoundStore.get();
        AL10.alSourceStop((int)store.getSource(0));
        IntBuffer buffer = BufferUtils.createIntBuffer((int)1);
        int queued = AL10.alGetSourcei((int)store.getSource(0), (int)4117);
        while (queued > 0) {
            AL10.alSourceUnqueueBuffers((int)store.getSource(0), (IntBuffer)buffer);
            --queued;
        }
        AL10.alSourcei((int)store.getSource(0), (int)4105, (int)0);
    }

    public int playAsSoundEffect(float pitch, float gain, boolean loop, float x, float y, float z) {
        return this.playAsMusic(pitch, gain, loop);
    }

    public int playAsSoundEffect(float pitch, float gain, boolean loop) {
        return this.playAsMusic(pitch, gain, loop);
    }

    public void stop() {
        SoundStore.get().setStream(null);
    }

    public boolean setPosition(float position) {
        return this.player.setPosition(position);
    }

    public float getPosition() {
        return this.player.getPosition();
    }
}

