/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.effects.Effect;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProcessor;
import de.lessvoid.nifty.effects.EffectProcessorImpl;
import de.lessvoid.nifty.effects.EffectProcessorNull;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.effects.NiftyRenderDeviceProxy;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.RenderStates;
import de.lessvoid.nifty.spi.time.TimeProvider;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class EffectManager {
    private static final EffectEventId[] effectsRenderOrder = new EffectEventId[]{EffectEventId.onShow, EffectEventId.onHide, EffectEventId.onStartScreen, EffectEventId.onEndScreen, EffectEventId.onCustom, EffectEventId.onActive, EffectEventId.onHover, EffectEventId.onStartHover, EffectEventId.onEndHover, EffectEventId.onFocus, EffectEventId.onLostFocus, EffectEventId.onGetFocus, EffectEventId.onClick, EffectEventId.onEnabled, EffectEventId.onDisabled};
    private static final EffectEventId[] effectsHideShowOrder = new EffectEventId[]{EffectEventId.onStartScreen, EffectEventId.onEndScreen, EffectEventId.onShow, EffectEventId.onHide, EffectEventId.onCustom, EffectEventId.onHover, EffectEventId.onStartHover, EffectEventId.onEndHover, EffectEventId.onFocus, EffectEventId.onLostFocus, EffectEventId.onGetFocus, EffectEventId.onClick};
    private Map<EffectEventId, EffectProcessor> effectProcessor = new EnumMap<EffectEventId, EffectProcessor>(EffectEventId.class);
    private List<EffectProcessor> effectProcessorList = new ArrayList<EffectProcessor>(0);
    private Falloff hoverFalloff;
    private String alternateKey = null;
    private boolean isEmpty = true;
    private Notify notify;
    private static NiftyRenderDeviceProxy renderDeviceProxy = new NiftyRenderDeviceProxy();
    private static RenderPhase renderPhasePre = new RenderPhasePre();
    private static RenderPhase renderPhasePost = new RenderPhasePost();
    private static RenderPhase renderPhaseOverlay = new RenderPhaseOverlay();
    private static EffectProcessorNull effectProcessorNull = new EffectProcessorNull();
    private static RenderStates savedRenderStates = new RenderStates();

    public EffectManager(Notify notify) {
        this.notify = notify;
    }

    public void registerEffect(EffectEventId id, Effect e) {
        EffectProcessor processor = this.effectProcessor.get((Object)id);
        if (processor == null) {
            processor = id.createEffectProcessor(new NotifyAdapter(id, this.notify));
            this.effectProcessor.put(id, processor);
            this.effectProcessorList.add(processor);
        }
        processor.registerEffect(e);
        this.isEmpty = false;
    }

    public void startEffect(EffectEventId id, Element w, TimeProvider time, EndNotify listener) {
        this.getEffectProcessor(id).activate(listener, this.alternateKey, null);
    }

    public void startEffect(EffectEventId id, Element w, TimeProvider time, EndNotify listener, String customKey) {
        this.stopEffect(id);
        this.getEffectProcessor(id).activate(listener, this.alternateKey, customKey);
    }

    public void stopEffect(EffectEventId effectId) {
        this.getEffectProcessor(effectId).setActive(false);
    }

    public void begin(NiftyRenderEngine renderDevice, Element element) {
        savedRenderStates.addAll();
        for (int i = 0; i < this.effectProcessorList.size(); ++i) {
            this.effectProcessorList.get(i).getRenderStatesToSave(renderDeviceProxy);
            savedRenderStates.removeAll(renderDeviceProxy.getStates());
        }
        renderDevice.saveState(savedRenderStates);
    }

    public void end(NiftyRenderEngine renderDevice) {
        renderDevice.restoreState();
    }

    public void renderPre(NiftyRenderEngine renderEngine, Element element) {
        this.renderInternal(element, renderEngine, renderPhasePre);
    }

    public void renderPost(NiftyRenderEngine renderEngine, Element element) {
        this.renderInternal(element, renderEngine, renderPhasePost);
    }

    public void renderOverlay(NiftyRenderEngine renderEngine, Element element) {
        this.renderInternal(element, renderEngine, renderPhaseOverlay);
    }

    private void renderInternal(Element element, NiftyRenderEngine renderEngine, RenderPhase phase) {
        for (int i = 0; i < effectsRenderOrder.length; ++i) {
            phase.render(this.getEffectProcessor(effectsRenderOrder[i]), renderEngine);
        }
    }

    public void handleHover(Element element, int x, int y) {
        this.getEffectProcessor(EffectEventId.onHover).processHover(x, y);
    }

    public void handleHoverStartAndEnd(Element element, int x, int y) {
        EffectProcessor processor = this.getEffectProcessor(EffectEventId.onStartHover);
        processor.processStartHover(x, y);
        processor = this.getEffectProcessor(EffectEventId.onEndHover);
        processor.processEndHover(x, y);
    }

    public void handleHoverDeactivate(Element element, int x, int y) {
        this.getEffectProcessor(EffectEventId.onHover).processHoverDeactivate(x, y);
    }

    public final boolean isActive(EffectEventId effectEventId) {
        return this.getEffectProcessor(effectEventId).isActive();
    }

    public void reset() {
        this.getEffectProcessor(EffectEventId.onStartScreen).reset();
        this.getEffectProcessor(EffectEventId.onEndScreen).reset();
        this.getEffectProcessor(EffectEventId.onShow).reset();
        this.getEffectProcessor(EffectEventId.onHide).reset();
    }

    public void resetAll() {
        for (int i = 0; i < effectsHideShowOrder.length; ++i) {
            this.getEffectProcessor(effectsHideShowOrder[i]).reset();
        }
    }

    public void resetForHide() {
        for (int i = 0; i < effectsHideShowOrder.length; ++i) {
            this.getEffectProcessor(effectsHideShowOrder[i]).saveActiveNeverStopRenderingEffects();
        }
    }

    public void restoreForShow() {
        for (int i = 0; i < effectsHideShowOrder.length; ++i) {
            this.getEffectProcessor(effectsHideShowOrder[i]).restoreNeverStopRenderingEffects();
        }
    }

    public void resetSingleEffect(EffectEventId effectEventId) {
        this.getEffectProcessor(effectEventId).reset();
    }

    public void resetSingleEffect(EffectEventId effectEventId, String customKey) {
        this.getEffectProcessor(effectEventId).reset(customKey);
    }

    public void setAlternateKey(String newAlternateKey) {
        this.alternateKey = newAlternateKey;
    }

    public String getStateString(String offset) {
        StringBuffer data = new StringBuffer();
        int activeProcessors = 0;
        for (EffectEventId eventId : this.effectProcessor.keySet()) {
            EffectProcessor processor = this.getEffectProcessor(eventId);
            if (!processor.isActive()) continue;
            ++activeProcessors;
            data.append(offset);
            data.append("  {" + eventId.toString() + "} ");
            data.append(processor.getStateString());
        }
        if (activeProcessors == 0) {
            return offset + "{}";
        }
        return data.toString();
    }

    public void setFalloff(Falloff newFalloff) {
        this.hoverFalloff = newFalloff;
    }

    public Falloff getFalloff() {
        return this.hoverFalloff;
    }

    public void removeAllEffects() {
        for (int i = 0; i < this.effectProcessorList.size(); ++i) {
            this.effectProcessorList.get(i).removeAllEffects();
        }
        this.isEmpty = true;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public <T extends EffectImpl> List<Effect> getEffects(EffectEventId effectEventId, Class<T> requestedClass) {
        return this.getEffectProcessor(effectEventId).getEffects(requestedClass);
    }

    private EffectProcessor getEffectProcessor(EffectEventId id) {
        EffectProcessor processor = this.effectProcessor.get((Object)id);
        if (processor == null) {
            return effectProcessorNull;
        }
        return processor;
    }

    private class NotifyAdapter
    implements EffectProcessorImpl.Notify {
        private Notify notify;
        private EffectEventId eventId;

        public NotifyAdapter(EffectEventId eventId, Notify notify) {
            this.eventId = eventId;
            this.notify = notify;
        }

        @Override
        public void effectProcessorStateChanged(boolean active) {
            this.notify.effectStateChanged(this.eventId, active);
        }
    }

    public static interface Notify {
        public void effectStateChanged(EffectEventId var1, boolean var2);
    }

    private static final class RenderPhaseOverlay
    implements RenderPhase {
        private RenderPhaseOverlay() {
        }

        @Override
        public void render(EffectProcessor processor, NiftyRenderEngine renderEngine) {
            processor.renderOverlay(renderEngine);
        }
    }

    private static final class RenderPhasePost
    implements RenderPhase {
        private RenderPhasePost() {
        }

        @Override
        public void render(EffectProcessor processor, NiftyRenderEngine renderEngine) {
            processor.renderPost(renderEngine);
        }
    }

    private static final class RenderPhasePre
    implements RenderPhase {
        private RenderPhasePre() {
        }

        @Override
        public void render(EffectProcessor processor, NiftyRenderEngine renderEngine) {
            processor.renderPre(renderEngine);
        }
    }

    static interface RenderPhase {
        public void render(EffectProcessor var1, NiftyRenderEngine var2);
    }
}

