/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.loaderv2.types.helper.PaddingAttributeParser;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.logging.Logger;

public class ColorBar
implements EffectImpl {
    private static Logger log = Logger.getLogger(ColorBar.class.getName());
    private Color color;
    private Color tempColor = new Color("#000f");
    private SizeValue width;
    private SizeValue insetLeft = new SizeValue("0px");
    private SizeValue insetRight = new SizeValue("0px");
    private SizeValue insetTop = new SizeValue("0px");
    private SizeValue insetBottom = new SizeValue("0px");

    @Override
    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.color = new Color(parameter.getProperty("color", "#ffffffff"));
        this.width = new SizeValue(parameter.getProperty("width"));
        try {
            PaddingAttributeParser parser = new PaddingAttributeParser(parameter.getProperty("inset", "0px"));
            this.insetLeft = new SizeValue(parser.getLeft());
            this.insetRight = new SizeValue(parser.getRight());
            this.insetTop = new SizeValue(parser.getTop());
            this.insetBottom = new SizeValue(parser.getBottom());
        }
        catch (Exception e) {
            log.warning(e.getMessage());
        }
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        r.saveState(null);
        if (r.isColorAlphaChanged()) {
            if (falloff == null) {
                r.setColorIgnoreAlpha(this.color);
            } else {
                this.tempColor.mutiply(this.color, falloff.getFalloffValue());
                r.setColorIgnoreAlpha(this.tempColor);
            }
        } else if (falloff == null) {
            r.setColor(this.color);
        } else {
            this.tempColor.mutiply(this.color, falloff.getFalloffValue());
            r.setColor(this.tempColor);
        }
        int insetOffsetLeft = this.insetLeft.getValueAsInt(element.getWidth());
        int insetOffsetRight = this.insetRight.getValueAsInt(element.getWidth());
        int insetOffsetTop = this.insetTop.getValueAsInt(element.getHeight());
        int insetOffsetBottom = this.insetBottom.getValueAsInt(element.getHeight());
        int size = (int)this.width.getValue(element.getParent().getWidth());
        if (size == -1) {
            r.renderQuad(element.getX() + insetOffsetLeft, element.getY() + insetOffsetTop, element.getWidth() - insetOffsetLeft - insetOffsetRight, element.getHeight() - insetOffsetTop - insetOffsetBottom);
        } else {
            r.renderQuad(element.getX() + element.getWidth() / 2 - size / 2 + insetOffsetLeft, element.getY() + insetOffsetTop, size - insetOffsetLeft - insetOffsetRight, element.getHeight() - insetOffsetTop - insetOffsetBottom);
        }
        r.restoreState();
    }

    @Override
    public void deactivate() {
    }
}

