/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.SizeValue;

public class RenderQuad
implements EffectImpl {
    private Color currentColor = new Color("#000f");
    private Color tempColor = new Color("#000f");
    private Color startColor;
    private Color endColor;
    private SizeValue width;

    @Override
    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.startColor = new Color(parameter.getProperty("startColor", "#0000"));
        this.endColor = new Color(parameter.getProperty("endColor", "#ffff"));
        this.width = new SizeValue(parameter.getProperty("width"));
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        r.saveState(null);
        this.currentColor.linear(this.startColor, this.endColor, normalizedTime);
        if (falloff == null) {
            r.setColor(this.currentColor);
        } else {
            this.tempColor.mutiply(this.currentColor, falloff.getFalloffValue());
            r.setColor(this.tempColor);
        }
        int size = (int)this.width.getValue(element.getParent().getWidth());
        if (size == -1) {
            r.renderQuad(element.getX(), element.getY(), element.getWidth(), element.getHeight());
        } else {
            r.renderQuad(element.getX() + element.getWidth() / 2 - size / 2, element.getY(), size, element.getHeight());
        }
        r.restoreState();
    }

    @Override
    public void deactivate() {
    }
}

