/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.macosx.cgl;

import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.ProxySurface;
import jogamp.opengl.GLContextShareSet;
import jogamp.opengl.macosx.cgl.CGL;
import jogamp.opengl.macosx.cgl.MacOSXCGLContext;
import jogamp.opengl.macosx.cgl.MacOSXCGLDrawable;
import jogamp.opengl.macosx.cgl.MacOSXCGLGraphicsConfiguration;

public class MacOSXExternalCGLContext
extends MacOSXCGLContext {
    private boolean firstMakeCurrent = true;
    private GLContext lastContext;

    private MacOSXExternalCGLContext(Drawable drawable, boolean bl, long l) {
        super(drawable, null);
        drawable.setExternalCGLContext(this);
        this.isNSContext = bl;
        this.contextHandle = l;
        GLContextShareSet.contextCreated(this);
        this.setGLFunctionAvailability(false, 0, 0, 34);
        this.getGLStateTracker().setEnabled(false);
    }

    protected static MacOSXExternalCGLContext create(GLDrawableFactory gLDrawableFactory, GLProfile gLProfile) {
        boolean bl;
        long l = 0L;
        long l2 = 0L;
        long l3 = CGL.getCurrentContext();
        boolean bl2 = bl = 0L != l3;
        if (bl) {
            l2 = CGL.getNSView(l3);
            long l4 = CGL.getCGLContext(l3);
            if (l4 == 0L) {
                throw new GLException("Error: NULL Context (CGL) of Context (NS) 0x" + Long.toHexString(l3));
            }
            l = CGL.CGLGetPixelFormat(l4);
            if (DEBUG) {
                System.err.println("MacOSXExternalCGLContext Create Context (NS) 0x" + Long.toHexString(l3) + ", Context (CGL) 0x" + Long.toHexString(l4) + ", pixelFormat 0x" + Long.toHexString(l));
            }
        } else {
            l3 = CGL.CGLGetCurrentContext();
            if (l3 == 0L) {
                throw new GLException("Error: current Context (CGL) null, no Context (NS)");
            }
            l = CGL.CGLGetPixelFormat(l3);
            if (DEBUG) {
                System.err.println("MacOSXExternalCGLContext Create Context (CGL) 0x" + Long.toHexString(l3) + ", pixelFormat 0x" + Long.toHexString(l));
            }
        }
        if (0L == l) {
            throw new GLException("Error: current pixelformat of current Context 0x" + Long.toHexString(l3) + " is null");
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = MacOSXCGLGraphicsConfiguration.CGLPixelFormat2GLCapabilities(gLProfile, l);
        if (DEBUG) {
            System.err.println("MacOSXExternalCGLContext Create " + gLCapabilitiesImmutable);
        }
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault((String)"MacOSX");
        MacOSXCGLGraphicsConfiguration macOSXCGLGraphicsConfiguration = new MacOSXCGLGraphicsConfiguration(abstractGraphicsScreen, gLCapabilitiesImmutable, gLCapabilitiesImmutable, l);
        ProxySurface proxySurface = new ProxySurface((AbstractGraphicsConfiguration)macOSXCGLGraphicsConfiguration);
        proxySurface.setSurfaceHandle(l2);
        return new MacOSXExternalCGLContext(new Drawable(gLDrawableFactory, (NativeSurface)proxySurface), bl, l3);
    }

    @Override
    protected boolean createImpl() throws GLException {
        return true;
    }

    @Override
    public int makeCurrent() throws GLException {
        GLContext gLContext = MacOSXExternalCGLContext.getCurrent();
        if (gLContext != null && gLContext != this) {
            this.lastContext = gLContext;
            MacOSXExternalCGLContext.setCurrent(null);
        }
        return super.makeCurrent();
    }

    @Override
    public void release() throws GLException {
        super.release();
        MacOSXExternalCGLContext.setCurrent(this.lastContext);
        this.lastContext = null;
    }

    @Override
    protected void makeCurrentImpl(boolean bl) throws GLException {
        if (this.firstMakeCurrent) {
            this.firstMakeCurrent = false;
        }
    }

    @Override
    protected void releaseImpl() throws GLException {
    }

    @Override
    protected void destroyImpl() throws GLException {
    }

    @Override
    public void setOpenGLMode(int n) {
        if (n != 2) {
            throw new GLException("OpenGL mode switching not supported for external GLContexts");
        }
    }

    @Override
    public int getOpenGLMode() {
        return 2;
    }

    static class Drawable
    extends MacOSXCGLDrawable {
        MacOSXExternalCGLContext extCtx;

        Drawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
            super(gLDrawableFactory, nativeSurface, true);
        }

        void setExternalCGLContext(MacOSXExternalCGLContext macOSXExternalCGLContext) {
            this.extCtx = macOSXExternalCGLContext;
        }

        @Override
        public GLContext createContext(GLContext gLContext) {
            throw new GLException("Should not call this");
        }

        @Override
        public int getWidth() {
            throw new GLException("Should not call this");
        }

        @Override
        public int getHeight() {
            throw new GLException("Should not call this");
        }

        public void setSize(int n, int n2) {
            throw new GLException("Should not call this");
        }

        @Override
        protected void swapBuffersImpl() {
            if (this.extCtx != null) {
                this.extCtx.swapBuffers();
            }
        }

        @Override
        public void setOpenGLMode(int n) {
            if (n != 2) {
                throw new GLException("OpenGL mode switching not supported for external GLContext's drawables");
            }
        }

        @Override
        public int getOpenGLMode() {
            return 2;
        }
    }
}

