/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render;

import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.image.ImageMode;
import de.lessvoid.nifty.render.image.ImageModeFactory;
import de.lessvoid.nifty.spi.render.RenderImage;
import de.lessvoid.nifty.tools.Color;

public class NiftyImage {
    private RenderImage image;
    private ImageMode imageMode;
    private NiftyRenderEngine niftyRenderEngine;

    public NiftyImage(NiftyRenderEngine niftyRenderEngine, RenderImage createImage) {
        this.niftyRenderEngine = niftyRenderEngine;
        this.image = createImage;
        this.imageMode = ImageModeFactory.getSharedInstance().createImageMode(null, null);
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public void render(int x, int y, int width, int height, Color color, float scale) {
        this.imageMode.render(this.niftyRenderEngine.getRenderDevice(), this.image, x, y, width, height, color, scale);
    }

    public void setImageMode(ImageMode imageMode) {
        this.imageMode = imageMode;
    }

    public void reload() {
        this.image = this.niftyRenderEngine.reload(this.image);
    }

    public void dispose() {
        this.niftyRenderEngine.disposeImage(this.image);
    }
}

