/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.tools;

import de.lessvoid.xml.tools.MethodInvoker;
import de.lessvoid.xml.tools.Split;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpecialValuesReplace {
    private static final String KEY_PROP = "PROP.";
    private static final String KEY_ENV = "ENV.";
    private static final String KEY_CALL = "CALL.";
    private static Logger log = Logger.getLogger(SpecialValuesReplace.class.getName());

    public static String replace(String input, Map<String, ResourceBundle> resourceBundles, Object methodCallTarget, Properties properties) {
        List<String> parts = Split.split(input);
        for (int idx = 0; idx < parts.size(); ++idx) {
            String prev;
            String part = parts.get(idx);
            if (SpecialValuesReplace.isSpecialTag(part, prev = SpecialValuesReplace.getPrev(parts, idx))) {
                String value = SpecialValuesReplace.removeQuotes(part);
                if (value.startsWith(KEY_ENV)) {
                    parts.set(idx, SpecialValuesReplace.handleENV(part));
                    continue;
                }
                if (value.startsWith(KEY_PROP)) {
                    parts.set(idx, SpecialValuesReplace.handleProperties(part, properties));
                    continue;
                }
                if (value.startsWith(KEY_CALL)) {
                    parts.set(idx, SpecialValuesReplace.handleCall(part, methodCallTarget));
                    continue;
                }
                parts.set(idx, SpecialValuesReplace.handleLocalize(part, resourceBundles));
                continue;
            }
            if (!SpecialValuesReplace.endsWithQuote(prev)) continue;
            parts.set(idx - 1, prev.substring(0, prev.length() - 1));
        }
        String result = Split.join(parts);
        if (log.isLoggable(Level.FINER)) {
            log.finer(MessageFormat.format("Parsed input \"{0}\" to \"{1}\"", input, result));
        }
        return result;
    }

    private static boolean endsWithQuote(String prev) {
        return prev != null && prev.endsWith("\\");
    }

    private static String getPrev(List<String> parts, int idx) {
        if (idx == 0) {
            return null;
        }
        return parts.get(idx - 1);
    }

    private static String removeQuotes(String input) {
        return input.substring(2, input.length() - 1);
    }

    private static boolean isSpecialTag(String input, String prev) {
        boolean isSpecialTag;
        boolean bl = isSpecialTag = input != null && input.startsWith("${") && input.endsWith("}");
        if (!isSpecialTag) {
            return false;
        }
        return !SpecialValuesReplace.endsWithQuote(prev);
    }

    private static String handleENV(String value) {
        String env;
        String name = SpecialValuesReplace.removeQuotes(value).substring(KEY_ENV.length());
        if (System.getenv().containsKey(name) && (env = System.getenv().get(name)) != null && env.length() > 0) {
            return env;
        }
        return value;
    }

    private static String handleProperties(String input, Properties properties) {
        String name = SpecialValuesReplace.removeQuotes(input).substring(KEY_PROP.length());
        String value = SpecialValuesReplace.readFromProperties(name, properties);
        if (value == null) {
            value = SpecialValuesReplace.readFromProperties(name, System.getProperties());
        }
        if (value != null) {
            return value;
        }
        return input;
    }

    private static String readFromProperties(String name, Properties properties) {
        String value;
        if (properties != null && properties.containsKey(name) && (value = properties.getProperty(name)) != null && value.length() > 0) {
            return value;
        }
        return null;
    }

    private static String handleCall(String value, Object object) {
        if (object != null) {
            String methodName = SpecialValuesReplace.removeQuotes(value).substring(KEY_CALL.length());
            MethodInvoker methodInvoker = new MethodInvoker(methodName, object);
            Object response = methodInvoker.invoke(new Object[0]);
            if (response != null) {
                return response.toString();
            }
        }
        return value;
    }

    private static String handleLocalize(String value, Map<String, ResourceBundle> resourceBundles) {
        if (value.indexOf(".") != -1) {
            String removedQuotes = SpecialValuesReplace.removeQuotes(value);
            String resourceSelector = removedQuotes.substring(0, removedQuotes.indexOf("."));
            String resourceKey = removedQuotes.substring(removedQuotes.indexOf(".") + 1);
            ResourceBundle res = resourceBundles.get(resourceSelector);
            if (res != null) {
                try {
                    return res.getString(resourceKey);
                }
                catch (MissingResourceException e) {
                    if (log.isLoggable(Level.WARNING)) {
                        log.warning("Missing resource: " + resourceSelector + "." + resourceKey);
                    }
                    return "<" + resourceKey + ">";
                }
            }
        }
        return value;
    }
}

