/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dragndrop;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Draggable;
import de.lessvoid.nifty.controls.DraggableDragCanceledEvent;
import de.lessvoid.nifty.controls.DraggableDragStartedEvent;
import de.lessvoid.nifty.controls.NiftyInputControl;
import de.lessvoid.nifty.controls.dragndrop.DroppableControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.logging.Logger;

public class DraggableControl
extends AbstractController
implements Draggable {
    private static final String POPUP = "draggablePopup";
    private static Logger logger = Logger.getLogger(DraggableControl.class.getName());
    private Nifty nifty;
    private Screen screen;
    private Element draggable;
    private Element originalParent;
    private Element popup;
    private Element handle;
    private boolean revert;
    private boolean dropEnabled;
    private boolean dragged = false;
    private int originalPositionX;
    private int originalPositionY;
    private SizeValue originalConstraintX;
    private SizeValue originalConstraintY;
    private int dragStartX;
    private int dragStartY;
    private DroppableControl droppable;

    public void bind(Nifty nifty, Screen screen, Element element, Properties parameter, Attributes controlDefinitionAttributes) {
        super.bind(element);
        this.nifty = nifty;
        this.screen = screen;
        this.draggable = element;
        String handleId = controlDefinitionAttributes.get("handle");
        this.handle = this.draggable.findElementByName(handleId);
        if (this.handle == null) {
            this.handle = this.draggable;
        }
        this.revert = controlDefinitionAttributes.getAsBoolean("revert", true);
        this.dropEnabled = controlDefinitionAttributes.getAsBoolean("drop", true);
    }

    public void onStartScreen() {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    public void dragStart(int mouseX, int mouseY) {
        if (this.dragged) {
            return;
        }
        this.originalParent = this.draggable.getParent();
        this.originalPositionX = this.draggable.getX();
        this.originalPositionY = this.draggable.getY();
        this.originalConstraintX = this.draggable.getConstraintX();
        this.originalConstraintY = this.draggable.getConstraintY();
        this.dragStartX = mouseX;
        this.dragStartY = mouseY;
        if (this.handle.isMouseInsideElement(mouseX, mouseY)) {
            this.moveDraggableToPopup();
            this.dragged = true;
            this.notifyObserversDragStarted();
        } else {
            this.moveDraggableOnTop();
        }
    }

    public void drag(int mouseX, int mouseY) {
        if (!this.dragged) {
            return;
        }
        int newPositionX = this.originalPositionX + mouseX - this.dragStartX;
        int newPositionY = this.originalPositionY + mouseY - this.dragStartY;
        this.draggable.setConstraintX(new SizeValue(newPositionX + "px"));
        this.draggable.setConstraintY(new SizeValue(newPositionY + "px"));
        this.popup.layoutElements();
    }

    public void dragStop() {
        if (!this.dragged) {
            return;
        }
        logger.fine("dragStop()");
        Element newDroppable = this.findDroppableAtCurrentCoordinates();
        if (newDroppable == this.originalParent) {
            this.dragCancel();
        } else {
            DroppableControl droppableControl = (DroppableControl)newDroppable.getControl(DroppableControl.class);
            if (droppableControl.accept(this.droppable, this)) {
                droppableControl.drop(this, this.closePopup());
            } else {
                this.dragCancel();
            }
        }
        this.dragged = false;
    }

    private void moveDraggableToPopup() {
        this.popup = this.nifty.createPopup(POPUP);
        this.nifty.showPopup(this.screen, this.popup.getId(), null);
        this.draggable.markForMove(this.popup, new EndNotify(){

            public void perform() {
                DraggableControl.this.draggable.getFocusHandler().requestExclusiveMouseFocus(DraggableControl.this.draggable);
                DraggableControl.this.draggable.setConstraintX(new SizeValue(DraggableControl.this.originalPositionX + "px"));
                DraggableControl.this.draggable.setConstraintY(new SizeValue(DraggableControl.this.originalPositionY + "px"));
                DraggableControl.this.draggable.getParent().layoutElements();
            }
        });
    }

    private void moveDraggableOnTop() {
        this.draggable.markForMove(this.originalParent, new EndNotify(){

            public void perform() {
                DraggableControl.this.draggable.reactivate();
            }
        });
    }

    private void dragCancel() {
        if (this.revert) {
            this.draggable.setConstraintX(this.originalConstraintX);
            this.draggable.setConstraintY(this.originalConstraintY);
        } else {
            this.draggable.setConstraintX(new SizeValue(this.draggable.getX() + "px"));
            this.draggable.setConstraintY(new SizeValue(this.draggable.getY() + "px"));
        }
        this.moveDraggableBackToOriginalParent();
        this.notifyObserversDragCanceled();
    }

    private EndNotify closePopup() {
        return new EndNotify(){

            public void perform() {
                DraggableControl.this.nifty.closePopup(DraggableControl.this.popup.getId(), new EndNotify(){

                    public void perform() {
                        DraggableControl.this.draggable.reactivate();
                        DraggableControl.this.popup.markForRemoval(new EndNotify(){

                            public void perform() {
                                DraggableControl.this.popup = null;
                            }
                        });
                    }
                });
            }
        };
    }

    private void moveDraggableBackToOriginalParent() {
        this.draggable.markForMove(this.originalParent, this.closePopup());
    }

    private Element findDroppableAtCurrentCoordinates() {
        if (this.dropEnabled) {
            int dragAnkerX = this.draggable.getX() + this.draggable.getWidth() / 2;
            int dragAnkerY = this.draggable.getY() + this.draggable.getHeight() / 2;
            List layers = this.screen.getLayerElements();
            ListIterator iter = layers.listIterator(layers.size());
            while (iter.hasPrevious()) {
                Element droppable;
                Element layer = (Element)iter.previous();
                if (this.popup == null || layer == this.popup || (droppable = this.findDroppableAtCoordinates(layer, dragAnkerX, dragAnkerY)) == null) continue;
                return droppable;
            }
        }
        return this.originalParent;
    }

    private Element findDroppableAtCoordinates(Element context, int x, int y) {
        List elements = context.getElements();
        ListIterator iter = elements.listIterator(elements.size());
        while (iter.hasPrevious()) {
            boolean mouseInsideAndVisible;
            Element element = (Element)iter.previous();
            boolean bl = mouseInsideAndVisible = element.isMouseInsideElement(x, y) && element.isVisible();
            if (mouseInsideAndVisible && this.isDroppable(element)) {
                return element;
            }
            Element droppable = this.findDroppableAtCoordinates(element, x, y);
            if (droppable == null) continue;
            return droppable;
        }
        return null;
    }

    private boolean isDroppable(Element element) {
        NiftyInputControl control = element.getAttachedInputControl();
        if (control != null) {
            return control.getController() instanceof DroppableControl;
        }
        return false;
    }

    public DroppableControl getDroppable() {
        return this.droppable;
    }

    protected void setDroppable(DroppableControl droppable) {
        this.droppable = droppable;
    }

    private void notifyObserversDragStarted() {
        this.nifty.publishEvent(this.getElement().getId(), (NiftyEvent)new DraggableDragStartedEvent(this.droppable, this));
    }

    private void notifyObserversDragCanceled() {
        this.nifty.publishEvent(this.getElement().getId(), (NiftyEvent)new DraggableDragCanceledEvent(this.droppable, this));
    }
}

