/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.treebox;

import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.treebox.TreeEntryModelClass;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.tools.SizeValue;

public class TreeBoxViewConverter
implements ListBox.ListBoxViewConverter<TreeEntryModelClass> {
    @Override
    public void display(Element listBoxItem, TreeEntryModelClass item) {
        Element spacer = listBoxItem.findElementByName("#tree-item-spacer");
        spacer.setConstraintWidth(new SizeValue(String.valueOf(item.getIndent())));
        spacer.setConstraintHeight(new SizeValue(String.valueOf(item.getTreeItem().getDisplayIconCollapsed().getHeight())));
        Element text = listBoxItem.findElementByName("#tree-item-caption");
        TextRenderer textRenderer = (TextRenderer)text.getRenderer(TextRenderer.class);
        Element icon = listBoxItem.findElementByName("#tree-item-icon");
        ImageRenderer iconRenderer = (ImageRenderer)icon.getRenderer(ImageRenderer.class);
        textRenderer.setText(item.getTreeItem().getDisplayCaption());
        if (item.getTreeItem().isExpanded()) {
            iconRenderer.setImage(item.getTreeItem().getDisplayIconExpanded());
        } else {
            iconRenderer.setImage(item.getTreeItem().getDisplayIconCollapsed());
        }
        if (item.isActiveItem()) {
            text.setStyle("nifty-treebox-item-active");
        } else {
            text.setStyle("nifty-listbox-item");
        }
        icon.setConstraintWidth(new SizeValue(String.valueOf(item.getTreeItem().getDisplayIconCollapsed().getWidth())));
        icon.setConstraintHeight(new SizeValue(String.valueOf(item.getTreeItem().getDisplayIconCollapsed().getHeight())));
    }

    @Override
    public int getWidth(Element element, TreeEntryModelClass item) {
        Element text = element.findElementByName("#tree-item-caption");
        TextRenderer textRenderer = (TextRenderer)text.getRenderer(TextRenderer.class);
        return textRenderer.getFont() == null ? 0 : textRenderer.getFont().getWidth(item.getTreeItem().getDisplayCaption()) + (item.getTreeItem().getDisplayIconCollapsed() == null ? 0 : item.getTreeItem().getDisplayIconCollapsed().getWidth() + item.getIndent());
    }
}

