/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.HashSet;
import org.lwjgl.Display;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GLCaps;
import org.lwjgl.opengl.VBOTracker;

public final class Window {
    private static boolean created;
    private static int x;
    private static int y;
    private static int width;
    private static int height;
    private static String title;
    private static int color;
    private static int alpha;
    private static int depth;
    private static int stencil;
    private static boolean fullscreen;
    private static boolean vsync;
    private static VBOTracker vbo_tracker;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Window() {
    }

    public static int getWidth() {
        if (!$assertionsDisabled && !Window.isCreated()) {
            throw new AssertionError((Object)"Cannot get width on uncreated window");
        }
        return width;
    }

    public static int getHeight() {
        if (!$assertionsDisabled && !Window.isCreated()) {
            throw new AssertionError((Object)"Cannot get height on uncreated window");
        }
        return height;
    }

    public static String getTitle() {
        if (!$assertionsDisabled && !Window.isCreated()) {
            throw new AssertionError((Object)"Cannot get title on uncreated window");
        }
        return title;
    }

    public static boolean isFullscreen() {
        if (!$assertionsDisabled && !Window.isCreated()) {
            throw new AssertionError((Object)"Cannot determine state of uncreated window");
        }
        return fullscreen;
    }

    public static void setTitle(String string) {
        if (!$assertionsDisabled && !Window.isCreated()) {
            throw new AssertionError((Object)"Cannot set title of uncreated window");
        }
        title = string;
        Window.nSetTitle(title);
    }

    private static native void nSetTitle(String var0);

    public static boolean isCloseRequested() {
        if (!$assertionsDisabled && !Window.isCreated()) {
            throw new AssertionError((Object)"Cannot determine state of uncreated window");
        }
        return Window.nIsCloseRequested();
    }

    private static native boolean nIsCloseRequested();

    public static boolean isMinimized() {
        if (!$assertionsDisabled && !Window.isCreated()) {
            throw new AssertionError((Object)"Cannot determine state of uncreated window");
        }
        return Window.nIsMinimized();
    }

    private static native boolean nIsMinimized();

    public static boolean isFocused() {
        if (!$assertionsDisabled && !Window.isCreated()) {
            throw new AssertionError((Object)"Cannot determine state of uncreated window");
        }
        return Window.nIsFocused();
    }

    private static native boolean nIsFocused();

    public static native void minimize();

    public static native void restore();

    public static boolean isDirty() {
        if (!$assertionsDisabled && !Window.isCreated()) {
            throw new AssertionError((Object)"Cannot determine state of uncreated window");
        }
        return Window.nIsDirty();
    }

    private static native boolean nIsDirty();

    public static void paint() {
        if (!$assertionsDisabled && !Window.isCreated()) {
            throw new AssertionError((Object)"Cannot paint uncreated window");
        }
        Window.swapBuffers();
    }

    private static native void swapBuffers();

    public static void create(String string, int n, int n2, int n3, int n4) throws Exception {
        if (Window.isCreated()) {
            throw new Exception("Only one LWJGL window may be instantiated at any one time.");
        }
        x = 0;
        y = 0;
        color = n;
        alpha = n2;
        depth = n3;
        stencil = n4;
        fullscreen = true;
        title = string;
        width = Display.getWidth();
        height = Display.getHeight();
        Window.createWindow();
    }

    public static void create(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws Exception {
        if (Window.isCreated()) {
            throw new Exception("Only one LWJGL window may be instantiated at any one time.");
        }
        x = n;
        y = n2;
        width = n3;
        height = n4;
        color = n5;
        alpha = n6;
        depth = n7;
        stencil = n8;
        fullscreen = false;
        title = string;
        Window.createWindow();
    }

    private static native void nCreate(String var0, int var1, int var2, int var3, int var4, boolean var5, int var6, int var7, int var8, int var9, HashSet var10) throws Exception;

    private static void createWindow() throws Exception {
        HashSet hashSet = new HashSet();
        Window.nCreate(title, x, y, width, height, fullscreen, color, alpha, depth, stencil, hashSet);
        GLCaps.determineAvailableExtensions(hashSet);
        created = true;
    }

    public static void destroy() {
        if (!created) {
            return;
        }
        Window.nDestroy();
        created = false;
    }

    private static native void nDestroy();

    public static boolean isCreated() {
        return created;
    }

    public static native void update();

    public static boolean isVSyncEnabled() {
        if (!$assertionsDisabled && !Window.isCreated()) {
            throw new AssertionError((Object)"Cannot determine sync of uncreated window");
        }
        return Window.nIsVSyncEnabled();
    }

    private static native boolean nIsVSyncEnabled();

    public static void setVSyncEnabled(boolean bl) {
        if (!$assertionsDisabled && !Window.isCreated()) {
            throw new AssertionError((Object)"Cannot set sync of uncreated window");
        }
        Window.nSetVSyncEnabled(bl);
    }

    private static native boolean nSetVSyncEnabled(boolean var0);

    static {
        $assertionsDisabled = !Window.class.desiredAssertionStatus();
        System.loadLibrary(Sys.getLibraryName());
    }
}

