/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.util.ArrayList;
import jme.exception.MonkeyRuntimeException;
import jme.geometry.hud.SplashScreen;
import jme.system.DisplaySystem;
import org.lwjgl.Display;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.Window;

public abstract class AbstractGame {
    private boolean finished;
    private ArrayList splashScreens = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        try {
            this.initSystem();
            if (!Window.isCreated()) {
                throw new MonkeyRuntimeException("Window must be created during initialization.");
            }
            this.showTitle();
            this.initGame();
            while (!this.finished && !Window.isCloseRequested()) {
                this.update();
                this.render();
                Window.paint();
                Window.update();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            this.cleanup();
        }
        Display.resetDisplayMode();
        this.quit();
    }

    public final void showTitle() {
        for (int i = 0; i < this.splashScreens.size(); ++i) {
            GL.glClear((int)16640);
            GL.glLoadIdentity();
            ((SplashScreen)this.splashScreens.get(i)).render();
            Window.paint();
            Window.update();
            ((SplashScreen)this.splashScreens.get(i)).holdDisplay();
        }
    }

    public void resetDisplay(int n, int n2, int n3, int n4, boolean bl, String string) {
        Keyboard.destroy();
        Mouse.destroy();
        DisplaySystem.getDisplaySystem().setAttributes(n, n2, n3, n4, bl, string);
        this.reinit();
    }

    public void addSplashScreen(SplashScreen splashScreen) {
        this.splashScreens.add(splashScreen);
    }

    protected void quit() {
        System.exit(0);
    }

    protected final void finish() {
        this.finished = true;
    }

    protected abstract void update();

    protected abstract void render();

    protected abstract void initSystem();

    protected abstract void initGame();

    protected abstract void reinit();

    protected abstract void cleanup();
}

