/*
 * Decompiled with CFR 0.152.
 */
package jme.entity.camera;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import jme.utility.LoggingSystem;
import org.lwjgl.opengl.GL;

public class Frustum {
    private GL gl;
    private float buffer = 1.0f;
    private float[][] frustum = new float[6][4];
    private float[] proj = new float[16];
    private float[] modl = new float[16];
    private float[] clip = new float[16];
    private FloatBuffer projBuf = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private FloatBuffer modlBuf = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();

    public Frustum() {
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created a frustum.");
    }

    public void update() {
        this.projBuf.clear();
        this.modlBuf.clear();
        GL.glGetFloat((int)2983, (FloatBuffer)this.projBuf);
        this.projBuf.get(this.proj);
        GL.glGetFloat((int)2982, (FloatBuffer)this.modlBuf);
        this.modlBuf.get(this.modl);
        this.clip[0] = this.modl[0] * this.proj[0] + this.modl[1] * this.proj[4] + this.modl[2] * this.proj[8] + this.modl[3] * this.proj[12];
        this.clip[1] = this.modl[0] * this.proj[1] + this.modl[1] * this.proj[5] + this.modl[2] * this.proj[9] + this.modl[3] * this.proj[13];
        this.clip[2] = this.modl[0] * this.proj[2] + this.modl[1] * this.proj[6] + this.modl[2] * this.proj[10] + this.modl[3] * this.proj[14];
        this.clip[3] = this.modl[0] * this.proj[3] + this.modl[1] * this.proj[7] + this.modl[2] * this.proj[11] + this.modl[3] * this.proj[15];
        this.clip[4] = this.modl[4] * this.proj[0] + this.modl[5] * this.proj[4] + this.modl[6] * this.proj[8] + this.modl[7] * this.proj[12];
        this.clip[5] = this.modl[4] * this.proj[1] + this.modl[5] * this.proj[5] + this.modl[6] * this.proj[9] + this.modl[7] * this.proj[13];
        this.clip[6] = this.modl[4] * this.proj[2] + this.modl[5] * this.proj[6] + this.modl[6] * this.proj[10] + this.modl[7] * this.proj[14];
        this.clip[7] = this.modl[4] * this.proj[3] + this.modl[5] * this.proj[7] + this.modl[6] * this.proj[11] + this.modl[7] * this.proj[15];
        this.clip[8] = this.modl[8] * this.proj[0] + this.modl[9] * this.proj[4] + this.modl[10] * this.proj[8] + this.modl[11] * this.proj[12];
        this.clip[9] = this.modl[8] * this.proj[1] + this.modl[9] * this.proj[5] + this.modl[10] * this.proj[9] + this.modl[11] * this.proj[13];
        this.clip[10] = this.modl[8] * this.proj[2] + this.modl[9] * this.proj[6] + this.modl[10] * this.proj[10] + this.modl[11] * this.proj[14];
        this.clip[11] = this.modl[8] * this.proj[3] + this.modl[9] * this.proj[7] + this.modl[10] * this.proj[11] + this.modl[11] * this.proj[15];
        this.clip[12] = this.modl[12] * this.proj[0] + this.modl[13] * this.proj[4] + this.modl[14] * this.proj[8] + this.modl[15] * this.proj[12];
        this.clip[13] = this.modl[12] * this.proj[1] + this.modl[13] * this.proj[5] + this.modl[14] * this.proj[9] + this.modl[15] * this.proj[13];
        this.clip[14] = this.modl[12] * this.proj[2] + this.modl[13] * this.proj[6] + this.modl[14] * this.proj[10] + this.modl[15] * this.proj[14];
        this.clip[15] = this.modl[12] * this.proj[3] + this.modl[13] * this.proj[7] + this.modl[14] * this.proj[11] + this.modl[15] * this.proj[15];
        this.frustum[0][0] = this.clip[3] - this.clip[0];
        this.frustum[0][1] = this.clip[7] - this.clip[4];
        this.frustum[0][2] = this.clip[11] - this.clip[8];
        this.frustum[0][3] = this.clip[15] - this.clip[12];
        float f = (float)Math.sqrt(this.frustum[0][0] * this.frustum[0][0] + this.frustum[0][1] * this.frustum[0][1] + this.frustum[0][2] * this.frustum[0][2]);
        float[] fArray = this.frustum[0];
        fArray[0] = fArray[0] / f;
        float[] fArray2 = this.frustum[0];
        fArray2[1] = fArray2[1] / f;
        float[] fArray3 = this.frustum[0];
        fArray3[2] = fArray3[2] / f;
        float[] fArray4 = this.frustum[0];
        fArray4[3] = fArray4[3] / f;
        this.frustum[1][0] = this.clip[3] + this.clip[0];
        this.frustum[1][1] = this.clip[7] + this.clip[4];
        this.frustum[1][2] = this.clip[11] + this.clip[8];
        this.frustum[1][3] = this.clip[15] + this.clip[12];
        f = (float)Math.sqrt(this.frustum[1][0] * this.frustum[1][0] + this.frustum[1][1] * this.frustum[1][1] + this.frustum[1][2] * this.frustum[1][2]);
        float[] fArray5 = this.frustum[1];
        fArray5[0] = fArray5[0] / f;
        float[] fArray6 = this.frustum[1];
        fArray6[1] = fArray6[1] / f;
        float[] fArray7 = this.frustum[1];
        fArray7[2] = fArray7[2] / f;
        float[] fArray8 = this.frustum[1];
        fArray8[3] = fArray8[3] / f;
        this.frustum[2][0] = this.clip[3] + this.clip[1];
        this.frustum[2][1] = this.clip[7] + this.clip[5];
        this.frustum[2][2] = this.clip[11] + this.clip[9];
        this.frustum[2][3] = this.clip[15] + this.clip[13];
        f = (float)Math.sqrt(this.frustum[2][0] * this.frustum[2][0] + this.frustum[2][1] * this.frustum[2][1] + this.frustum[2][2] * this.frustum[2][2]);
        float[] fArray9 = this.frustum[2];
        fArray9[0] = fArray9[0] / f;
        float[] fArray10 = this.frustum[2];
        fArray10[1] = fArray10[1] / f;
        float[] fArray11 = this.frustum[2];
        fArray11[2] = fArray11[2] / f;
        float[] fArray12 = this.frustum[2];
        fArray12[3] = fArray12[3] / f;
        this.frustum[3][0] = this.clip[3] - this.clip[1];
        this.frustum[3][1] = this.clip[7] - this.clip[5];
        this.frustum[3][2] = this.clip[11] - this.clip[9];
        this.frustum[3][3] = this.clip[15] - this.clip[13];
        f = (float)Math.sqrt(this.frustum[3][0] * this.frustum[3][0] + this.frustum[3][1] * this.frustum[3][1] + this.frustum[3][2] * this.frustum[3][2]);
        float[] fArray13 = this.frustum[3];
        fArray13[0] = fArray13[0] / f;
        float[] fArray14 = this.frustum[3];
        fArray14[1] = fArray14[1] / f;
        float[] fArray15 = this.frustum[3];
        fArray15[2] = fArray15[2] / f;
        float[] fArray16 = this.frustum[3];
        fArray16[3] = fArray16[3] / f;
        this.frustum[4][0] = this.clip[3] - this.clip[2];
        this.frustum[4][1] = this.clip[7] - this.clip[6];
        this.frustum[4][2] = this.clip[11] - this.clip[10];
        this.frustum[4][3] = this.clip[15] - this.clip[14];
        f = (float)Math.sqrt(this.frustum[4][0] * this.frustum[4][0] + this.frustum[4][1] * this.frustum[4][1] + this.frustum[4][2] * this.frustum[4][2]);
        float[] fArray17 = this.frustum[4];
        fArray17[0] = fArray17[0] / f;
        float[] fArray18 = this.frustum[4];
        fArray18[1] = fArray18[1] / f;
        float[] fArray19 = this.frustum[4];
        fArray19[2] = fArray19[2] / f;
        float[] fArray20 = this.frustum[4];
        fArray20[3] = fArray20[3] / f;
        this.frustum[5][0] = this.clip[3] + this.clip[2];
        this.frustum[5][1] = this.clip[7] + this.clip[6];
        this.frustum[5][2] = this.clip[11] + this.clip[10];
        this.frustum[5][3] = this.clip[15] + this.clip[14];
        f = (float)Math.sqrt(this.frustum[5][0] * this.frustum[5][0] + this.frustum[5][1] * this.frustum[5][1] + this.frustum[5][2] * this.frustum[5][2]);
        float[] fArray21 = this.frustum[5];
        fArray21[0] = fArray21[0] / f;
        float[] fArray22 = this.frustum[5];
        fArray22[1] = fArray22[1] / f;
        float[] fArray23 = this.frustum[5];
        fArray23[2] = fArray23[2] / f;
        float[] fArray24 = this.frustum[5];
        fArray24[3] = fArray24[3] / f;
    }

    public boolean containsCube(float f, float f2, float f3, float f4) {
        for (int i = 0; i < 6; ++i) {
            if (this.frustum[i][0] * (f - f4) + this.frustum[i][1] * (f2 - f4) + this.frustum[i][2] * (f3 - f4) + this.frustum[i][3] >= this.buffer - 1.0f || this.frustum[i][0] * (f + f4) + this.frustum[i][1] * (f2 - f4) + this.frustum[i][2] * (f3 - f4) + this.frustum[i][3] >= this.buffer - 1.0f || this.frustum[i][0] * (f - f4) + this.frustum[i][1] * (f2 + f4) + this.frustum[i][2] * (f3 - f4) + this.frustum[i][3] >= this.buffer - 1.0f || this.frustum[i][0] * (f + f4) + this.frustum[i][1] * (f2 + f4) + this.frustum[i][2] * (f3 - f4) + this.frustum[i][3] >= this.buffer - 1.0f || this.frustum[i][0] * (f - f4) + this.frustum[i][1] * (f2 - f4) + this.frustum[i][2] * (f3 + f4) + this.frustum[i][3] >= this.buffer - 1.0f || this.frustum[i][0] * (f + f4) + this.frustum[i][1] * (f2 - f4) + this.frustum[i][2] * (f3 + f4) + this.frustum[i][3] >= this.buffer - 10.0f || this.frustum[i][0] * (f - f4) + this.frustum[i][1] * (f2 + f4) + this.frustum[i][2] * (f3 + f4) + this.frustum[i][3] >= this.buffer - 1.0f || this.frustum[i][0] * (f + f4) + this.frustum[i][1] * (f2 + f4) + this.frustum[i][2] * (f3 + f4) + this.frustum[i][3] >= this.buffer - 1.0f) continue;
            return false;
        }
        return true;
    }

    public boolean containsPoint(float f, float f2, float f3) {
        for (int i = 0; i < 6; ++i) {
            if (!(this.frustum[i][0] * f + this.frustum[i][1] * f2 + this.frustum[i][2] * f3 + this.frustum[i][3] <= this.buffer - 1.0f)) continue;
            return false;
        }
        return true;
    }

    public boolean containsSphere(float f, float f2, float f3, float f4) {
        for (int i = 0; i < 6; ++i) {
            if (!(this.frustum[i][0] * f + this.frustum[i][1] * f2 + this.frustum[i][2] * f3 + this.frustum[i][3] <= -f4 * this.buffer)) continue;
            return false;
        }
        return true;
    }

    public void setBuffer(float f) {
        this.buffer = f;
    }
}

