/*
 * Decompiled with CFR 0.152.
 */
package jme.entity.effects;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import jme.entity.effects.Particle;
import jme.math.Vector;
import jme.texture.TextureManager;
import org.lwjgl.opengl.GL;

public class ParticleEmitter {
    private int numParticles;
    private Particle[] particles;
    private int texId;
    private Vector gravity;
    private Vector position;
    private float speed;
    private float friction;
    private float fade;
    private Vector startSize;
    private Vector endSize;
    private Vector startColor;
    private Vector endColor;
    private boolean isLooping = false;
    private boolean isFirst = true;
    private float[] matrix;
    private FloatBuffer buf;
    private Vector right;
    private Vector up;
    private Vector billboard;

    public ParticleEmitter(int n) {
        this.numParticles = n;
        this.particles = new Particle[n];
        this.startSize = new Vector();
        this.endSize = new Vector();
        this.startColor = new Vector();
        this.endColor = new Vector();
        this.gravity = new Vector();
        this.position = new Vector();
        this.speed = 1.0f;
        this.matrix = new float[16];
        this.buf = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.right = new Vector();
        this.up = new Vector();
        this.billboard = new Vector();
        for (int i = 0; i < n; ++i) {
            this.particles[i] = new Particle();
            this.particles[i].life = -1.0f;
        }
    }

    public void update(float f) {
        float f2 = f * this.speed;
        for (int i = 0; i < this.numParticles; ++i) {
            if (this.particles[i].life <= 0.0f && (this.isLooping || this.isFirst)) {
                this.createParticle(i);
                continue;
            }
            this.particles[i].position.x += this.particles[i].velocity.x / (this.friction * 1000.0f) * f2;
            this.particles[i].position.y += this.particles[i].velocity.y / (this.friction * 1000.0f) * f2;
            this.particles[i].position.z += this.particles[i].velocity.z / (this.friction * 1000.0f) * f2;
            this.particles[i].velocity.x += this.gravity.x * f2;
            this.particles[i].velocity.y += this.gravity.y * f2;
            this.particles[i].velocity.z += this.gravity.z * f2;
            this.particles[i].life -= this.particles[i].fade * f2;
            this.particles[i].color.x = this.startColor.x * this.particles[i].life + this.endColor.x * (1.0f - this.particles[i].life);
            this.particles[i].color.y = this.startColor.y * this.particles[i].life + this.endColor.y * (1.0f - this.particles[i].life);
            this.particles[i].color.z = this.startColor.z * this.particles[i].life + this.endColor.z * (1.0f - this.particles[i].life);
            this.particles[i].size.x = this.startSize.x * this.particles[i].life + this.endSize.x * (1.0f - this.particles[i].life);
            this.particles[i].size.y = this.startSize.y * this.particles[i].life + this.endSize.y * (1.0f - this.particles[i].life);
            this.particles[i].size.z = this.startSize.z * this.particles[i].life + this.endSize.z * (1.0f - this.particles[i].life);
        }
        this.isFirst = false;
    }

    public void render() {
        GL.glPushMatrix();
        GL.glEnable((int)3553);
        GL.glEnable((int)3042);
        GL.glBlendFunc((int)770, (int)1);
        TextureManager.getTextureManager().bind(this.texId);
        GL.glGetFloat((int)2982, (FloatBuffer)this.buf);
        this.buf.rewind();
        this.buf.get(this.matrix);
        this.right.x = this.matrix[0];
        this.right.y = this.matrix[4];
        this.right.z = this.matrix[8];
        this.up.x = this.matrix[1];
        this.up.y = this.matrix[5];
        this.up.z = this.matrix[9];
        for (int i = 0; i < this.numParticles; ++i) {
            GL.glColor4f((float)this.particles[i].color.x, (float)this.particles[i].color.y, (float)this.particles[i].color.z, (float)this.particles[i].life);
            GL.glBegin((int)5);
            GL.glTexCoord2f((float)1.0f, (float)1.0f);
            this.billboard.x = (this.right.x + this.up.x) * this.particles[i].size.x + this.particles[i].position.x;
            this.billboard.y = (this.right.y + this.up.y) * this.particles[i].size.y + this.particles[i].position.y;
            this.billboard.z = (this.right.z + this.up.z) * this.particles[i].size.z + this.particles[i].position.z;
            GL.glVertex3f((float)this.billboard.x, (float)this.billboard.y, (float)this.billboard.z);
            GL.glTexCoord2f((float)0.0f, (float)1.0f);
            this.billboard.x = (this.up.x - this.right.x) * this.particles[i].size.x + this.particles[i].position.x;
            this.billboard.y = (this.up.y - this.right.y) * this.particles[i].size.y + this.particles[i].position.y;
            this.billboard.z = (this.up.z - this.right.z) * this.particles[i].size.z + this.particles[i].position.z;
            GL.glVertex3f((float)this.billboard.x, (float)this.billboard.y, (float)this.billboard.z);
            GL.glTexCoord2f((float)1.0f, (float)0.0f);
            this.billboard.x = (this.right.x - this.up.x) * this.particles[i].size.x + this.particles[i].position.x;
            this.billboard.y = (this.right.y - this.up.y) * this.particles[i].size.y + this.particles[i].position.y;
            this.billboard.z = (this.right.z - this.up.z) * this.particles[i].size.z + this.particles[i].position.z;
            GL.glVertex3f((float)this.billboard.x, (float)this.billboard.y, (float)this.billboard.z);
            GL.glTexCoord2f((float)0.0f, (float)0.0f);
            this.billboard.x = (this.right.x + this.up.x) * -this.particles[i].size.x + this.particles[i].position.x;
            this.billboard.y = (this.right.y + this.up.y) * -this.particles[i].size.y + this.particles[i].position.y;
            this.billboard.z = (this.right.z + this.up.z) * -this.particles[i].size.z + this.particles[i].position.z;
            GL.glVertex3f((float)this.billboard.x, (float)this.billboard.y, (float)this.billboard.z);
            GL.glEnd();
        }
        GL.glDisable((int)3553);
        GL.glDisable((int)3042);
        GL.glPopMatrix();
    }

    public void setFriction(float f) {
        this.friction = f;
    }

    public void setEndColor(Vector vector) {
        this.endColor = vector;
    }

    public void setEndSize(Vector vector) {
        this.endSize = vector;
    }

    public void setGravity(Vector vector) {
        this.gravity = vector;
    }

    public void setStartColor(Vector vector) {
        this.startColor = vector;
    }

    public void setStartSize(Vector vector) {
        this.startSize = vector;
    }

    public void setFade(float f) {
        this.fade = f;
    }

    public void setPosition(Vector vector) {
        this.position = vector;
    }

    public void setSpeed(float f) {
        this.speed = f;
    }

    public void setTexture(String string) {
        this.texId = TextureManager.getTextureManager().loadTexture(string, 9987, 9729, true);
    }

    public void loopAnimation(boolean bl) {
        this.isLooping = bl;
    }

    private void createParticle(int n) {
        this.particles[n].life = 1.0f;
        this.particles[n].fade = (float)((double)this.fade * Math.random() + (double)this.fade);
        this.particles[n].position.x = this.position.x;
        this.particles[n].position.y = this.position.y;
        this.particles[n].position.z = this.position.z;
        this.particles[n].velocity.x = ((float)(Math.random() * 32767.0) % 50.0f - 26.0f) * 10.0f;
        this.particles[n].velocity.y = ((float)(Math.random() * 32767.0) % 50.0f - 26.0f) * 10.0f;
        this.particles[n].velocity.z = ((float)(Math.random() * 32767.0) % 50.0f - 26.0f) * 10.0f;
        this.particles[n].color.x = this.startColor.x;
        this.particles[n].color.y = this.startColor.y;
        this.particles[n].color.z = this.startColor.z;
        this.particles[n].size.x = this.startSize.x;
        this.particles[n].size.y = this.startSize.y;
        this.particles[n].size.z = this.startSize.z;
    }
}

