/*
 * Decompiled with CFR 0.152.
 */
package jme.geometry.hud.text;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import jme.exception.MonkeyRuntimeException;
import jme.texture.TextureManager;
import jme.utility.LoggingSystem;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.Window;

public class Font2D {
    public static final int NORMAL = 0;
    public static final int ITALICS = 1;
    private int texId;
    private int base;
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private float alpha = 1.0f;
    private boolean isBlended = true;

    public Font2D(String string) {
        if (!Window.isCreated()) {
            throw new MonkeyRuntimeException("Window must be created before Font2D.");
        }
        this.setFontTexture(string);
        this.buildDisplayList();
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Successfully created Font2D using " + string);
    }

    public void setFontTexture(String string) {
        this.texId = TextureManager.getTextureManager().loadTexture(string, 9729, 9729, false);
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.red = f;
        this.green = f2;
        this.blue = f3;
        this.alpha = f4;
    }

    public void deleteFont() {
        GL.glDeleteLists((int)this.base, (int)256);
    }

    public void print(int n, int n2, String string, int n3) {
        if (n3 > 1) {
            n3 = 1;
        } else if (n3 < 0) {
            n3 = 0;
        }
        TextureManager.getTextureManager().bind(this.texId);
        if (this.isBlended) {
            GL.glEnable((int)3042);
        }
        GL.glDisable((int)2929);
        GL.glEnable((int)3553);
        GL.glMatrixMode((int)5889);
        GL.glPushMatrix();
        GL.glLoadIdentity();
        GL.glOrtho((double)0.0, (double)Window.getWidth(), (double)0.0, (double)Window.getHeight(), (double)-1.0, (double)1.0);
        GL.glMatrixMode((int)5888);
        GL.glPushMatrix();
        GL.glLoadIdentity();
        GL.glTranslatef((float)n, (float)n2, (float)0.0f);
        GL.glListBase((int)(this.base - 32 + 128 * n3));
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(string.getBytes().length).order(ByteOrder.nativeOrder());
        byteBuffer.put(string.getBytes());
        byteBuffer.flip();
        GL.glColor4f((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
        GL.glCallLists((ByteBuffer)byteBuffer);
        if (this.isBlended) {
            GL.glDisable((int)3042);
        }
        GL.glMatrixMode((int)5889);
        GL.glPopMatrix();
        GL.glMatrixMode((int)5888);
        GL.glPopMatrix();
        GL.glEnable((int)2929);
        GL.glDisable((int)3553);
    }

    public void buildDisplayList() {
        this.base = GL.glGenLists((int)256);
        TextureManager.getTextureManager().bind(this.texId);
        for (int i = 0; i < 256; ++i) {
            float f = (float)(i % 16) / 16.0f;
            float f2 = (float)(i / 16) / 16.0f;
            GL.glNewList((int)(this.base + i), (int)4864);
            GL.glBegin((int)7);
            GL.glTexCoord2f((float)f, (float)(1.0f - f2 - 0.0625f));
            GL.glVertex2i((int)0, (int)0);
            GL.glTexCoord2f((float)(f + 0.0625f), (float)(1.0f - f2 - 0.0625f));
            GL.glVertex2i((int)16, (int)0);
            GL.glTexCoord2f((float)(f + 0.0625f), (float)(1.0f - f2));
            GL.glVertex2i((int)16, (int)16);
            GL.glTexCoord2f((float)f, (float)(1.0f - f2));
            GL.glVertex2i((int)0, (int)16);
            GL.glEnd();
            GL.glTranslatef((float)10.0f, (float)0.0f, (float)0.0f);
            GL.glEndList();
        }
    }

    public String toString() {
        String string = super.toString();
        string = string + "\nColor: " + this.red + " " + this.green + " " + this.blue + " " + this.alpha;
        string = string + "\nBlended: " + this.isBlended;
        string = string + "\nTexture: " + this.texId;
        return string;
    }
}

