/*
 * Decompiled with CFR 0.152.
 */
package jme.geometry.primitive;

import java.util.logging.Level;
import jme.exception.MonkeyGLException;
import jme.exception.MonkeyRuntimeException;
import jme.geometry.primitive.Primitive;
import jme.math.Vector;
import jme.texture.TextureManager;
import jme.utility.LoggingSystem;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.Window;

public class Pyramid
extends Primitive {
    private boolean usingDisplay;
    private int listId;
    private float base;
    private float height;
    private GL gl;
    private Vector[] points;

    public Pyramid(float f, float f2) {
        if (f < 0.0f || f2 < 0.0f) {
            throw new MonkeyRuntimeException("Neither base nor height can be negative.");
        }
        if (!Window.isCreated()) {
            throw new MonkeyGLException("Window must be created before Pyramid.");
        }
        this.base = f;
        this.height = f2;
        this.initialize();
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created Pyramid.");
    }

    public void setBase(float f) {
        if (f < 0.0f) {
            throw new MonkeyRuntimeException("Base may not be negative.");
        }
        this.base = f;
    }

    public void setHeight(float f) {
        if (f < 0.0f) {
            throw new MonkeyRuntimeException("Height may not be negative.");
        }
        this.height = f;
    }

    public void useDisplayList(boolean bl) {
        if (bl) {
            this.listId = GL.glGenLists((int)1);
            GL.glNewList((int)this.listId, (int)4864);
            this.renderPyramid();
            GL.glEndList();
            this.usingDisplay = true;
        } else {
            this.usingDisplay = false;
        }
    }

    public void render() {
        if (this.usingDisplay) {
            GL.glCallList((int)this.listId);
        } else {
            this.renderPyramid();
        }
    }

    public void initialize() {
        if (this.height > this.base) {
            float f = this.height;
        } else {
            float f = this.base;
        }
        this.points = new Vector[5];
        this.points[0] = new Vector(-this.base / 2.0f, -this.height / 2.0f, -this.base / 2.0f);
        this.points[1] = new Vector(this.base / 2.0f, -this.height / 2.0f, -this.base / 2.0f);
        this.points[2] = new Vector(this.base / 2.0f, -this.height / 2.0f, this.base / 2.0f);
        this.points[3] = new Vector(-this.base / 2.0f, -this.height / 2.0f, this.base / 2.0f);
        this.points[4] = new Vector(0.0f, this.height / 2.0f, 0.0f);
    }

    public void preRender() {
    }

    private void renderPyramid() {
        if (this.getTextureId() > 0) {
            TextureManager.getTextureManager().bind(this.getTextureId());
            GL.glEnable((int)3553);
        }
        GL.glColor4f((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
        GL.glBegin((int)4);
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)this.points[0].x, (float)this.points[0].y, (float)this.points[0].z);
        GL.glTexCoord2f((float)0.5f, (float)1.0f);
        GL.glVertex3f((float)this.points[4].x, (float)this.points[4].y, (float)this.points[4].z);
        GL.glTexCoord2f((float)0.75f, (float)0.0f);
        GL.glVertex3f((float)this.points[1].x, (float)this.points[1].y, (float)this.points[1].z);
        GL.glTexCoord2f((float)0.75f, (float)0.0f);
        GL.glVertex3f((float)this.points[1].x, (float)this.points[1].y, (float)this.points[1].z);
        GL.glTexCoord2f((float)0.5f, (float)1.0f);
        GL.glVertex3f((float)this.points[4].x, (float)this.points[4].y, (float)this.points[4].z);
        GL.glTexCoord2f((float)0.5f, (float)0.0f);
        GL.glVertex3f((float)this.points[2].x, (float)this.points[2].y, (float)this.points[2].z);
        GL.glTexCoord2f((float)0.5f, (float)0.0f);
        GL.glVertex3f((float)this.points[2].x, (float)this.points[2].y, (float)this.points[2].z);
        GL.glTexCoord2f((float)0.5f, (float)1.0f);
        GL.glVertex3f((float)this.points[4].x, (float)this.points[4].y, (float)this.points[4].z);
        GL.glTexCoord2f((float)0.25f, (float)0.0f);
        GL.glVertex3f((float)this.points[3].x, (float)this.points[3].y, (float)this.points[3].z);
        GL.glTexCoord2f((float)0.25f, (float)0.0f);
        GL.glVertex3f((float)this.points[3].x, (float)this.points[3].y, (float)this.points[3].z);
        GL.glTexCoord2f((float)0.5f, (float)1.0f);
        GL.glVertex3f((float)this.points[4].x, (float)this.points[4].y, (float)this.points[4].z);
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)this.points[0].x, (float)this.points[0].y, (float)this.points[0].z);
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)this.points[0].x, (float)this.points[0].y, (float)this.points[0].z);
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)this.points[2].x, (float)this.points[2].y, (float)this.points[2].z);
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)this.points[3].x, (float)this.points[3].y, (float)this.points[3].z);
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)this.points[0].x, (float)this.points[0].y, (float)this.points[0].z);
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)this.points[1].x, (float)this.points[1].y, (float)this.points[1].z);
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)this.points[2].x, (float)this.points[2].y, (float)this.points[2].z);
        GL.glEnd();
        if (this.getTextureId() > 0) {
            GL.glDisable((int)3553);
        }
    }

    public Vector[] getPoints() {
        return this.points;
    }
}

