/*
 * Decompiled with CFR 0.152.
 */
package jme.locale.external.data;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import jme.exception.MonkeyRuntimeException;
import jme.locale.external.data.AbstractHeightMap;
import jme.utility.LoggingSystem;

public class RawHeightMap
extends AbstractHeightMap {
    private String filename;

    public RawHeightMap(String string, int n) {
        if (null == string || n <= 0) {
            throw new MonkeyRuntimeException("Must supply valid filename and size (> 0)");
        }
        if (!string.endsWith(".raw")) {
            throw new MonkeyRuntimeException("Height data must be RAW format");
        }
        this.filename = string;
        this.size = n;
        this.load();
    }

    public boolean load() {
        if (null == this.filename || this.size <= 0) {
            throw new MonkeyRuntimeException("Must supply valid filename and size (> 0)");
        }
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new int[this.size][this.size];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.filename);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    this.heightData[i][j] = dataInputStream.readUnsignedByte();
                }
            }
            dataInputStream.close();
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Heightmap file" + this.filename + " not found.");
            return false;
        }
        catch (IOException iOException) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Error reading data from " + this.filename);
            return false;
        }
        LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Successfully loaded " + this.filename);
        return true;
    }

    public void setFilename(String string) {
        if (null == string) {
            throw new MonkeyRuntimeException("Must supply valid filename");
        }
        if (null == string || this.size <= 0) {
            throw new MonkeyRuntimeException("Must supply valid filename and size (> 0)");
        }
        this.filename = string;
    }
}

