/*
 * Decompiled with CFR 0.152.
 */
package jme.locale.external.feature;

import java.util.logging.Level;
import jme.exception.MonkeyRuntimeException;
import jme.locale.external.feature.Water;
import jme.texture.TextureManager;
import jme.utility.LoggingSystem;
import org.lwjgl.opengl.GL;

public class WaterMesh
implements Water {
    private int texId;
    private float height;
    private int size;
    private int spacing;
    private float[][] water;
    private float[][] wt;
    private float amplitude;
    private int dx = 0;
    private int dy = 0;
    private int v;

    public WaterMesh(int n, int n2, float f) {
        this.water = new float[n][n];
        this.wt = new float[n][n];
        this.v = -4;
        if (n < 0) {
            throw new MonkeyRuntimeException("Size cannot be negative.");
        }
        this.size = n;
        this.spacing = n2;
        this.amplitude = f;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.water[i][j] = (float)(2.0 * Math.sin((double)((float)i * 180.0f) / Math.PI));
                this.wt[i][j] = 0.0f;
            }
        }
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "WaterMesh created.");
    }

    public void setTexture(String string) {
        this.texId = TextureManager.getTextureManager().loadTexture(string, 9987, 9729, true);
    }

    public void setBaseHeight(float f) {
        this.height = f;
    }

    public void setOrigin(int n, int n2) {
        this.dx = n;
        this.dy = n2;
    }

    public void setWindSpeed(int n) {
        this.v = n * 10;
    }

    public void update(float f) {
        float f2 = 0.1f;
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                float f3 = (float)Math.sqrt((j - this.dx) * (j - this.dx) + (i - this.dy) * (i - this.dy));
                float[] fArray = this.wt[i];
                int n = j;
                fArray[n] = fArray[n] + 0.1f;
                float f4 = f3 / (float)this.v;
                this.water[i][j] = (float)((double)this.amplitude * Math.sin(Math.PI * 2 * (double)f2 * (double)(this.wt[i][j] + f4)));
            }
        }
    }

    public void render() {
        GL.glEnable((int)3042);
        GL.glEnable((int)3553);
        GL.glEnable((int)2929);
        GL.glDisable((int)2884);
        TextureManager.getTextureManager().bind(this.texId);
        GL.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        GL.glBegin((int)4);
        float f = 1.0f / (float)this.size;
        for (int i = 0; i < this.size - 1; ++i) {
            float f2 = (float)i / (float)this.size;
            for (int j = 0; j < this.size - 1; ++j) {
                float f3 = (float)j / (float)this.size;
                GL.glTexCoord2f((float)f2, (float)f3);
                GL.glVertex3f((float)(this.spacing * i), (float)(this.water[i][j] + this.height), (float)(this.spacing * j));
                GL.glTexCoord2f((float)(f2 + f), (float)f3);
                GL.glVertex3f((float)(this.spacing * (i + 1)), (float)(this.water[i + 1][j] + this.height), (float)(this.spacing * j));
                GL.glTexCoord2f((float)(f2 + f), (float)(f3 + f));
                GL.glVertex3f((float)(this.spacing * (i + 1)), (float)(this.water[i + 1][j + 1] + this.height), (float)(this.spacing * (j + 1)));
                GL.glTexCoord2f((float)f2, (float)(f3 + f));
                GL.glVertex3f((float)(this.spacing * i), (float)(this.water[i][j + 1] + this.height), (float)(this.spacing * (j + 1)));
                GL.glTexCoord2f((float)f2, (float)f3);
                GL.glVertex3f((float)(this.spacing * i), (float)(this.water[i][j] + this.height), (float)(this.spacing * j));
                GL.glTexCoord2f((float)(f2 + f), (float)(f3 + f));
                GL.glVertex3f((float)(this.spacing * (i + 1)), (float)(this.water[i + 1][j + 1] + this.height), (float)(this.spacing * (j + 1)));
            }
        }
        GL.glEnd();
        GL.glDisable((int)3042);
        GL.glDisable((int)3553);
        GL.glDisable((int)2929);
        GL.glEnable((int)2884);
    }
}

