/*
 * Decompiled with CFR 0.152.
 */
package jme.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jme.exception.MonkeyRuntimeException;
import jme.system.PropertiesIO;
import org.lwjgl.Display;
import org.lwjgl.DisplayMode;

public class PropertiesDialog
extends JDialog {
    private PropertiesIO source = null;
    String imageFile = null;
    private JCheckBox fullscreenBox = null;
    private JComboBox displayCombo = null;
    private boolean done = false;

    public PropertiesDialog(PropertiesIO propertiesIO, String string) {
        if (null == propertiesIO) {
            throw new MonkeyRuntimeException("PropertyIO source cannot be null");
        }
        this.source = propertiesIO;
        this.imageFile = string;
        this.init();
    }

    public boolean isDone() {
        return this.done;
    }

    private void init() {
        this.setTitle("Select Display Settings");
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JButton jButton = new JButton("Ok");
        JButton jButton2 = new JButton("Cancel");
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JLabel(new ImageIcon(this.imageFile)), "North");
        this.displayCombo = this.setUpChooser();
        jPanel3.add(this.displayCombo);
        this.fullscreenBox = new JCheckBox("Fullscreen?");
        this.fullscreenBox.setSelected(this.source.getFullscreen());
        jPanel3.add(this.fullscreenBox);
        jPanel2.add((Component)jPanel3, "South");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesDialog.this.saveCurrentSelection();
                PropertiesDialog.this.dispose();
                PropertiesDialog.this.done = true;
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesDialog.this.dispose();
                System.exit(0);
            }
        });
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "South");
        this.getContentPane().add(jPanel);
        this.pack();
        int n = (Toolkit.getDefaultToolkit().getScreenSize().width - this.getWidth()) / 2;
        int n2 = (Toolkit.getDefaultToolkit().getScreenSize().height - this.getHeight()) / 2;
        this.setLocation(n, n2);
        this.show();
        this.toFront();
    }

    private void saveCurrentSelection() {
        String string = (String)this.displayCombo.getSelectedItem();
        int n = Integer.parseInt(string.substring(0, string.indexOf("x")));
        string = string.substring(string.indexOf("x") + 1);
        int n2 = Integer.parseInt(string.substring(0, string.indexOf("x")));
        string = string.substring(string.indexOf("x") + 1);
        int n3 = Integer.parseInt(string.substring(0, string.indexOf("x")));
        string = string.substring(string.indexOf("x") + 1);
        int n4 = Integer.parseInt(string);
        boolean bl = this.fullscreenBox.isSelected();
        this.source.save(n, n2, n3, n4, bl);
    }

    private JComboBox setUpChooser() {
        TreeSet<String> treeSet = new TreeSet<String>();
        DisplayMode[] displayModeArray = Display.getAvailableDisplayModes();
        JComboBox jComboBox = new JComboBox();
        for (int i = 0; i < displayModeArray.length; ++i) {
            String string = displayModeArray[i].width + "x" + displayModeArray[i].height + "x" + displayModeArray[i].bpp + "x" + displayModeArray[i].freq;
            if (treeSet.contains(string)) continue;
            treeSet.add(string);
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            jComboBox.addItem(iterator.next());
        }
        jComboBox.setSelectedItem(this.source.getWidth() + "x" + this.source.getHeight() + "x" + this.source.getDepth() + "x" + this.source.getFreq());
        return jComboBox;
    }
}

