/*
 * Decompiled with CFR 0.152.
 */
package jme.texture;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import jme.exception.MonkeyRuntimeException;
import jme.locale.external.data.AbstractHeightMap;
import jme.utility.LoggingSystem;

public class ProceduralTexture {
    private ImageIcon proceduralTexture;
    private AbstractHeightMap heightMap;
    private ArrayList textureList = new ArrayList();
    private int size;

    public ProceduralTexture(AbstractHeightMap abstractHeightMap) {
        this.heightMap = abstractHeightMap;
        this.size = abstractHeightMap.getSize();
    }

    public void createTexture(int n) {
        BufferedImage bufferedImage = new BufferedImage(n, n, 1);
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float f = (float)this.size / (float)n;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5;
                for (n5 = 0; n5 < this.textureList.size(); ++n5) {
                    BufferedImage bufferedImage2 = ((TextureTile)this.textureList.get((int)n5)).imageData;
                    dataBufferInt = (DataBufferInt)bufferedImage2.getRaster().getDataBuffer();
                    nArray = dataBufferInt.getData();
                    int n6 = i % bufferedImage2.getWidth();
                    int n7 = j % bufferedImage2.getHeight();
                    float f2 = this.getTextureScale(this.interpolateHeight(i, j, f), n5);
                    n2 = (int)((float)n2 + f2 * (float)((nArray[n7 * bufferedImage2.getWidth() + n6] & 0xFF0000) >> 16));
                    n3 = (int)((float)n3 + f2 * (float)((nArray[n7 * bufferedImage2.getWidth() + n6] & 0xFF00) >> 8));
                    n4 = (int)((float)n4 + f2 * (float)(nArray[n7 * bufferedImage2.getWidth() + n6] & 0xFF));
                }
                n5 = n2 << 16 | n3 << 8 | n4;
                bufferedImage.setRGB(i, n - (j + 1), n5);
                n2 = 0;
                n3 = 0;
                n4 = 0;
            }
        }
        this.proceduralTexture = new ImageIcon(bufferedImage);
        this.proceduralTexture.setDescription("TerrainTexture");
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created procedural texture successfully.");
    }

    public boolean saveTexture(String string) {
        if (null == string) {
            throw new MonkeyRuntimeException("Screenshot filename cannot be null");
        }
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Taking screenshot: " + string + ".png");
        BufferedImage bufferedImage = (BufferedImage)this.proceduralTexture.getImage();
        try {
            File file = new File(string + ".png");
            return ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Could not create file: " + string + ".png");
            return false;
        }
    }

    public void addTexture(ImageIcon imageIcon, int n, int n2, int n3) {
        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(imageIcon.getImage(), null, null);
        graphics2D.dispose();
        TextureTile textureTile = new TextureTile();
        textureTile.highHeight = n3;
        textureTile.optimalHeight = n2;
        textureTile.lowHeight = n;
        textureTile.imageData = bufferedImage;
        this.textureList.add(textureTile);
    }

    public void setHeightMap(AbstractHeightMap abstractHeightMap) {
        if (null == abstractHeightMap) {
            throw new MonkeyRuntimeException("Heightmap cannot be null");
        }
        this.heightMap = abstractHeightMap;
    }

    public ImageIcon getImageIcon() {
        return this.proceduralTexture;
    }

    private float getTextureScale(int n, int n2) {
        TextureTile textureTile = (TextureTile)this.textureList.get(n2);
        if (n < textureTile.optimalHeight && n > textureTile.lowHeight) {
            return (float)(n - textureTile.lowHeight) / (float)(textureTile.optimalHeight - textureTile.lowHeight);
        }
        if (n > textureTile.optimalHeight && n < textureTile.highHeight) {
            return (float)(textureTile.highHeight - n) / (float)(textureTile.highHeight - textureTile.optimalHeight);
        }
        if (n == textureTile.optimalHeight) {
            return 1.0f;
        }
        return 0.0f;
    }

    private int interpolateHeight(int n, int n2, float f) {
        float f2 = (float)n * f;
        float f3 = (float)n2 * f;
        int n3 = this.heightMap.getTrueHeightAtPoint((int)f2, (int)f3);
        if (f2 + 1.0f >= (float)this.size) {
            return n3;
        }
        int n4 = this.heightMap.getTrueHeightAtPoint((int)f2 + 1, (int)f3);
        float f4 = f2 - (float)((int)f2);
        float f5 = (float)(n4 - n3) * f4 + (float)n3;
        if (f3 + 1.0f >= (float)this.size) {
            return n3;
        }
        int n5 = this.heightMap.getTrueHeightAtPoint((int)f2, (int)f3 + 1);
        f4 = f3 - (float)((int)f3);
        float f6 = (float)(n5 - n3) * f4 + (float)n3;
        return (int)((f5 + f6) / 2.0f);
    }

    private class TextureTile {
        public BufferedImage imageData;
        public int lowHeight;
        public int optimalHeight;
        public int highHeight;

        private TextureTile() {
        }
    }
}

