/*
 * Decompiled with CFR 0.152.
 */
package test.polygon;

import jme.AbstractGame;
import jme.geometry.hud.text.Font2D;
import jme.geometry.primitive.Triangle;
import jme.math.Vector;
import jme.system.DisplaySystem;
import jme.utility.Timer;
import org.lwjgl.Display;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLU;
import org.lwjgl.opengl.Window;

public class TestPolygon
extends AbstractGame {
    private Timer timer;
    private Font2D font;
    private Triangle triangle;
    private Vector[] points;

    protected void update() {
        this.timer.getFrameRate();
        this.timer.update();
    }

    protected void render() {
        GL.glClear((int)16640);
        GL.glLoadIdentity();
        GL.glEnable((int)3553);
        this.triangle.render();
        this.font.print(1, 1, "Frame Rate - " + this.timer.getFrameRate(), 0);
    }

    protected void initDisplay() {
        DisplaySystem.createDisplaySystem("TestPolygon", "data/Images/Monkey.jpg", true);
    }

    protected void initGL() {
        GL.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL.glMatrixMode((int)5889);
        GL.glLoadIdentity();
        GLU.gluPerspective((double)45.0, (double)((float)Display.getWidth() / (float)Display.getHeight()), (double)0.01f, (double)750.0);
        GL.glMatrixMode((int)5888);
        GL.glHint((int)3152, (int)4354);
    }

    protected void initSystem() {
        this.initDisplay();
        this.initGL();
    }

    protected void initGame() {
        GL.glBlendFunc((int)770, (int)1);
        this.font = new Font2D("data/Font/font.png");
        this.timer = Timer.getTimer();
        this.points = new Vector[3];
        int i = 0;
        while (i < 3) {
            this.points[i] = new Vector();
            ++i;
        }
        this.points[0].x = 0.0f;
        this.points[0].y = 1.0f;
        this.points[0].z = -5.0f;
        this.points[1].x = -1.0f;
        this.points[1].y = -1.0f;
        this.points[1].z = -5.0f;
        this.points[2].x = 1.0f;
        this.points[2].y = -1.0f;
        this.points[2].z = -5.0f;
        this.triangle = new Triangle(this.points);
        this.triangle.setTexture("data/texture/Wood.bmp");
    }

    protected void reinit() {
    }

    protected void cleanup() {
        Window.destroy();
    }

    public static void main(String[] args) {
        TestPolygon testPoly = new TestPolygon();
        testPoly.start();
    }
}

