/*
 * Copyright (c) 2003, jMonkeyEngine - Mojo Monkey Coding
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this 
 * list of conditions and the following disclaimer. 
 * 
 * Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 
 * Neither the name of the Mojo Monkey Coding, jME, jMonkey Engine, nor the 
 * names of its contributors may be used to endorse or promote products derived 
 * from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package jme.geometry.primitive;

import org.lwjgl.opengl.GL;

import jme.texture.TextureManager;

/**
 * <code>Quadric</code> extends <code>Primitive</code> to include
 * Quadric features of the OpenGL Utilities library. 
 * 
 * @author Mark Powell
 * @version 1
 */
public abstract class Quadric extends Primitive {
    
	/**
	 * a pointer to the quadric object returned from a call to
	 * gluNewQuadric().
	 */
	protected int quadricPointer;

	/**
     * <code>render</code> is an abstract method that should handle the
     * displaying of the geometry data.
     */
	public abstract void render();
	
	/**
	 * <code>initialize</code> should be called during the creation of the
	 * subclass geometry. This creates a new quadric object.
	 */
	public void initialize() {
		//quadricPointer = DisplaySystem.getDisplaySystem().getGLU().newQuadric();
	}

	/**
	 * <code>preRender</code> should be called prior to any <code>render</code>
	 * call. This sets up the texture if appropriate and sets the color values.
	 */
	public void preRender() {
		if (getTextureId() > 0) {
			//DisplaySystem.getDisplaySystem().getGL().enable(GL.TEXTURE_2D);
			TextureManager.getTextureManager().bind(getTextureId());
//			DisplaySystem.getDisplaySystem().getGLU().quadricTexture(
//				quadricPointer,
//				true);
		}
		GL.glColor4f(
			red,
			green,
			blue,
			alpha);
	}

}
