/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.android;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import com.jme3.input.RawInputListener;
import com.jme3.input.TouchInput;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.input.event.TouchEvent;
import com.jme3.math.Vector2f;
import com.jme3.util.RingBuffer;
import java.util.HashMap;
import java.util.logging.Logger;

public class AndroidInput
extends GLSurfaceView
implements TouchInput,
GestureDetector.OnGestureListener,
ScaleGestureDetector.OnScaleGestureListener {
    private static final int MAX_EVENTS = 1024;
    public boolean mouseEventsEnabled = true;
    public boolean mouseEventsInvertX = false;
    public boolean mouseEventsInvertY = false;
    public boolean keyboardEventsEnabled = false;
    public boolean dontSendHistory = false;
    private final RingBuffer<TouchEvent> eventQueue = new RingBuffer(1024);
    private final RingBuffer<TouchEvent> eventPoolUnConsumed = new RingBuffer(1024);
    private final RingBuffer<TouchEvent> eventPool = new RingBuffer(1024);
    private final HashMap<Integer, Vector2f> lastPositions = new HashMap();
    private ScaleGestureDetector scaledetector;
    private GestureDetector detector = new GestureDetector((GestureDetector.OnGestureListener)this);
    private int lastX;
    private int lastY;
    private static final Logger logger = Logger.getLogger(AndroidInput.class.getName());
    private boolean isInitialized = false;
    private RawInputListener listener = null;
    private static final int[] ANDROID_TO_JME = new int[]{0, 0, 0, 199, 1, 0, 0, 11, 2, 3, 4, 5, 6, 7, 8, 9, 10, 55, 0, 200, 208, 203, 205, 28, 0, 0, 222, 0, 0, 30, 48, 46, 32, 18, 33, 34, 35, 23, 36, 37, 38, 50, 49, 24, 25, 16, 19, 31, 20, 22, 47, 17, 45, 21, 44, 51, 52, 56, 184, 42, 54, 15, 57, 0, 0, 0, 28, 211, 41, 12, 13, 26, 27, 43, 39, 40, 53, 145, 69, 0, 0, 78, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public AndroidInput(Context ctx, AttributeSet attribs) {
        super(ctx, attribs);
        this.scaledetector = new ScaleGestureDetector(ctx, (ScaleGestureDetector.OnScaleGestureListener)this);
    }

    public AndroidInput(Context ctx) {
        super(ctx);
        this.scaledetector = new ScaleGestureDetector(ctx, (ScaleGestureDetector.OnScaleGestureListener)this);
    }

    private TouchEvent getNextFreeTouchEvent() {
        return this.getNextFreeTouchEvent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TouchEvent getNextFreeTouchEvent(boolean wait) {
        TouchEvent evt = null;
        RingBuffer<TouchEvent> ringBuffer = this.eventPoolUnConsumed;
        synchronized (ringBuffer) {
            for (int size = this.eventPoolUnConsumed.size(); size > 0 && !(evt = this.eventPoolUnConsumed.pop()).isConsumed(); --size) {
                this.eventPoolUnConsumed.push(evt);
                evt = null;
            }
        }
        if (evt == null) {
            if (this.eventPool.isEmpty() && wait) {
                boolean isEmpty;
                logger.warning("eventPool buffer underrun");
                do {
                    RingBuffer<TouchEvent> size = this.eventPool;
                    synchronized (size) {
                        isEmpty = this.eventPool.isEmpty();
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                } while (isEmpty);
                RingBuffer<TouchEvent> ringBuffer2 = this.eventPool;
                synchronized (ringBuffer2) {
                    evt = this.eventPool.pop();
                }
            }
            if (this.eventPool.isEmpty()) {
                evt = new TouchEvent();
                logger.warning("eventPool buffer underrun");
            } else {
                ringBuffer = this.eventPool;
                synchronized (ringBuffer) {
                    evt = this.eventPool.pop();
                }
            }
        }
        return evt;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean bWasHandled = false;
        this.detector.onTouchEvent(event);
        this.scaledetector.onTouchEvent(event);
        int historySize = event.getHistorySize();
        int pointerCount = event.getPointerCount();
        switch (event.getAction()) {
            case 0: {
                TouchEvent touch;
                if (!this.dontSendHistory) {
                    for (int h = 0; h < historySize; ++h) {
                        for (int p = 0; p < pointerCount; ++p) {
                            touch = this.getNextFreeTouchEvent();
                            touch.set(TouchEvent.Type.DOWN, event.getHistoricalX(p, h), (float)this.getHeight() - event.getHistoricalY(p, h), 0.0f, 0.0f);
                            touch.setPointerId(event.getPointerId(p));
                            touch.setTime(event.getHistoricalEventTime(h));
                            touch.setPressure(event.getHistoricalPressure(p, h));
                            this.processEvent(touch);
                        }
                    }
                }
                for (int p = 0; p < pointerCount; ++p) {
                    touch = this.getNextFreeTouchEvent();
                    touch.set(TouchEvent.Type.DOWN, event.getX(p), (float)this.getHeight() - event.getY(p), 0.0f, 0.0f);
                    touch.setPointerId(event.getPointerId(p));
                    touch.setTime(event.getEventTime());
                    touch.setPressure(event.getPressure(p));
                    this.processEvent(touch);
                    Vector2f lastPos = this.lastPositions.get(event.getPointerId(p));
                    if (lastPos == null) {
                        lastPos = new Vector2f(event.getX(p), (float)this.getHeight() - event.getY(p));
                        this.lastPositions.put(event.getPointerId(p), lastPos);
                    }
                    lastPos.set(event.getX(p), (float)this.getHeight() - event.getY(p));
                }
                bWasHandled = true;
                break;
            }
            case 1: {
                TouchEvent touch;
                if (!this.dontSendHistory) {
                    for (int h = 0; h < historySize; ++h) {
                        for (int p = 0; p < pointerCount; ++p) {
                            touch = this.getNextFreeTouchEvent();
                            touch.set(TouchEvent.Type.UP, event.getHistoricalX(p, h), (float)this.getHeight() - event.getHistoricalY(p, h), 0.0f, 0.0f);
                            touch.setPointerId(event.getPointerId(p));
                            touch.setTime(event.getHistoricalEventTime(h));
                            touch.setPressure(event.getHistoricalPressure(p, h));
                            this.processEvent(touch);
                        }
                    }
                }
                for (int p = 0; p < pointerCount; ++p) {
                    touch = this.getNextFreeTouchEvent();
                    touch.set(TouchEvent.Type.UP, event.getX(p), (float)this.getHeight() - event.getY(p), 0.0f, 0.0f);
                    touch.setPointerId(event.getPointerId(p));
                    touch.setTime(event.getEventTime());
                    touch.setPressure(event.getPressure(p));
                    this.processEvent(touch);
                }
                bWasHandled = true;
                break;
            }
            case 2: {
                TouchEvent touch;
                if (!this.dontSendHistory) {
                    for (int h = 0; h < historySize; ++h) {
                        for (int p = 0; p < pointerCount; ++p) {
                            Vector2f lastPos = this.lastPositions.get(event.getPointerId(p));
                            if (lastPos == null) {
                                lastPos = new Vector2f(event.getHistoricalX(p, h), (float)this.getHeight() - event.getHistoricalY(p, h));
                                this.lastPositions.put(event.getPointerId(p), lastPos);
                            }
                            touch = this.getNextFreeTouchEvent();
                            touch.set(TouchEvent.Type.MOVE, event.getHistoricalX(p, h), (float)this.getHeight() - event.getHistoricalY(p, h), event.getHistoricalX(p, h) - lastPos.x, (float)this.getHeight() - event.getHistoricalY(p, h) - lastPos.y);
                            touch.setPointerId(event.getPointerId(p));
                            touch.setTime(event.getHistoricalEventTime(h));
                            touch.setPressure(event.getHistoricalPressure(p, h));
                            this.processEvent(touch);
                            lastPos.set(event.getHistoricalX(p, h), (float)this.getHeight() - event.getHistoricalY(p, h));
                        }
                    }
                }
                for (int p = 0; p < event.getPointerCount(); ++p) {
                    Vector2f lastPos = this.lastPositions.get(event.getPointerId(p));
                    if (lastPos == null) {
                        lastPos = new Vector2f(event.getX(p), (float)this.getHeight() - event.getY(p));
                        this.lastPositions.put(event.getPointerId(p), lastPos);
                    }
                    touch = this.getNextFreeTouchEvent();
                    touch.set(TouchEvent.Type.MOVE, event.getX(p), (float)this.getHeight() - event.getY(p), event.getX(p) - lastPos.x, (float)this.getHeight() - event.getY(p) - lastPos.y);
                    touch.setPointerId(event.getPointerId(p));
                    touch.setTime(event.getEventTime());
                    touch.setPressure(event.getPressure(p));
                    this.processEvent(touch);
                    lastPos.set(event.getX(p), (float)this.getHeight() - event.getY(p));
                }
                bWasHandled = true;
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
        }
        return bWasHandled;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        TouchEvent evt = this.getNextFreeTouchEvent();
        evt.set(TouchEvent.Type.KEY_DOWN);
        evt.setKeyCode(keyCode);
        evt.setCharacters(event.getCharacters());
        evt.setTime(event.getEventTime());
        this.processEvent(evt);
        return keyCode != 24 && keyCode != 25 && keyCode != 82 && keyCode != 4;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        TouchEvent evt = this.getNextFreeTouchEvent();
        evt.set(TouchEvent.Type.KEY_UP);
        evt.setKeyCode(keyCode);
        evt.setCharacters(event.getCharacters());
        evt.setTime(event.getEventTime());
        this.processEvent(evt);
        return keyCode != 24 && keyCode != 25 && keyCode != 82 && keyCode != 4;
    }

    @Override
    public void initialize() {
        for (int i = 0; i < 1024; ++i) {
            TouchEvent item = new TouchEvent();
            this.eventPool.push(item);
        }
        this.isInitialized = true;
    }

    @Override
    public void destroy() {
        this.isInitialized = false;
        while (!this.eventPool.isEmpty()) {
            this.eventPool.pop();
        }
        while (!this.eventQueue.isEmpty()) {
            this.eventQueue.pop();
        }
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
    }

    @Override
    public long getInputTimeNanos() {
        return System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(TouchEvent event) {
        RingBuffer<TouchEvent> ringBuffer = this.eventQueue;
        synchronized (ringBuffer) {
            this.eventQueue.push(event);
        }
    }

    @Override
    public void update() {
        this.generateEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateEvents() {
        if (this.listener != null) {
            while (!this.eventQueue.isEmpty()) {
                TouchEvent event;
                RingBuffer<TouchEvent> ringBuffer = this.eventQueue;
                synchronized (ringBuffer) {
                    event = this.eventQueue.pop();
                }
                if (event != null) {
                    this.listener.onTouchEvent(event);
                    if (this.mouseEventsEnabled) {
                        int newX = this.mouseEventsInvertX ? this.getWidth() - (int)event.getX() : (int)event.getX();
                        int newY = this.mouseEventsInvertY ? this.getHeight() - (int)event.getY() : (int)event.getY();
                        switch (event.getType()) {
                            case DOWN: {
                                MouseButtonEvent btn = new MouseButtonEvent(0, true, newX, newY);
                                btn.setTime(event.getTime());
                                this.listener.onMouseButtonEvent(btn);
                                this.lastX = -1;
                                this.lastY = -1;
                                break;
                            }
                            case UP: {
                                MouseButtonEvent btn = new MouseButtonEvent(0, false, newX, newY);
                                btn.setTime(event.getTime());
                                this.listener.onMouseButtonEvent(btn);
                                this.lastX = -1;
                                this.lastY = -1;
                                break;
                            }
                            case MOVE: {
                                int dy;
                                int dx;
                                if (this.lastX != -1) {
                                    dx = newX - this.lastX;
                                    dy = newY - this.lastY;
                                } else {
                                    dx = 0;
                                    dy = 0;
                                }
                                MouseMotionEvent mot = new MouseMotionEvent(newX, newY, dx, dy, 0, 0);
                                mot.setTime(event.getTime());
                                this.listener.onMouseMotionEvent(mot);
                                this.lastX = newX;
                                this.lastY = newY;
                            }
                        }
                    }
                }
                if (!event.isConsumed()) {
                    ringBuffer = this.eventPoolUnConsumed;
                    synchronized (ringBuffer) {
                        this.eventPoolUnConsumed.push(event);
                        continue;
                    }
                }
                ringBuffer = this.eventPool;
                synchronized (ringBuffer) {
                    this.eventPool.push(event);
                }
            }
        }
    }

    public boolean onDown(MotionEvent event) {
        return false;
    }

    public void onLongPress(MotionEvent event) {
        TouchEvent touch = this.getNextFreeTouchEvent();
        touch.set(TouchEvent.Type.LONGPRESSED, event.getX(), (float)this.getHeight() - event.getY(), 0.0f, 0.0f);
        touch.setPointerId(0);
        touch.setTime(event.getEventTime());
        this.processEvent(touch);
    }

    public boolean onFling(MotionEvent event, MotionEvent event2, float vx, float vy) {
        TouchEvent touch = this.getNextFreeTouchEvent();
        touch.set(TouchEvent.Type.FLING, event.getX(), (float)this.getHeight() - event.getY(), vx, vy);
        touch.setPointerId(0);
        touch.setTime(event.getEventTime());
        this.processEvent(touch);
        return true;
    }

    public boolean onSingleTapConfirmed(MotionEvent event) {
        TouchEvent touch = this.getNextFreeTouchEvent();
        touch.set(TouchEvent.Type.TAP, event.getX(), (float)this.getHeight() - event.getY(), 0.0f, 0.0f);
        touch.setPointerId(0);
        touch.setTime(event.getEventTime());
        this.processEvent(touch);
        return true;
    }

    public boolean onDoubleTap(MotionEvent event) {
        TouchEvent touch = this.getNextFreeTouchEvent();
        touch.set(TouchEvent.Type.DOUBLETAP, event.getX(), (float)this.getHeight() - event.getY(), 0.0f, 0.0f);
        touch.setPointerId(0);
        touch.setTime(event.getEventTime());
        this.processEvent(touch);
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
        TouchEvent touch = this.getNextFreeTouchEvent();
        touch.set(TouchEvent.Type.SCALE_START, scaleGestureDetector.getFocusX(), scaleGestureDetector.getFocusY(), 0.0f, 0.0f);
        touch.setPointerId(0);
        touch.setTime(scaleGestureDetector.getEventTime());
        touch.setScaleSpan(scaleGestureDetector.getCurrentSpan());
        touch.setScaleFactor(scaleGestureDetector.getScaleFactor());
        this.processEvent(touch);
        return true;
    }

    public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
        TouchEvent touch = this.getNextFreeTouchEvent();
        touch.set(TouchEvent.Type.SCALE_MOVE, scaleGestureDetector.getFocusX(), (float)this.getHeight() - scaleGestureDetector.getFocusY(), 0.0f, 0.0f);
        touch.setPointerId(0);
        touch.setTime(scaleGestureDetector.getEventTime());
        touch.setScaleSpan(scaleGestureDetector.getCurrentSpan());
        touch.setScaleFactor(scaleGestureDetector.getScaleFactor());
        this.processEvent(touch);
        return false;
    }

    public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
        TouchEvent touch = this.getNextFreeTouchEvent();
        touch.set(TouchEvent.Type.SCALE_END, scaleGestureDetector.getFocusX(), (float)this.getHeight() - scaleGestureDetector.getFocusY(), 0.0f, 0.0f);
        touch.setPointerId(0);
        touch.setTime(scaleGestureDetector.getEventTime());
        touch.setScaleSpan(scaleGestureDetector.getCurrentSpan());
        touch.setScaleFactor(scaleGestureDetector.getScaleFactor());
        this.processEvent(touch);
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        TouchEvent touch = this.getNextFreeTouchEvent();
        touch.set(TouchEvent.Type.SCROLL, e1.getX(), (float)this.getHeight() - e1.getY(), distanceX, distanceY * -1.0f);
        touch.setPointerId(0);
        touch.setTime(e1.getEventTime());
        this.processEvent(touch);
        return false;
    }

    public void onShowPress(MotionEvent event) {
        TouchEvent touch = this.getNextFreeTouchEvent();
        touch.set(TouchEvent.Type.SHOWPRESS, event.getX(), (float)this.getHeight() - event.getY(), 0.0f, 0.0f);
        touch.setPointerId(0);
        touch.setTime(event.getEventTime());
        this.processEvent(touch);
    }

    public boolean onSingleTapUp(MotionEvent event) {
        TouchEvent touch = this.getNextFreeTouchEvent();
        touch.set(TouchEvent.Type.TAP, event.getX(), (float)this.getHeight() - event.getY(), 0.0f, 0.0f);
        touch.setPointerId(0);
        touch.setTime(event.getEventTime());
        this.processEvent(touch);
        return true;
    }

    @Override
    public void setSimulateMouse(boolean simulate) {
        this.mouseEventsEnabled = simulate;
    }

    @Override
    public void setSimulateKeyboard(boolean simulate) {
        this.keyboardEventsEnabled = simulate;
    }

    @Override
    public void setOmitHistoricEvents(boolean dontSendHistory) {
        this.dontSendHistory = dontSendHistory;
    }

    public boolean isMouseEventsEnabled() {
        return this.mouseEventsEnabled;
    }

    public void setMouseEventsEnabled(boolean mouseEventsEnabled) {
        this.mouseEventsEnabled = mouseEventsEnabled;
    }

    public boolean isMouseEventsInvertY() {
        return this.mouseEventsInvertY;
    }

    public void setMouseEventsInvertY(boolean mouseEventsInvertY) {
        this.mouseEventsInvertY = mouseEventsInvertY;
    }

    public boolean isMouseEventsInvertX() {
        return this.mouseEventsInvertX;
    }

    public void setMouseEventsInvertX(boolean mouseEventsInvertX) {
        this.mouseEventsInvertX = mouseEventsInvertX;
    }
}

