/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.file;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.DnaBlockData;
import com.jme3.scene.plugins.blender.file.Structure;

public class FileBlockHeader {
    public static final int BLOCK_TE00 = 0x54450000;
    public static final int BLOCK_ME00 = 1296367616;
    public static final int BLOCK_SR00 = 1397882880;
    public static final int BLOCK_CA00 = 1128333312;
    public static final int BLOCK_LA00 = 1279328256;
    public static final int BLOCK_OB00 = 1329725440;
    public static final int BLOCK_MA00 = 1296105472;
    public static final int BLOCK_SC00 = 1396899840;
    public static final int BLOCK_WO00 = 1464795136;
    public static final int BLOCK_TX00 = 1415053312;
    public static final int BLOCK_IP00 = 1229979648;
    public static final int BLOCK_AC00 = 1094909952;
    public static final int BLOCK_GLOB = 1196183362;
    public static final int BLOCK_REND = 1380273732;
    public static final int BLOCK_DATA = 0x44415441;
    public static final int BLOCK_DNA1 = 1145979185;
    public static final int BLOCK_ENDB = 1162757186;
    private int code;
    private int size;
    private long oldMemoryAddress;
    private int sdnaIndex;
    private int count;
    private int blockPosition;

    public FileBlockHeader(BlenderInputStream inputStream, BlenderContext blenderContext) throws BlenderFileException {
        inputStream.alignPosition(4);
        this.code = inputStream.readByte() << 24 | inputStream.readByte() << 16 | inputStream.readByte() << 8 | inputStream.readByte();
        this.size = inputStream.readInt();
        this.oldMemoryAddress = inputStream.readPointer();
        this.sdnaIndex = inputStream.readInt();
        this.count = inputStream.readInt();
        this.blockPosition = inputStream.getPosition();
        if (1145979185 == this.code) {
            blenderContext.setBlockData(new DnaBlockData(inputStream, blenderContext));
        } else {
            inputStream.setPosition(this.blockPosition + this.size);
            blenderContext.addFileBlockHeader(this.oldMemoryAddress, this);
        }
    }

    public Structure getStructure(BlenderContext blenderContext) throws BlenderFileException {
        blenderContext.getInputStream().setPosition(this.blockPosition);
        Structure structure = blenderContext.getDnaBlockData().getStructure(this.sdnaIndex);
        structure.fill(blenderContext.getInputStream());
        return structure;
    }

    public int getCode() {
        return this.code;
    }

    public int getSize() {
        return this.size;
    }

    public int getSdnaIndex() {
        return this.sdnaIndex;
    }

    public int getCount() {
        return this.count;
    }

    public int getBlockPosition() {
        return this.blockPosition;
    }

    public boolean isLastBlock() {
        return 1162757186 == this.code;
    }

    public boolean isDnaBlock() {
        return 1145979185 == this.code;
    }

    public String toString() {
        return "FILE BLOCK HEADER [" + this.codeToString(this.code) + " : " + this.size + " : " + this.oldMemoryAddress + " : " + this.sdnaIndex + " : " + this.count + "]";
    }

    protected String codeToString(int code) {
        char c1 = (char)((code & 0xFF000000) >> 24);
        char c2 = (char)((code & 0xFF0000) >> 16);
        char c3 = (char)((code & 0xFF00) >> 8);
        char c4 = (char)(code & 0xFF);
        return String.valueOf(c1) + c2 + c3 + c4;
    }
}

