/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorBand {
    private static final Logger LOGGER = Logger.getLogger(ColorBand.class.getName());
    public static final int IPO_LINEAR = 0;
    public static final int IPO_EASE = 1;
    public static final int IPO_BSPLINE = 2;
    public static final int IPO_CARDINAL = 3;
    public static final int IPO_CONSTANT = 4;
    private int cursorsAmount;
    private int ipoType;
    private ColorBandData[] data;

    public ColorBand(Structure tex, BlenderContext blenderContext) {
        int flag = ((Number)tex.getFieldValue("flag")).intValue();
        if ((flag & 1) != 0) {
            Pointer pColorband = (Pointer)tex.getFieldValue("coba");
            try {
                Structure colorbandStructure = pColorband.fetchData(blenderContext.getInputStream()).get(0);
                this.cursorsAmount = ((Number)colorbandStructure.getFieldValue("tot")).intValue();
                this.ipoType = ((Number)colorbandStructure.getFieldValue("ipotype")).intValue();
                this.data = new ColorBandData[this.cursorsAmount];
                DynamicArray data = (DynamicArray)colorbandStructure.getFieldValue("data");
                for (int i = 0; i < this.cursorsAmount; ++i) {
                    this.data[i] = new ColorBandData((Structure)data.get(i));
                }
            }
            catch (BlenderFileException e) {
                LOGGER.log(Level.WARNING, "Cannot fetch the colorband structure. The reason: {0}", e.getLocalizedMessage());
            }
        }
    }

    public boolean hasTransparencies() {
        if (this.data != null) {
            for (ColorBandData colorBandData : this.data) {
                if (!(colorBandData.a < 1.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public float[][] computeValues() {
        float[][] result = null;
        if (this.data != null) {
            result = new float[1001][4];
            if (this.data.length == 1) {
                for (int i = 0; i < result.length; ++i) {
                    result[i][0] = this.data[0].r;
                    result[i][1] = this.data[0].g;
                    result[i][2] = this.data[0].b;
                    result[i][3] = this.data[0].a;
                }
            } else {
                int currentCursor = 0;
                ColorBandData currentData = this.data[0];
                ColorBandData nextData = this.data[0];
                switch (this.ipoType) {
                    case 0: {
                        float rDiff = 0.0f;
                        float gDiff = 0.0f;
                        float bDiff = 0.0f;
                        float aDiff = 0.0f;
                        for (int i = 0; i < result.length; ++i) {
                            float posDiff = i - currentData.pos;
                            result[i][0] = currentData.r + rDiff * posDiff;
                            result[i][1] = currentData.g + gDiff * posDiff;
                            result[i][2] = currentData.b + bDiff * posDiff;
                            result[i][3] = currentData.a + aDiff * posDiff;
                            if (nextData.pos != i) continue;
                            currentData = this.data[currentCursor++];
                            if (currentCursor < this.data.length) {
                                nextData = this.data[currentCursor];
                                int d = nextData.pos - currentData.pos;
                                rDiff = (nextData.r - currentData.r) / (float)d;
                                gDiff = (nextData.g - currentData.g) / (float)d;
                                bDiff = (nextData.b - currentData.b) / (float)d;
                                aDiff = (nextData.a - currentData.a) / (float)d;
                                continue;
                            }
                            aDiff = 0.0f;
                            bDiff = 0.0f;
                            gDiff = 0.0f;
                            rDiff = 0.0f;
                        }
                        break;
                    }
                    case 2: 
                    case 3: {
                        TreeMap<Integer, ColorBandData> cbDataMap = new TreeMap<Integer, ColorBandData>();
                        for (int i = 0; i < this.data.length; ++i) {
                            cbDataMap.put(i, this.data[i]);
                        }
                        if (this.data[0].pos == 0) {
                            cbDataMap.put(-1, this.data[0]);
                        } else {
                            ColorBandData cbData = this.data[0].clone();
                            cbData.pos = 0;
                            cbDataMap.put(-1, cbData);
                            cbDataMap.put(-2, cbData);
                        }
                        if (this.data[this.data.length - 1].pos == 1000) {
                            cbDataMap.put(this.data.length, this.data[this.data.length - 1]);
                        } else {
                            ColorBandData cbData = this.data[this.data.length - 1].clone();
                            cbData.pos = 1000;
                            cbDataMap.put(this.data.length, cbData);
                            cbDataMap.put(this.data.length + 1, cbData);
                        }
                        float[] ipoFactors = new float[4];
                        ColorBandData data0 = this.getColorbandData(currentCursor - 2, cbDataMap);
                        ColorBandData data1 = this.getColorbandData(currentCursor - 1, cbDataMap);
                        ColorBandData data2 = this.getColorbandData(currentCursor, cbDataMap);
                        ColorBandData data3 = this.getColorbandData(currentCursor + 1, cbDataMap);
                        for (int i = 0; i < result.length; ++i) {
                            float f;
                            if (data2.pos != data1.pos) {
                                f = (float)(i - data2.pos) / (float)(data1.pos - data2.pos);
                                f = FastMath.clamp(f, 0.0f, 1.0f);
                            } else {
                                f = 0.0f;
                            }
                            this.getIpoData(f, ipoFactors);
                            result[i][0] = ipoFactors[3] * data0.r + ipoFactors[2] * data1.r + ipoFactors[1] * data2.r + ipoFactors[0] * data3.r;
                            result[i][1] = ipoFactors[3] * data0.g + ipoFactors[2] * data1.g + ipoFactors[1] * data2.g + ipoFactors[0] * data3.g;
                            result[i][2] = ipoFactors[3] * data0.b + ipoFactors[2] * data1.b + ipoFactors[1] * data2.b + ipoFactors[0] * data3.b;
                            result[i][3] = ipoFactors[3] * data0.a + ipoFactors[2] * data1.a + ipoFactors[1] * data2.a + ipoFactors[0] * data3.a;
                            result[i][0] = FastMath.clamp(result[i][0], 0.0f, 1.0f);
                            result[i][1] = FastMath.clamp(result[i][1], 0.0f, 1.0f);
                            result[i][2] = FastMath.clamp(result[i][2], 0.0f, 1.0f);
                            result[i][3] = FastMath.clamp(result[i][3], 0.0f, 1.0f);
                            if (nextData.pos != i) continue;
                            data0 = (ColorBandData)cbDataMap.get(++currentCursor - 2);
                            data1 = (ColorBandData)cbDataMap.get(currentCursor - 1);
                            data2 = (ColorBandData)cbDataMap.get(currentCursor);
                            data3 = (ColorBandData)cbDataMap.get(currentCursor + 1);
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < result.length; ++i) {
                            float b;
                            float a;
                            float d;
                            if (nextData.pos != currentData.pos) {
                                d = (float)(i - currentData.pos) / (float)(nextData.pos - currentData.pos);
                                float d2 = d * d;
                                a = 3.0f * d2 - 2.0f * d * d2;
                                b = 1.0f - a;
                            } else {
                                a = 0.0f;
                                d = 0.0f;
                                b = 1.0f;
                            }
                            result[i][0] = b * currentData.r + a * nextData.r;
                            result[i][1] = b * currentData.g + a * nextData.g;
                            result[i][2] = b * currentData.b + a * nextData.b;
                            result[i][3] = b * currentData.a + a * nextData.a;
                            if (nextData.pos != i) continue;
                            currentData = this.data[currentCursor++];
                            if (currentCursor >= this.data.length) continue;
                            nextData = this.data[currentCursor];
                        }
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < result.length; ++i) {
                            result[i][0] = currentData.r;
                            result[i][1] = currentData.g;
                            result[i][2] = currentData.b;
                            result[i][3] = currentData.a;
                            if (nextData.pos != i) continue;
                            currentData = this.data[currentCursor++];
                            if (currentCursor >= this.data.length) continue;
                            nextData = this.data[currentCursor];
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown interpolation type: " + this.ipoType);
                    }
                }
            }
        }
        return result;
    }

    private ColorBandData getColorbandData(int index, Map<Integer, ColorBandData> cbDataMap) {
        ColorBandData result = cbDataMap.get(index);
        if (result == null) {
            result = new ColorBandData();
        }
        return result;
    }

    private void getIpoData(float d, float[] ipoFactors) {
        float d2 = d * d;
        float d3 = d2 * d;
        if (this.ipoType == 2) {
            ipoFactors[0] = -0.71f * d3 + 1.42f * d2 - 0.71f * d;
            ipoFactors[1] = 1.29f * d3 - 2.29f * d2 + 1.0f;
            ipoFactors[2] = -1.29f * d3 + 1.58f * d2 + 0.71f * d;
            ipoFactors[3] = 0.71f * d3 - 0.71f * d2;
        } else if (this.ipoType == 3) {
            ipoFactors[0] = -0.16666666f * d3 + 0.5f * d2 - 0.5f * d + 0.16666666f;
            ipoFactors[1] = 0.5f * d3 - d2 + 0.6666666f;
            ipoFactors[2] = -0.5f * d3 + 0.5f * d2 + 0.5f * d + 0.16666666f;
            ipoFactors[3] = 0.16666666f * d3;
        } else {
            throw new IllegalStateException("Cannot get interpolation data for other colorband types than B-spline and Cardinal!");
        }
    }

    private static class ColorBandData
    implements Cloneable {
        public final float r;
        public final float g;
        public final float b;
        public final float a;
        public int pos;

        public ColorBandData() {
            this.b = 0.0f;
            this.g = 0.0f;
            this.r = 0.0f;
            this.a = 1.0f;
        }

        private ColorBandData(ColorBandData data) {
            this.r = data.r;
            this.g = data.g;
            this.b = data.b;
            this.a = data.a;
            this.pos = data.pos;
        }

        public ColorBandData(Structure cbdataStructure) {
            this.r = ((Number)cbdataStructure.getFieldValue("r")).floatValue();
            this.g = ((Number)cbdataStructure.getFieldValue("g")).floatValue();
            this.b = ((Number)cbdataStructure.getFieldValue("b")).floatValue();
            this.a = ((Number)cbdataStructure.getFieldValue("a")).floatValue();
            this.pos = (int)(((Number)cbdataStructure.getFieldValue("pos")).floatValue() * 1000.0f);
        }

        public ColorBandData clone() {
            try {
                return (ColorBandData)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return new ColorBandData(this);
            }
        }

        public String toString() {
            return "P: " + this.pos + " [" + this.r + ", " + this.g + ", " + this.b + ", " + this.a + "]";
        }
    }
}

