/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap.picking;

import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;

public class BresenhamYUpGridTracer {
    protected Vector3f gridOrigin = new Vector3f();
    protected Vector3f gridSpacing = new Vector3f();
    protected Vector2f gridLocation = new Vector2f();
    protected Vector3f rayLocation = new Vector3f();
    protected Ray walkRay = new Ray();
    protected Direction stepDirection = Direction.None;
    protected float rayLength;
    protected static float TOLERANCE = 1.0E-7f;
    private int stepXDirection;
    private int stepZDirection;
    private float distToNextXIntersection;
    private float distToNextZIntersection;
    private float distBetweenXIntersections;
    private float distBetweenZIntersections;

    public void startWalk(Ray walkRay) {
        this.walkRay.set(walkRay);
        Vector3f direction = this.walkRay.getDirection();
        Vector3f start = this.walkRay.getOrigin().subtract(this.gridOrigin);
        this.gridLocation.x = (int)(start.x / this.gridSpacing.x);
        this.gridLocation.y = (int)(start.z / this.gridSpacing.z);
        Vector3f ooDirection = new Vector3f(1.0f / direction.x, 1.0f, 1.0f / direction.z);
        if (direction.x > TOLERANCE) {
            this.distToNextXIntersection = ((this.gridLocation.x + 1.0f) * this.gridSpacing.x - start.x) * ooDirection.x;
            this.distBetweenXIntersections = this.gridSpacing.x * ooDirection.x;
            this.stepXDirection = 1;
        } else if (direction.x < -TOLERANCE) {
            this.distToNextXIntersection = (start.x - this.gridLocation.x * this.gridSpacing.x) * -direction.x;
            this.distBetweenXIntersections = -this.gridSpacing.x * ooDirection.x;
            this.stepXDirection = -1;
        } else {
            this.distToNextXIntersection = Float.MAX_VALUE;
            this.distBetweenXIntersections = Float.MAX_VALUE;
            this.stepXDirection = 0;
        }
        if (direction.z > TOLERANCE) {
            this.distToNextZIntersection = ((this.gridLocation.y + 1.0f) * this.gridSpacing.z - start.z) * ooDirection.z;
            this.distBetweenZIntersections = this.gridSpacing.z * ooDirection.z;
            this.stepZDirection = 1;
        } else if (direction.z < -TOLERANCE) {
            this.distToNextZIntersection = (start.z - this.gridLocation.y * this.gridSpacing.z) * -direction.z;
            this.distBetweenZIntersections = -this.gridSpacing.z * ooDirection.z;
            this.stepZDirection = -1;
        } else {
            this.distToNextZIntersection = Float.MAX_VALUE;
            this.distBetweenZIntersections = Float.MAX_VALUE;
            this.stepZDirection = 0;
        }
        this.rayLocation.set(start);
        this.rayLength = 0.0f;
        this.stepDirection = Direction.None;
    }

    public void next() {
        if (this.distToNextXIntersection < this.distToNextZIntersection) {
            this.rayLength = this.distToNextXIntersection;
            this.gridLocation.x += (float)this.stepXDirection;
            this.distToNextXIntersection += this.distBetweenXIntersections;
            switch (this.stepXDirection) {
                case -1: {
                    this.stepDirection = Direction.NegativeX;
                    break;
                }
                case 0: {
                    this.stepDirection = Direction.None;
                    break;
                }
                case 1: {
                    this.stepDirection = Direction.PositiveX;
                }
            }
        } else {
            this.rayLength = this.distToNextZIntersection;
            this.gridLocation.y += (float)this.stepZDirection;
            this.distToNextZIntersection += this.distBetweenZIntersections;
            switch (this.stepZDirection) {
                case -1: {
                    this.stepDirection = Direction.NegativeZ;
                    break;
                }
                case 0: {
                    this.stepDirection = Direction.None;
                    break;
                }
                case 1: {
                    this.stepDirection = Direction.PositiveZ;
                }
            }
        }
        this.rayLocation.set(this.walkRay.direction).multLocal(this.rayLength).addLocal(this.walkRay.origin);
    }

    public Direction getLastStepDirection() {
        return this.stepDirection;
    }

    public boolean isRayPerpendicularToGrid() {
        return this.stepXDirection == 0 && this.stepZDirection == 0;
    }

    public Vector2f getGridLocation() {
        return this.gridLocation;
    }

    public Vector3f getGridOrigin() {
        return this.gridOrigin;
    }

    public Vector3f getGridSpacing() {
        return this.gridSpacing;
    }

    public void setGridLocation(Vector2f gridLocation) {
        this.gridLocation = gridLocation;
    }

    public void setGridOrigin(Vector3f gridOrigin) {
        this.gridOrigin = gridOrigin;
    }

    public void setGridSpacing(Vector3f gridSpacing) {
        this.gridSpacing = gridSpacing;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        None,
        PositiveX,
        NegativeX,
        PositiveY,
        NegativeY,
        PositiveZ,
        NegativeZ;

    }
}

