/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.converters.model;

import com.jme3.bounding.BoundingBox;
import com.jme3.math.Transform;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class FloatToFixed {
    private static final float shortSize = 65535.0f;
    private static final float shortOff = -0.5f;
    private static final float byteSize = 255.0f;
    private static final float byteOff = -0.5f;

    public static void convertToFixed(Geometry geom, VertexBuffer.Format posFmt, VertexBuffer.Format nmFmt, VertexBuffer.Format tcFmt) {
        geom.updateModelBound();
        BoundingBox bbox = (BoundingBox)geom.getModelBound();
        Mesh mesh = geom.getMesh();
        VertexBuffer positions = mesh.getBuffer(VertexBuffer.Type.Position);
        VertexBuffer normals = mesh.getBuffer(VertexBuffer.Type.Normal);
        VertexBuffer texcoords = mesh.getBuffer(VertexBuffer.Type.TexCoord);
        VertexBuffer indices = mesh.getBuffer(VertexBuffer.Type.Index);
        FloatBuffer fb = (FloatBuffer)positions.getData();
        if (posFmt != VertexBuffer.Format.Float) {
            Buffer newBuf = VertexBuffer.createBuffer(posFmt, positions.getNumComponents(), mesh.getVertexCount());
            Transform t = FloatToFixed.convertPositions(fb, bbox, newBuf);
            t.combineWithParent(geom.getLocalTransform());
            geom.setLocalTransform(t);
            VertexBuffer newPosVb = new VertexBuffer(VertexBuffer.Type.Position);
            newPosVb.setupData(positions.getUsage(), positions.getNumComponents(), posFmt, newBuf);
            mesh.clearBuffer(VertexBuffer.Type.Position);
            mesh.setBuffer(newPosVb);
        }
        fb = (FloatBuffer)normals.getData();
        ByteBuffer bb = BufferUtils.createByteBuffer(fb.capacity());
        FloatToFixed.convertNormals(fb, bb);
        normals = new VertexBuffer(VertexBuffer.Type.Normal);
        normals.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.Byte, bb);
        normals.setNormalized(true);
        mesh.clearBuffer(VertexBuffer.Type.Normal);
        mesh.setBuffer(normals);
        fb = (FloatBuffer)texcoords.getData();
        if (tcFmt != VertexBuffer.Format.Float) {
            Buffer newBuf = VertexBuffer.createBuffer(tcFmt, texcoords.getNumComponents(), mesh.getVertexCount());
            FloatToFixed.convertTexCoords2D(fb, newBuf);
            VertexBuffer newTcVb = new VertexBuffer(VertexBuffer.Type.TexCoord);
            newTcVb.setupData(texcoords.getUsage(), texcoords.getNumComponents(), tcFmt, newBuf);
            mesh.clearBuffer(VertexBuffer.Type.TexCoord);
            mesh.setBuffer(newTcVb);
        }
    }

    public static void compressIndexBuffer(Mesh mesh) {
        VertexBuffer.Format targetFmt;
        int vertCount = mesh.getVertexCount();
        VertexBuffer vb = mesh.getBuffer(VertexBuffer.Type.Index);
        if (vb.getFormat() == VertexBuffer.Format.UnsignedInt && vertCount <= 65535) {
            targetFmt = vertCount <= 256 ? VertexBuffer.Format.UnsignedByte : VertexBuffer.Format.UnsignedShort;
        } else if (vb.getFormat() == VertexBuffer.Format.UnsignedShort && vertCount <= 255) {
            targetFmt = VertexBuffer.Format.UnsignedByte;
        } else {
            return;
        }
        IndexBuffer src = mesh.getIndexBuffer();
        Buffer newBuf = VertexBuffer.createBuffer(targetFmt, vb.getNumComponents(), src.size());
        VertexBuffer newVb = new VertexBuffer(VertexBuffer.Type.Index);
        newVb.setupData(vb.getUsage(), vb.getNumComponents(), targetFmt, newBuf);
        mesh.clearBuffer(VertexBuffer.Type.Index);
        mesh.setBuffer(newVb);
        IndexBuffer dst = mesh.getIndexBuffer();
        for (int i = 0; i < src.size(); ++i) {
            dst.put(i, src.get(i));
        }
    }

    private static void convertToFixed(FloatBuffer input, IntBuffer output) {
        if (output.capacity() < input.capacity()) {
            throw new RuntimeException("Output must be at least as large as input!");
        }
        input.clear();
        output.clear();
        for (int i = 0; i < input.capacity(); ++i) {
            output.put((int)(input.get() * 65536.0f));
        }
        output.flip();
    }

    private static void convertToFloat(IntBuffer input, FloatBuffer output) {
        if (output.capacity() < input.capacity()) {
            throw new RuntimeException("Output must be at least as large as input!");
        }
        input.clear();
        output.clear();
        for (int i = 0; i < input.capacity(); ++i) {
            output.put((float)input.get() / 65536.0f);
        }
        output.flip();
    }

    private static void convertToUByte(FloatBuffer input, ByteBuffer output) {
        if (output.capacity() < input.capacity()) {
            throw new RuntimeException("Output must be at least as large as input!");
        }
        input.clear();
        output.clear();
        for (int i = 0; i < input.capacity(); ++i) {
            output.put((byte)(input.get() * 255.0f));
        }
        output.flip();
    }

    public static VertexBuffer convertToUByte(VertexBuffer vb) {
        FloatBuffer fb = (FloatBuffer)vb.getData();
        ByteBuffer bb = BufferUtils.createByteBuffer(fb.capacity());
        FloatToFixed.convertToUByte(fb, bb);
        VertexBuffer newVb = new VertexBuffer(vb.getBufferType());
        newVb.setupData(vb.getUsage(), vb.getNumComponents(), VertexBuffer.Format.UnsignedByte, bb);
        newVb.setNormalized(true);
        return newVb;
    }

    public static VertexBuffer convertToFixed(VertexBuffer vb) {
        if (vb.getFormat() == VertexBuffer.Format.Int) {
            return vb;
        }
        FloatBuffer fb = (FloatBuffer)vb.getData();
        IntBuffer ib = BufferUtils.createIntBuffer(fb.capacity());
        FloatToFixed.convertToFixed(fb, ib);
        VertexBuffer newVb = new VertexBuffer(vb.getBufferType());
        newVb.setupData(vb.getUsage(), vb.getNumComponents(), VertexBuffer.Format.Int, ib);
        return newVb;
    }

    public static VertexBuffer convertToFloat(VertexBuffer vb) {
        if (vb.getFormat() == VertexBuffer.Format.Float) {
            return vb;
        }
        IntBuffer ib = (IntBuffer)vb.getData();
        FloatBuffer fb = BufferUtils.createFloatBuffer(ib.capacity());
        FloatToFixed.convertToFloat(ib, fb);
        VertexBuffer newVb = new VertexBuffer(vb.getBufferType());
        newVb.setupData(vb.getUsage(), vb.getNumComponents(), VertexBuffer.Format.Float, fb);
        return newVb;
    }

    private static void convertNormals(FloatBuffer input, ByteBuffer output) {
        if (output.capacity() < input.capacity()) {
            throw new RuntimeException("Output must be at least as large as input!");
        }
        input.clear();
        output.clear();
        Vector3f temp = new Vector3f();
        int vertexCount = input.capacity() / 3;
        for (int i = 0; i < vertexCount; ++i) {
            BufferUtils.populateFromBuffer(temp, input, i);
            temp.multLocal(127.0f).addLocal(0.5f, 0.5f, 0.5f);
            byte v1 = (byte)temp.getX();
            byte v2 = (byte)temp.getY();
            byte v3 = (byte)temp.getZ();
            output.put(v1).put(v2).put(v3);
        }
    }

    private static void convertTexCoords2D(FloatBuffer input, Buffer output) {
        if (output.capacity() < input.capacity()) {
            throw new RuntimeException("Output must be at least as large as input!");
        }
        input.clear();
        output.clear();
        Vector2f temp = new Vector2f();
        int vertexCount = input.capacity() / 2;
        ShortBuffer sb = null;
        IntBuffer ib = null;
        if (output instanceof ShortBuffer) {
            sb = (ShortBuffer)output;
        } else if (output instanceof IntBuffer) {
            ib = (IntBuffer)output;
        } else {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < vertexCount; ++i) {
            BufferUtils.populateFromBuffer(temp, input, i);
            if (sb != null) {
                sb.put((short)(temp.getX() * 32767.0f));
                sb.put((short)(temp.getY() * 32767.0f));
                continue;
            }
            int v1 = (int)(temp.getX() * 65536.0f);
            int v2 = (int)(temp.getY() * 65536.0f);
            ib.put(v1).put(v2);
        }
    }

    private static Transform convertPositions(FloatBuffer input, BoundingBox bbox, Buffer output) {
        float dataTypeSize;
        float dataTypeOffset;
        if (output.capacity() < input.capacity()) {
            throw new RuntimeException("Output must be at least as large as input!");
        }
        Vector3f offset = bbox.getCenter().negate();
        Vector3f size = new Vector3f(bbox.getXExtent(), bbox.getYExtent(), bbox.getZExtent());
        size.multLocal(2.0f);
        ShortBuffer sb = null;
        ByteBuffer bb = null;
        if (output instanceof ShortBuffer) {
            sb = (ShortBuffer)output;
            dataTypeOffset = -0.5f;
            dataTypeSize = 65535.0f;
        } else {
            bb = (ByteBuffer)output;
            dataTypeOffset = -0.5f;
            dataTypeSize = 255.0f;
        }
        Vector3f scale = new Vector3f();
        scale.set(dataTypeSize, dataTypeSize, dataTypeSize).divideLocal(size);
        Vector3f invScale = new Vector3f();
        invScale.set(size).divideLocal(dataTypeSize);
        offset.multLocal(scale);
        offset.addLocal(dataTypeOffset, dataTypeOffset, dataTypeOffset);
        input.clear();
        output.clear();
        Vector3f temp = new Vector3f();
        int vertexCount = input.capacity() / 3;
        for (int i = 0; i < vertexCount; ++i) {
            byte by;
            byte by2;
            byte by3;
            BufferUtils.populateFromBuffer(temp, input, i);
            temp.multLocal(scale);
            temp.addLocal(offset);
            if (sb != null) {
                by3 = (short)temp.getX();
                by2 = (short)temp.getY();
                by = (short)temp.getZ();
                sb.put(by3).put(by2).put(by);
                continue;
            }
            by3 = (byte)temp.getX();
            by2 = (byte)temp.getY();
            by = (byte)temp.getZ();
            bb.put(by3).put(by2).put(by);
        }
        Transform transform = new Transform();
        transform.setTranslation(offset.negate().multLocal(invScale));
        transform.setScale(invScale);
        return transform;
    }
}

