/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio;

import com.jme3.asset.AssetKey;
import com.jme3.audio.AudioData;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioKey
extends AssetKey<AudioData> {
    private boolean stream;
    private boolean streamCache;

    public AudioKey(String name, boolean stream, boolean streamCache) {
        this(name, stream);
        this.streamCache = streamCache;
    }

    public AudioKey(String name, boolean stream) {
        super(name);
        this.stream = stream;
    }

    public AudioKey(String name) {
        super(name);
        this.stream = false;
    }

    public AudioKey() {
    }

    @Override
    public String toString() {
        return this.name + (this.stream ? (this.streamCache ? " (Stream/Cache)" : " (Stream)") : " (Buffer)");
    }

    public boolean isStream() {
        return this.stream;
    }

    public boolean useStreamCache() {
        return this.streamCache;
    }

    @Override
    public boolean shouldCache() {
        return !this.stream && !this.streamCache;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.stream, "do_stream", false);
        oc.write(this.streamCache, "use_stream_cache", false);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.stream = ic.readBoolean("do_stream", false);
        this.streamCache = ic.readBoolean("use_stream_cache", false);
    }
}

