/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.collision;

import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollisionResult
implements Comparable<CollisionResult> {
    private Geometry geometry;
    private Vector3f contactPoint;
    private Vector3f contactNormal;
    private float distance;
    private int triangleIndex;

    public CollisionResult(Geometry geometry, Vector3f contactPoint, float distance, int triangleIndex) {
        this.geometry = geometry;
        this.contactPoint = contactPoint;
        this.distance = distance;
        this.triangleIndex = triangleIndex;
    }

    public CollisionResult(Vector3f contactPoint, float distance) {
        this.contactPoint = contactPoint;
        this.distance = distance;
    }

    public CollisionResult() {
    }

    public void setGeometry(Geometry geom) {
        this.geometry = geom;
    }

    public void setContactNormal(Vector3f norm) {
        this.contactNormal = norm;
    }

    public void setContactPoint(Vector3f point) {
        this.contactPoint = point;
    }

    public void setDistance(float dist) {
        this.distance = dist;
    }

    public void setTriangleIndex(int index) {
        this.triangleIndex = index;
    }

    public Triangle getTriangle(Triangle store) {
        if (store == null) {
            store = new Triangle();
        }
        Mesh m = this.geometry.getMesh();
        m.getTriangle(this.triangleIndex, store);
        store.calculateCenter();
        store.calculateNormal();
        return store;
    }

    @Override
    public int compareTo(CollisionResult other) {
        if (this.distance < other.distance) {
            return -1;
        }
        if (this.distance > other.distance) {
            return 1;
        }
        return 0;
    }

    public Vector3f getContactPoint() {
        return this.contactPoint;
    }

    public Vector3f getContactNormal() {
        return this.contactNormal;
    }

    public float getDistance() {
        return this.distance;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public int getTriangleIndex() {
        return this.triangleIndex;
    }
}

