/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.serializing.serializers;

import com.jme3.network.serializing.Serializer;
import com.jme3.network.serializing.SerializerRegistration;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSerializer
extends Serializer {
    @Override
    public <T> T readObject(ByteBuffer data, Class<T> c) throws IOException {
        SerializerRegistration reg;
        HashMap<Object, Object> map;
        int length = data.getInt();
        try {
            map = (HashMap<Object, Object>)c.newInstance();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "[Serializer][???] Could not determine map type. Using HashMap.");
            map = new HashMap<Object, Object>();
        }
        if (length == 0) {
            return (T)map;
        }
        int flags = data.get() & 0xFF;
        boolean uniqueKeys = (flags & 1) == 0;
        boolean uniqueVals = (flags & 2) == 0;
        Class keyClazz = null;
        Class valClazz = null;
        Serializer keySerial = null;
        Serializer valSerial = null;
        if (!uniqueKeys) {
            reg = Serializer.readClass(data);
            keyClazz = reg.getType();
            keySerial = reg.getSerializer();
        }
        if (!uniqueVals) {
            reg = Serializer.readClass(data);
            valClazz = reg.getType();
            valSerial = reg.getSerializer();
        }
        for (int i = 0; i < length; ++i) {
            Object key = uniqueKeys ? Serializer.readClassAndObject(data) : keySerial.readObject(data, keyClazz);
            Object value = uniqueVals ? Serializer.readClassAndObject(data) : valSerial.readObject(data, valClazz);
            map.put(key, value);
        }
        return (T)map;
    }

    @Override
    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        Map map = (Map)object;
        int length = map.size();
        buffer.putInt(length);
        if (length == 0) {
            return;
        }
        Set entries = map.entrySet();
        Iterator it = entries.iterator();
        Map.Entry entry2 = it.next();
        Class<?> keyClass = entry2.getKey().getClass();
        Class<?> valClass = entry2.getValue().getClass();
        while (it.hasNext()) {
            entry2 = it.next();
            if (entry2.getKey().getClass() != keyClass) {
                keyClass = null;
                if (valClass == null) break;
            }
            if (entry2.getValue().getClass() == valClass) continue;
            valClass = null;
            if (keyClass != null) continue;
        }
        boolean uniqueKeys = keyClass == null;
        boolean uniqueVals = valClass == null;
        int flags = 0;
        if (!uniqueKeys) {
            flags |= 1;
        }
        if (!uniqueVals) {
            flags |= 2;
        }
        buffer.put((byte)flags);
        Serializer keySerial = null;
        Serializer valSerial = null;
        if (!uniqueKeys) {
            Serializer.writeClass(buffer, keyClass);
            keySerial = Serializer.getSerializer(keyClass);
        }
        if (!uniqueVals) {
            Serializer.writeClass(buffer, valClass);
            valSerial = Serializer.getSerializer(valClass);
        }
        for (Map.Entry entry2 : entries) {
            if (uniqueKeys) {
                Serializer.writeClassAndObject(buffer, entry2.getKey());
            } else {
                keySerial.writeObject(buffer, entry2.getKey());
            }
            if (uniqueVals) {
                Serializer.writeClassAndObject(buffer, entry2.getValue());
                continue;
            }
            valSerial.writeObject(buffer, entry2.getValue());
        }
    }
}

