/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.curves;

import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Spline;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.curves.BezierCurve;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialContext;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.objects.Properties;
import com.jme3.scene.shape.Curve;
import com.jme3.scene.shape.Surface;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurvesHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(CurvesHelper.class.getName());
    protected int minimumBasisUFunctionDegree = 4;
    protected int minimumBasisVFunctionDegree = 4;

    public CurvesHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion, blenderContext);
    }

    public List<Geometry> toCurve(Structure curveStructure, BlenderContext blenderContext) throws BlenderFileException {
        boolean isBack;
        String name = curveStructure.getName();
        int flag = ((Number)curveStructure.getFieldValue("flag")).intValue();
        boolean is3D = (flag & 1) != 0;
        boolean isFront = (flag & 2) != 0 && !is3D;
        boolean bl = isBack = (flag & 4) != 0 && !is3D;
        if (isFront) {
            LOGGER.warning("No front face in curve implemented yet!");
        }
        if (isBack) {
            LOGGER.warning("No back face in curve implemented yet!");
        }
        List<Structure> nurbStructures = ((Structure)curveStructure.getFieldValue("nurb")).evaluateListBase(blenderContext);
        HashMap<Number, ArrayList<Structure>> nurbs = new HashMap<Number, ArrayList<Structure>>();
        for (Structure nurb : nurbStructures) {
            Number matNumber = (Number)nurb.getFieldValue("mat_nr");
            ArrayList<Structure> nurbList = (ArrayList<Structure>)nurbs.get(matNumber);
            if (nurbList == null) {
                nurbList = new ArrayList<Structure>();
                nurbs.put(matNumber, nurbList);
            }
            nurbList.add(nurb);
        }
        MaterialHelper materialHelper = (MaterialHelper)blenderContext.getHelper(MaterialHelper.class);
        MaterialContext[] materialContexts = materialHelper.getMaterials(curveStructure, blenderContext);
        Material defaultMaterial = null;
        if (materialContexts != null) {
            for (MaterialContext materialContext : materialContexts) {
                materialContext.setFaceCullMode(RenderState.FaceCullMode.Off);
            }
        } else {
            defaultMaterial = blenderContext.getDefaultMaterial().clone();
            defaultMaterial.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        }
        List<Geometry> bevelObject = null;
        Pointer pBevelObject = (Pointer)curveStructure.getFieldValue("bevobj");
        if (pBevelObject.isNotNull()) {
            Pointer pBevelStructure = (Pointer)pBevelObject.fetchData(blenderContext.getInputStream()).get(0).getFieldValue("data");
            Structure bevelStructure = pBevelStructure.fetchData(blenderContext.getInputStream()).get(0);
            bevelObject = this.toCurve(bevelStructure, blenderContext);
        } else {
            int bevResol = ((Number)curveStructure.getFieldValue("bevresol")).intValue();
            float extrude = ((Number)curveStructure.getFieldValue("ext1")).floatValue();
            float bevelDepth = ((Number)curveStructure.getFieldValue("ext2")).floatValue();
            if (bevelDepth > 0.0f) {
                float handlerLength = bevelDepth / 2.0f;
                ArrayList<Vector3f> conrtolPoints = new ArrayList<Vector3f>(extrude > 0.0f ? 19 : 13);
                if (extrude > 0.0f) {
                    conrtolPoints.add(new Vector3f(-bevelDepth, 0.0f, extrude));
                    conrtolPoints.add(new Vector3f(-bevelDepth, 0.0f, -handlerLength + extrude));
                    conrtolPoints.add(new Vector3f(-bevelDepth, 0.0f, handlerLength - extrude));
                }
                conrtolPoints.add(new Vector3f(-bevelDepth, 0.0f, -extrude));
                conrtolPoints.add(new Vector3f(-bevelDepth, 0.0f, -handlerLength - extrude));
                conrtolPoints.add(new Vector3f(-handlerLength, 0.0f, -bevelDepth - extrude));
                conrtolPoints.add(new Vector3f(0.0f, 0.0f, -bevelDepth - extrude));
                conrtolPoints.add(new Vector3f(handlerLength, 0.0f, -bevelDepth - extrude));
                if (extrude > 0.0f) {
                    conrtolPoints.add(new Vector3f(bevelDepth, 0.0f, -extrude - handlerLength));
                    conrtolPoints.add(new Vector3f(bevelDepth, 0.0f, -extrude));
                    conrtolPoints.add(new Vector3f(bevelDepth, 0.0f, -extrude + handlerLength));
                }
                conrtolPoints.add(new Vector3f(bevelDepth, 0.0f, extrude - handlerLength));
                conrtolPoints.add(new Vector3f(bevelDepth, 0.0f, extrude));
                conrtolPoints.add(new Vector3f(bevelDepth, 0.0f, extrude + handlerLength));
                conrtolPoints.add(new Vector3f(handlerLength, 0.0f, bevelDepth + extrude));
                conrtolPoints.add(new Vector3f(0.0f, 0.0f, bevelDepth + extrude));
                conrtolPoints.add(new Vector3f(-handlerLength, 0.0f, bevelDepth + extrude));
                conrtolPoints.add(new Vector3f(-bevelDepth, 0.0f, handlerLength + extrude));
                conrtolPoints.add(new Vector3f(-bevelDepth, 0.0f, extrude));
                Spline bevelSpline = new Spline(Spline.SplineType.Bezier, conrtolPoints, 0.0f, false);
                Curve bevelCurve = new Curve(bevelSpline, bevResol);
                bevelObject = new ArrayList<Geometry>(1);
                bevelObject.add(new Geometry("", bevelCurve));
            } else if (extrude > 0.0f) {
                Spline bevelSpline = new Spline(Spline.SplineType.Linear, new Vector3f[]{new Vector3f(0.0f, 0.0f, -extrude), new Vector3f(0.0f, 0.0f, extrude)}, 1.0f, false);
                Curve bevelCurve = new Curve(bevelSpline, bevResol);
                bevelObject = new ArrayList<Geometry>(1);
                bevelObject.add(new Geometry("", bevelCurve));
            }
        }
        Spline taperObject = null;
        Pointer pTaperObject = (Pointer)curveStructure.getFieldValue("taperobj");
        if (bevelObject != null && pTaperObject.isNotNull()) {
            Pointer pTaperStructure = (Pointer)pTaperObject.fetchData(blenderContext.getInputStream()).get(0).getFieldValue("data");
            Structure taperStructure = pTaperStructure.fetchData(blenderContext.getInputStream()).get(0);
            taperObject = this.loadTaperObject(taperStructure, blenderContext);
        }
        Vector3f loc = this.getLoc(curveStructure);
        ArrayList<Geometry> result = new ArrayList<Geometry>(nurbs.size());
        for (Map.Entry nurbEntry : nurbs.entrySet()) {
            for (Structure nurb : (List)nurbEntry.getValue()) {
                int type = ((Number)nurb.getFieldValue("type")).intValue();
                List<Geometry> nurbGeoms = null;
                if ((type & 1) != 0) {
                    nurbGeoms = this.loadBezierCurve(loc, nurb, bevelObject, taperObject, blenderContext);
                } else if ((type & 4) != 0) {
                    nurbGeoms = this.loadNurb(loc, nurb, bevelObject, taperObject, blenderContext);
                }
                if (nurbGeoms == null) continue;
                for (Geometry nurbGeom : nurbGeoms) {
                    if (materialContexts != null) {
                        materialContexts[((Number)nurbEntry.getKey()).intValue()].applyMaterial(nurbGeom, curveStructure.getOldMemoryAddress(), null, blenderContext);
                    } else {
                        nurbGeom.setMaterial(defaultMaterial);
                    }
                    nurbGeom.setName(name);
                    result.add(nurbGeom);
                }
            }
        }
        if (blenderContext.getBlenderKey().isLoadObjectProperties()) {
            Properties properties = this.loadProperties(curveStructure, blenderContext);
            if (result instanceof Spatial && properties != null && properties.getValue() != null) {
                this.applyProperties((Spatial)((Object)result), properties);
            }
        }
        return result;
    }

    protected List<Geometry> loadBezierCurve(Vector3f loc, Structure nurb, List<Geometry> bevelObject, Spline taperObject, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pBezierTriple = (Pointer)nurb.getFieldValue("bezt");
        List<Geometry> result = new ArrayList<Geometry>();
        if (pBezierTriple.isNotNull()) {
            boolean smooth = (((Number)nurb.getFlatFieldValue("flag")).intValue() & 1) != 0;
            int resolution = ((Number)nurb.getFieldValue("resolu")).intValue();
            boolean cyclic = (((Number)nurb.getFieldValue("flagu")).intValue() & 1) != 0;
            BezierCurve bezierCurve = new BezierCurve(0, pBezierTriple.fetchData(blenderContext.getInputStream()), 3);
            List<Vector3f> controlPoints = bezierCurve.getControlPoints();
            if (this.fixUpAxis) {
                for (Vector3f v : controlPoints) {
                    float y = v.y;
                    v.y = v.z;
                    v.z = -y;
                }
            }
            if (bevelObject != null && taperObject == null) {
                int triplesCount = controlPoints.size() / 3;
                ArrayList<Vector3f> taperControlPoints = new ArrayList<Vector3f>(triplesCount);
                for (int i = 0; i < triplesCount; ++i) {
                    taperControlPoints.add(new Vector3f(controlPoints.get((int)(i * 3 + 1)).x, bezierCurve.getRadius(i), 0.0f));
                }
                taperObject = new Spline(Spline.SplineType.Linear, taperControlPoints, 0.0f, false);
            }
            if (cyclic) {
                for (int i = 0; i < 3; ++i) {
                    controlPoints.add(controlPoints.get(i));
                }
            }
            controlPoints.remove(0);
            controlPoints.remove(controlPoints.size() - 1);
            Spline spline = new Spline(Spline.SplineType.Bezier, controlPoints, 0.0f, false);
            Curve curve = new Curve(spline, resolution);
            if (bevelObject == null) {
                Geometry curveGeometry = new Geometry(null, curve);
                result.add(curveGeometry);
            } else {
                result = this.applyBevelAndTaper(curve, bevelObject, taperObject, smooth, blenderContext);
            }
        }
        return result;
    }

    protected List<Geometry> loadNurb(Vector3f loc, Structure nurb, List<Geometry> bevelObject, Spline taperObject, BlenderContext blenderContext) throws BlenderFileException {
        List<Object> result;
        List[] knots = new List[2];
        Pointer[] pKnots = new Pointer[]{(Pointer)nurb.getFieldValue("knotsu"), (Pointer)nurb.getFieldValue("knotsv")};
        for (int i = 0; i < knots.length; ++i) {
            if (!pKnots[i].isNotNull()) continue;
            FileBlockHeader fileBlockHeader = blenderContext.getFileBlock(pKnots[i].getOldMemoryAddress());
            BlenderInputStream blenderInputStream = blenderContext.getInputStream();
            blenderInputStream.setPosition(fileBlockHeader.getBlockPosition());
            int knotsAmount = fileBlockHeader.getCount() * fileBlockHeader.getSize() / 4;
            knots[i] = new ArrayList(knotsAmount);
            for (int j = 0; j < knotsAmount; ++j) {
                knots[i].add(Float.valueOf(blenderInputStream.readFloat()));
            }
        }
        int flagU = ((Number)nurb.getFieldValue("flagu")).intValue();
        int flagV = ((Number)nurb.getFieldValue("flagv")).intValue();
        int orderU = ((Number)nurb.getFieldValue("orderu")).intValue();
        int orderV = ((Number)nurb.getFieldValue("orderv")).intValue();
        int pntsU = ((Number)nurb.getFieldValue("pntsu")).intValue();
        int pntsV = ((Number)nurb.getFieldValue("pntsv")).intValue();
        List<Structure> bPoints = ((Pointer)nurb.getFieldValue("bp")).fetchData(blenderContext.getInputStream());
        ArrayList<List<Vector4f>> controlPoints = new ArrayList<List<Vector4f>>(pntsV);
        for (int i = 0; i < pntsV; ++i) {
            ArrayList<Vector4f> uControlPoints = new ArrayList<Vector4f>(pntsU);
            for (int j = 0; j < pntsU; ++j) {
                DynamicArray vec = (DynamicArray)bPoints.get(j + i * pntsU).getFieldValue("vec");
                if (this.fixUpAxis) {
                    uControlPoints.add(new Vector4f(((Float)vec.get(0)).floatValue(), ((Float)vec.get(2)).floatValue(), -((Float)vec.get(1)).floatValue(), ((Float)vec.get(3)).floatValue()));
                    continue;
                }
                uControlPoints.add(new Vector4f(((Float)vec.get(0)).floatValue(), ((Float)vec.get(1)).floatValue(), ((Float)vec.get(2)).floatValue(), ((Float)vec.get(3)).floatValue()));
            }
            if ((flagU & 1) != 0) {
                for (int k = 0; k < orderU - 1; ++k) {
                    uControlPoints.add((Vector4f)uControlPoints.get(k));
                }
            }
            controlPoints.add(uControlPoints);
        }
        if ((flagV & 1) != 0) {
            for (int k = 0; k < orderV - 1; ++k) {
                controlPoints.add((List<Vector4f>)controlPoints.get(k));
            }
        }
        int resolu = ((Number)nurb.getFieldValue("resolu")).intValue() + 1;
        if (knots[1] == null) {
            Spline nurbSpline = new Spline((List)controlPoints.get(0), knots[0]);
            Curve nurbCurve = new Curve(nurbSpline, resolu);
            if (bevelObject != null) {
                result = this.applyBevelAndTaper(nurbCurve, bevelObject, taperObject, true, blenderContext);
            } else {
                result = new ArrayList(1);
                Geometry nurbGeometry = new Geometry("", nurbCurve);
                result.add(nurbGeometry);
            }
        } else {
            int resolv = ((Number)nurb.getFieldValue("resolv")).intValue() + 1;
            Surface nurbSurface = Surface.createNurbsSurface(controlPoints, knots, resolu, resolv, orderU, orderV);
            Geometry nurbGeometry = new Geometry("", nurbSurface);
            result = new ArrayList(1);
            result.add(nurbGeometry);
        }
        return result;
    }

    protected float getTaperScale(Spline taper, float percent) {
        int i;
        if (taper == null) {
            return 1.0f;
        }
        percent = FastMath.clamp(percent, 0.0f, 1.0f);
        List<Float> segmentLengths = taper.getSegmentsLength();
        float percentLength = taper.getTotalLength() * percent;
        float partLength = 0.0f;
        for (i = 0; i < segmentLengths.size(); ++i) {
            if (!((partLength += segmentLengths.get(i).floatValue()) > percentLength)) continue;
            percent = (percentLength -= (partLength -= segmentLengths.get(i).floatValue())) / segmentLengths.get(i).floatValue();
            break;
        }
        if (percent >= 1.0f) {
            percent = 1.0f;
            --i;
        }
        if (taper.getType() == Spline.SplineType.Bezier) {
            i *= 3;
        }
        return taper.interpolate((float)percent, (int)i, null).y;
    }

    protected List<Geometry> applyBevelAndTaper(Curve curve, List<Geometry> bevelObject, Spline taperObject, boolean smooth, BlenderContext blenderContext) {
        Vector3f[] curvePoints = BufferUtils.getVector3Array(curve.getFloatBuffer(VertexBuffer.Type.Position));
        Vector3f subtractResult = new Vector3f();
        float curveLength = curve.getLength();
        FloatBuffer[] vertexBuffers = new FloatBuffer[bevelObject.size()];
        FloatBuffer[] normalBuffers = new FloatBuffer[bevelObject.size()];
        IndexBuffer[] indexBuffers = new IndexBuffer[bevelObject.size()];
        for (int geomIndex = 0; geomIndex < bevelObject.size(); ++geomIndex) {
            int i;
            Mesh mesh = bevelObject.get(geomIndex).getMesh();
            Vector3f[] positions = BufferUtils.getVector3Array(mesh.getFloatBuffer(VertexBuffer.Type.Position));
            Vector3f[] bevelPoints = this.transformToFirstLineOfBevelPoints(positions, curvePoints[0], curvePoints[1]);
            ArrayList<Vector3f[]> bevels = new ArrayList<Vector3f[]>(curvePoints.length);
            bevels.add(bevelPoints);
            vertexBuffers[geomIndex] = BufferUtils.createFloatBuffer(bevelPoints.length * 3 * curvePoints.length * (smooth ? 1 : 6));
            for (int i2 = 1; i2 < curvePoints.length - 1; ++i2) {
                bevelPoints = this.transformBevel(bevelPoints, curvePoints[i2 - 1], curvePoints[i2], curvePoints[i2 + 1]);
                bevels.add(bevelPoints);
            }
            bevelPoints = this.transformBevel(bevelPoints, curvePoints[curvePoints.length - 2], curvePoints[curvePoints.length - 1], null);
            bevels.add(bevelPoints);
            if (bevels.size() > 2) {
                int[][] pointIndexes;
                for (int[] indexes : pointIndexes = new int[][]{{0, 1}, {curvePoints.length - 1, curvePoints.length - 2}}) {
                    float distance = curvePoints[indexes[1]].subtract(curvePoints[indexes[0]], subtractResult).length();
                    Vector3f[] bevel = (Vector3f[])bevels.get(indexes[0]);
                    Vector3f[] nextBevel = (Vector3f[])bevels.get(indexes[1]);
                    for (int i3 = 0; i3 < bevel.length; ++i3) {
                        float d = bevel[i3].subtract(nextBevel[i3], subtractResult).length();
                        subtractResult.normalizeLocal().multLocal(distance - d);
                        bevel[i3].addLocal(subtractResult);
                    }
                }
            }
            float lengthAlongCurve = 0.0f;
            for (i = 0; i < curvePoints.length; ++i) {
                if (i > 0) {
                    lengthAlongCurve += curvePoints[i].subtract(curvePoints[i - 1], subtractResult).length();
                }
                float taperScale = this.getTaperScale(taperObject, i == 0 ? 0.0f : lengthAlongCurve / curveLength);
                this.applyScale((Vector3f[])bevels.get(i), curvePoints[i], taperScale);
            }
            if (smooth) {
                Iterator i$ = bevels.iterator();
                while (i$.hasNext()) {
                    Vector3f[] bevel;
                    for (Vector3f d : bevel = (Vector3f[])i$.next()) {
                        vertexBuffers[geomIndex].put(d.x);
                        vertexBuffers[geomIndex].put(d.y);
                        vertexBuffers[geomIndex].put(d.z);
                    }
                }
            } else {
                for (i = 0; i < curvePoints.length - 1; ++i) {
                    for (int j = 0; j < bevelPoints.length - 1; ++j) {
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)i))[j].x);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)i))[j].y);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)i))[j].z);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)i))[j + 1].x);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)i))[j + 1].y);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)i))[j + 1].z);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)(i + 1)))[j].x);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)(i + 1)))[j].y);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)(i + 1)))[j].z);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)i))[j + 1].x);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)i))[j + 1].y);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)i))[j + 1].z);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)(i + 1)))[j + 1].x);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)(i + 1)))[j + 1].y);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)(i + 1)))[j + 1].z);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)(i + 1)))[j].x);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)(i + 1)))[j].y);
                        vertexBuffers[geomIndex].put(((Vector3f[])bevels.get((int)(i + 1)))[j].z);
                    }
                }
            }
            indexBuffers[geomIndex] = this.generateIndexes(bevelPoints.length, curvePoints.length, smooth);
            normalBuffers[geomIndex] = this.generateNormals(indexBuffers[geomIndex], vertexBuffers[geomIndex], smooth);
        }
        ArrayList<Geometry> result = new ArrayList<Geometry>(vertexBuffers.length);
        Float oneReferenceToCurveLength = new Float(curveLength);
        for (int i = 0; i < vertexBuffers.length; ++i) {
            Mesh mesh = new Mesh();
            mesh.setBuffer(VertexBuffer.Type.Position, 3, vertexBuffers[i]);
            if (indexBuffers[i].getBuffer() instanceof IntBuffer) {
                mesh.setBuffer(VertexBuffer.Type.Index, 3, (IntBuffer)indexBuffers[i].getBuffer());
            } else {
                mesh.setBuffer(VertexBuffer.Type.Index, 3, (ShortBuffer)indexBuffers[i].getBuffer());
            }
            mesh.setBuffer(VertexBuffer.Type.Normal, 3, normalBuffers[i]);
            Geometry g = new Geometry("g" + i, mesh);
            g.setUserData("curveLength", oneReferenceToCurveLength);
            g.updateModelBound();
            result.add(g);
        }
        return result;
    }

    private void applyScale(Vector3f[] points, Vector3f centerPoint, float scale) {
        Vector3f taperScaleVector = new Vector3f();
        for (Vector3f p : points) {
            taperScaleVector.set(centerPoint).subtractLocal(p).multLocal(1.0f - scale);
            p.addLocal(taperScaleVector);
        }
    }

    private FloatBuffer generateNormals(IndexBuffer indexes, FloatBuffer points, boolean smooth) {
        TreeMap<Integer, Vector3f> normalMap = new TreeMap<Integer, Vector3f>();
        Vector3f[] allVerts = BufferUtils.getVector3Array(points);
        for (int i = 0; i < indexes.size(); i += 3) {
            int index1 = indexes.get(i);
            int index2 = indexes.get(i + 1);
            int index3 = indexes.get(i + 2);
            Vector3f n = FastMath.computeNormal(allVerts[index1], allVerts[index2], allVerts[index3]);
            this.addNormal(n, normalMap, smooth, index1, index2, index3);
        }
        FloatBuffer normals = BufferUtils.createFloatBuffer(normalMap.size() * 3);
        for (Map.Entry entry : normalMap.entrySet()) {
            normals.put(((Vector3f)entry.getValue()).x);
            normals.put(((Vector3f)entry.getValue()).y);
            normals.put(((Vector3f)entry.getValue()).z);
        }
        return normals;
    }

    private IndexBuffer generateIndexes(int bevelShapeVertexCount, int bevelRepeats, boolean smooth) {
        int putIndex = 0;
        if (smooth) {
            int indexBufferSize = (bevelRepeats - 1) * (bevelShapeVertexCount - 1) * 6;
            IndexBuffer result = IndexBuffer.createIndexBuffer(indexBufferSize, indexBufferSize);
            for (int i = 0; i < bevelRepeats - 1; ++i) {
                for (int j = 0; j < bevelShapeVertexCount - 1; ++j) {
                    result.put(putIndex++, i * bevelShapeVertexCount + j);
                    result.put(putIndex++, i * bevelShapeVertexCount + j + 1);
                    result.put(putIndex++, (i + 1) * bevelShapeVertexCount + j);
                    result.put(putIndex++, i * bevelShapeVertexCount + j + 1);
                    result.put(putIndex++, (i + 1) * bevelShapeVertexCount + j + 1);
                    result.put(putIndex++, (i + 1) * bevelShapeVertexCount + j);
                }
            }
            return result;
        }
        int indexBufferSize = bevelShapeVertexCount * bevelRepeats * 6;
        IndexBuffer result = IndexBuffer.createIndexBuffer(indexBufferSize, indexBufferSize);
        for (int i = 0; i < indexBufferSize; ++i) {
            result.put(putIndex++, i);
        }
        return result;
    }

    private Vector3f[] transformBevel(Vector3f[] bevel, Vector3f prevPos, Vector3f currPos, Vector3f nextPos) {
        bevel = (Vector3f[])bevel.clone();
        Vector3f directionVector = prevPos != null ? currPos.subtract(prevPos) : nextPos.subtract(currPos);
        directionVector.normalizeLocal();
        Vector3f planeNormal = null;
        if (prevPos != null) {
            planeNormal = currPos.subtract(prevPos).normalizeLocal();
            if (nextPos != null) {
                planeNormal.addLocal(nextPos.subtract(currPos).normalizeLocal()).normalizeLocal();
            }
        } else {
            planeNormal = nextPos.subtract(currPos).normalizeLocal();
        }
        float D = -planeNormal.dot(currPos);
        float temp = planeNormal.dot(directionVector);
        for (int i = 0; i < bevel.length; ++i) {
            float t = -(planeNormal.dot(bevel[i]) + D) / temp;
            bevel[i] = this.fixUpAxis ? new Vector3f(bevel[i].x + directionVector.x * t, bevel[i].y + directionVector.y * t, bevel[i].z + directionVector.z * t) : new Vector3f(bevel[i].x + directionVector.x * t, -bevel[i].z + directionVector.z * t, bevel[i].y + directionVector.y * t);
        }
        return bevel;
    }

    private Vector3f[] transformToFirstLineOfBevelPoints(Vector3f[] startingLinePoints, Vector3f firstCurvePoint, Vector3f secondCurvePoint) {
        Vector3f planeNormal = secondCurvePoint.subtract(firstCurvePoint).normalizeLocal();
        float angle = FastMath.acos(planeNormal.dot(Vector3f.UNIT_Y));
        planeNormal.crossLocal(Vector3f.UNIT_Y).normalizeLocal();
        Quaternion pointRotation = new Quaternion();
        pointRotation.fromAngleAxis(angle, planeNormal);
        Matrix4f m = new Matrix4f();
        m.setRotationQuaternion(pointRotation);
        m.setTranslation(firstCurvePoint);
        float[] temp = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        Vector3f[] verts = new Vector3f[startingLinePoints.length];
        for (int j = 0; j < verts.length; ++j) {
            temp[0] = startingLinePoints[j].x;
            temp[1] = startingLinePoints[j].y;
            temp[2] = startingLinePoints[j].z;
            temp = m.mult(temp);
            verts[j] = this.fixUpAxis ? new Vector3f(temp[0], -temp[2], temp[1]) : new Vector3f(temp[0], temp[1], temp[2]);
        }
        return verts;
    }

    private void addNormal(Vector3f normalToAdd, Map<Integer, Vector3f> normalMap, boolean smooth, int ... indexes) {
        for (int index : indexes) {
            Vector3f n = normalMap.get(index);
            if (!smooth || n == null) {
                normalMap.put(index, normalToAdd.clone());
                continue;
            }
            n.addLocal(normalToAdd).normalizeLocal();
        }
    }

    protected Spline loadTaperObject(Structure taperStructure, BlenderContext blenderContext) throws BlenderFileException {
        List<Structure> nurbStructures = ((Structure)taperStructure.getFieldValue("nurb")).evaluateListBase(blenderContext);
        for (Structure nurb : nurbStructures) {
            Pointer pBezierTriple = (Pointer)nurb.getFieldValue("bezt");
            if (!pBezierTriple.isNotNull()) continue;
            BezierCurve bezierCurve = new BezierCurve(0, pBezierTriple.fetchData(blenderContext.getInputStream()), 3);
            List<Vector3f> controlPoints = bezierCurve.getControlPoints();
            controlPoints.remove(0);
            controlPoints.remove(controlPoints.size() - 1);
            if (controlPoints.size() <= 3) continue;
            return new Spline(Spline.SplineType.Bezier, controlPoints, 0.0f, false);
        }
        return null;
    }

    protected Vector3f getLoc(Structure curveStructure) {
        DynamicArray locArray = (DynamicArray)curveStructure.getFieldValue("loc");
        if (this.fixUpAxis) {
            return new Vector3f(((Number)locArray.get(0)).floatValue(), ((Number)locArray.get(1)).floatValue(), -((Number)locArray.get(2)).floatValue());
        }
        return new Vector3f(((Number)locArray.get(0)).floatValue(), ((Number)locArray.get(2)).floatValue(), ((Number)locArray.get(1)).floatValue());
    }

    @Override
    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return true;
    }
}

